/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleCodeSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeSitemapGenerator
extends SitemapGenerator<GoogleCodeSitemapUrl, GoogleCodeSitemapGenerator> {
    GoogleCodeSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    public GoogleCodeSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleCodeSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public static SitemapGeneratorBuilder<GoogleCodeSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleCodeSitemapGenerator>(baseUrl, baseDir, GoogleCodeSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleCodeSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleCodeSitemapGenerator>(baseUrl, baseDir, GoogleCodeSitemapGenerator.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleCodeSitemapUrl>
    implements ISitemapUrlRenderer<GoogleCodeSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleCodeSitemapUrl> getUrlClass() {
            return GoogleCodeSitemapUrl.class;
        }

        @Override
        public void render(GoogleCodeSitemapUrl url, OutputStreamWriter out, W3CDateFormat dateFormat) throws IOException {
            StringBuilder sb = new StringBuilder();
            sb.append("    <codesearch:codesearch>\n");
            this.renderTag(sb, "codesearch", "filetype", url.getFileType());
            this.renderTag(sb, "codesearch", "license", url.getLicense());
            this.renderTag(sb, "codesearch", "filename", url.getFileName());
            this.renderTag(sb, "codesearch", "packageurl", url.getPackageUrl());
            this.renderTag(sb, "codesearch", "packagemap", url.getPackageMap());
            sb.append("    </codesearch:codesearch>\n");
            super.render(url, out, dateFormat, sb.toString());
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:codesearch=\"http://www.google.com/codesearch/schemas/sitemap/1.0\"";
        }
    }
}

