/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia;

import com.google.code.morphia.Mapper;
import com.google.code.morphia.MongoMappingException;
import com.google.code.morphia.Validator;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class Morphia {
    private final Mapper mapper;
    private final Validator validator;

    public Morphia() {
        this(true, Collections.EMPTY_SET);
    }

    public Morphia(boolean dynamicInstantiation, Set<Class> classesToMap) {
        this.mapper = new Mapper(dynamicInstantiation);
        this.validator = new Validator();
        for (Class c : classesToMap) {
            this.map(c);
        }
    }

    public synchronized Morphia map(Class entityClass) {
        if (!this.mapper.isMapped(entityClass)) {
            Set<Class> validClasses = this.validator.validate(entityClass, this.mapper.isDynamicInstantiation());
            for (Class c : validClasses) {
                this.mapper.addMappedClass(c);
            }
        }
        return this;
    }

    public synchronized Morphia mapPackage(String packageName) {
        return this.mapPackage(packageName, false);
    }

    public synchronized Morphia mapPackage(String packageName, boolean ignoreInvalidClasses) {
        try {
            for (Class<?> c : ReflectionUtils.getClasses(packageName)) {
                try {
                    this.map(c);
                }
                catch (MongoMappingException ex) {
                    if (ignoreInvalidClasses) continue;
                    throw ex;
                }
            }
            return this;
        }
        catch (IOException ioex) {
            throw new MongoMappingException("Could not get map classes from package " + packageName, ioex);
        }
        catch (ClassNotFoundException cnfex) {
            throw new MongoMappingException("Could not get map classes from package " + packageName, cnfex);
        }
    }

    public Set<Class> getMappedClasses() {
        return Collections.unmodifiableSet(this.mapper.getMappedClasses());
    }

    public boolean isMapped(Class entityClass) {
        return this.mapper.isMapped(entityClass);
    }

    public <T> T fromDBObject(Class<T> entityClass, BasicDBObject dbObject) {
        if (!this.mapper.isDynamicInstantiation() && !this.mapper.isMapped(entityClass)) {
            throw new MongoMappingException("Trying to map to an unmapped class: " + entityClass.getName());
        }
        try {
            Object object = this.mapper.fromDBObject(entityClass, dbObject);
            return (T)object;
        }
        catch (Exception e) {
            throw new MongoMappingException("Could not map from DBObject", e);
        }
        finally {
            this.mapper.clearHistory();
        }
    }

    public DBObject toDBObject(Object entity) {
        if (!this.mapper.isMapped(entity.getClass())) {
            throw new MongoMappingException("Trying to map an unmapped class: " + entity.getClass().getName());
        }
        try {
            DBObject dBObject = this.mapper.toDBObject(entity);
            return dBObject;
        }
        catch (Exception e) {
            throw new MongoMappingException("Could not map to DBObject", e);
        }
        finally {
            this.mapper.clearHistory();
        }
    }
}

