/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia;

import com.google.code.morphia.annotations.MongoCollectionName;
import com.google.code.morphia.annotations.MongoEmbedded;
import com.google.code.morphia.annotations.MongoID;
import com.google.code.morphia.annotations.MongoReference;
import com.google.code.morphia.annotations.MongoValue;
import com.google.code.morphia.utils.ReflectionUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.ObjectId;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;

public class Mapper {
    private static final String CLASS_NAME = "className";
    private final CopyOnWriteArraySet<Class> mappedClasses = new CopyOnWriteArraySet();
    private final boolean dynamicInstantiation;
    private final ThreadLocal<Map<String, Object>> history = new ThreadLocal();

    Mapper(boolean dynamicInstantiation) {
        this.dynamicInstantiation = dynamicInstantiation;
    }

    public boolean isDynamicInstantiation() {
        return this.dynamicInstantiation;
    }

    boolean isMapped(Class c) {
        return this.mappedClasses.contains(c);
    }

    void addMappedClass(Class c) {
        this.mappedClasses.add(c);
    }

    CopyOnWriteArraySet<Class> getMappedClasses() {
        return this.mappedClasses;
    }

    void clearHistory() {
        this.history.remove();
    }

    private Field findAnnotatedField(Object obj, Class annotationClass) {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(obj.getClass(), false)) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private String getCollectionName(Object object) throws IllegalAccessException {
        return (String)this.findAnnotatedField(object, MongoCollectionName.class).get(object);
    }

    private String getID(Object object) throws IllegalAccessException {
        return (String)this.findAnnotatedField(object, MongoID.class).get(object);
    }

    Class getClassForName(String className, Class defaultClass) {
        for (Class c : this.mappedClasses) {
            if (!className.equals(c.getCanonicalName())) continue;
            return c;
        }
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return defaultClass;
        }
    }

    Object createEntityInstanceForDbObject(Class entityClass, BasicDBObject dbObject) throws Exception {
        String className = (String)dbObject.get(CLASS_NAME);
        if (className != null) {
            return this.getClassForName(className, entityClass).newInstance();
        }
        return entityClass.newInstance();
    }

    Object fromDBObject(Class entityClass, BasicDBObject dbObject) throws Exception {
        this.history.set(new HashMap());
        Object entity = this.createEntityInstanceForDbObject(entityClass, dbObject);
        this.mapDBObjectToEntity(dbObject, entity);
        this.history.remove();
        return entity;
    }

    DBObject toDBObject(Object entity) throws Exception {
        BasicDBObject dbObject = new BasicDBObject();
        if (this.dynamicInstantiation) {
            dbObject.put(CLASS_NAME, (Object)entity.getClass().getCanonicalName());
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(entity.getClass(), true)) {
            String value;
            field.setAccessible(true);
            if (field.isAnnotationPresent(MongoID.class)) {
                value = (String)field.get(entity);
                if (value == null || value.length() <= 0) continue;
                dbObject.put("_id", (Object)new ObjectId(value));
                continue;
            }
            if (field.isAnnotationPresent(MongoCollectionName.class)) {
                value = (String)field.get(entity);
                if (value == null || value.length() <= 0) continue;
                dbObject.put("_ns", (Object)value);
                continue;
            }
            if (field.isAnnotationPresent(MongoValue.class)) {
                this.mapValuesToDBObject(entity, field, dbObject);
                continue;
            }
            if (field.isAnnotationPresent(MongoReference.class)) {
                this.mapReferencesToDBObject(entity, field, dbObject);
                continue;
            }
            if (!field.isAnnotationPresent(MongoEmbedded.class)) continue;
            this.mapEmbeddedToDBObject(entity, field, dbObject);
        }
        return dbObject;
    }

    void mapReferencesToDBObject(Object entity, Field field, BasicDBObject dbObject) throws Exception {
        MongoReference mongoReference = field.getAnnotation(MongoReference.class);
        String name = this.getMongoName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            List list = (List)field.get(entity);
            if (list != null) {
                List values = mongoReference.listClass().newInstance();
                for (Object o : list) {
                    values.add(new DBRef(null, this.getCollectionName(o), (Object)new ObjectId(this.getID(o))));
                }
                dbObject.put(name, (Object)values);
            } else {
                dbObject.removeField(name);
            }
        } else {
            Object o = field.get(entity);
            if (o != null) {
                dbObject.put(name, (Object)new DBRef(null, this.getCollectionName(o), (Object)new ObjectId(this.getID(o))));
            } else {
                dbObject.removeField(name);
            }
        }
    }

    void mapEmbeddedToDBObject(Object entity, Field field, BasicDBObject dbObject) throws Exception {
        MongoEmbedded mongoEmbedded = field.getAnnotation(MongoEmbedded.class);
        String name = this.getMongoName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            List list = (List)field.get(entity);
            if (list != null) {
                List values = mongoEmbedded.listClass().newInstance();
                for (Object o : list) {
                    values.add(this.toDBObject(o));
                }
                dbObject.put(name, (Object)values);
            } else {
                dbObject.removeField(name);
            }
        } else {
            Object o = field.get(entity);
            if (o != null) {
                dbObject.put(name, (Object)this.toDBObject(o));
            } else {
                dbObject.removeField(name);
            }
        }
    }

    void mapValuesToDBObject(Object entity, Field field, BasicDBObject dbObject) throws Exception {
        MongoValue mongoValue = field.getAnnotation(MongoValue.class);
        String name = this.getMongoName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            Class paramClass = ReflectionUtils.getParameterizedClass(field);
            List list = (List)field.get(entity);
            if (list != null) {
                List values = mongoValue.listClass().newInstance();
                for (Object o : list) {
                    if (paramClass.isEnum()) {
                        values.add(((Enum)o).name());
                        continue;
                    }
                    if (paramClass == Locale.class) {
                        values.add(((Locale)o).toString());
                        continue;
                    }
                    values.add(o);
                }
                dbObject.put(name, (Object)values);
            } else {
                dbObject.removeField(name);
            }
        } else {
            Object value = field.get(entity);
            if (value != null) {
                Class<?> c = field.getType();
                if (c.isEnum()) {
                    dbObject.put(name, (Object)((Enum)value).name());
                } else if (c == Locale.class) {
                    dbObject.put(name, (Object)((Locale)value).toString());
                } else {
                    dbObject.put(name, value);
                }
            } else {
                dbObject.removeField(name);
            }
        }
    }

    Object mapDBObjectToEntity(BasicDBObject dbObject, Object entity) throws Exception {
        String key;
        String string = key = dbObject.containsField("_id") ? dbObject.get("_id").toString() : null;
        if (this.history.get() == null) {
            this.history.set(new HashMap());
        }
        if (key != null) {
            if (this.history.get().containsKey(key)) {
                return this.history.get().get(key);
            }
            this.history.get().put(key, entity);
        }
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(entity.getClass(), false)) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(MongoID.class)) {
                if (dbObject.get("_id") == null) continue;
                field.set(entity, dbObject.get("_id").toString());
                continue;
            }
            if (field.isAnnotationPresent(MongoCollectionName.class)) {
                if (dbObject.get("_ns") == null) continue;
                field.set(entity, dbObject.get("_ns").toString());
                continue;
            }
            if (field.isAnnotationPresent(MongoValue.class)) {
                this.mapValuesFromDBObject(dbObject, field, entity);
                continue;
            }
            if (field.isAnnotationPresent(MongoReference.class)) {
                this.mapReferencesFromDBObject(dbObject, field, entity);
                continue;
            }
            if (!field.isAnnotationPresent(MongoEmbedded.class)) continue;
            this.mapEmbeddedFromDBObject(dbObject, field, entity);
        }
        return entity;
    }

    void mapValuesFromDBObject(BasicDBObject dbObject, Field field, Object entity) throws Exception {
        MongoValue mongoValue = field.getAnnotation(MongoValue.class);
        String name = this.getMongoName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            if (dbObject.containsField(name)) {
                Class paramClass = ReflectionUtils.getParameterizedClass(field);
                List list = (List)dbObject.get(name);
                List values = mongoValue.listClass().newInstance();
                if (paramClass == Locale.class) {
                    for (Object o : list) {
                        values.add(this.parseLocale((String)o));
                    }
                    field.set(entity, values);
                } else if (paramClass.isEnum()) {
                    for (Object o : list) {
                        values.add(Enum.valueOf(paramClass, (String)o));
                    }
                    field.set(entity, values);
                } else {
                    for (Object o : list) {
                        values.add(o);
                    }
                    field.set(entity, values);
                }
            } else {
                field.set(entity, mongoValue.listClass().newInstance());
            }
        } else if (dbObject.containsField(name)) {
            field.set(entity, this.objectFromValue(field.getType(), dbObject, name));
        }
    }

    Object objectFromValue(Class c, BasicDBObject dbObject, String name) {
        if (c == String.class) {
            return dbObject.getString(name);
        }
        if (c == Date.class) {
            return (Date)dbObject.get(name);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return dbObject.getInt(name);
        }
        if (c == Long.class || c == Long.TYPE) {
            return dbObject.getLong(name);
        }
        if (c == Double.class || c == Double.TYPE) {
            return (Double)dbObject.get(name);
        }
        if (c == Boolean.class || c == Boolean.TYPE) {
            return (Boolean)dbObject.get(name);
        }
        if (c == Locale.class) {
            return this.parseLocale(dbObject.getString(name));
        }
        if (c.isEnum()) {
            return Enum.valueOf(c, dbObject.getString(name));
        }
        return null;
    }

    void mapEmbeddedFromDBObject(BasicDBObject dbObject, Field field, Object entity) throws Exception {
        MongoEmbedded mongoEmbedded = field.getAnnotation(MongoEmbedded.class);
        String name = this.getMongoName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            Class docObjClass = ReflectionUtils.getParameterizedClass(field);
            List docs = mongoEmbedded.listClass().newInstance();
            if (dbObject.containsField(name)) {
                Object value = dbObject.get(name);
                if (value instanceof List) {
                    List refList = (List)value;
                    for (Object docDbObject : refList) {
                        Object docObj = this.createEntityInstanceForDbObject(docObjClass, (BasicDBObject)docDbObject);
                        docObj = this.mapDBObjectToEntity((BasicDBObject)docDbObject, docObj);
                        docs.add(docObj);
                    }
                } else {
                    BasicDBObject docDbObject = (BasicDBObject)dbObject.get(name);
                    Object docObj = this.createEntityInstanceForDbObject(docObjClass, docDbObject);
                    docObj = this.mapDBObjectToEntity(docDbObject, docObj);
                    docs.add(docObj);
                }
            }
            field.set(entity, docs);
        } else {
            Class<?> docObjClass = field.getType();
            if (dbObject.containsField(name)) {
                BasicDBObject docDbObject = (BasicDBObject)dbObject.get(name);
                Object refObj = this.createEntityInstanceForDbObject(docObjClass, docDbObject);
                refObj = this.mapDBObjectToEntity(docDbObject, refObj);
                field.set(entity, refObj);
            }
        }
    }

    void mapReferencesFromDBObject(BasicDBObject dbObject, Field field, Object entity) throws Exception {
        MongoReference mongoReference = field.getAnnotation(MongoReference.class);
        String name = this.getMongoName(field);
        if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
            Class referenceObjClass = ReflectionUtils.getParameterizedClass(field);
            List references = mongoReference.listClass().newInstance();
            if (dbObject.containsField(name)) {
                Object value = dbObject.get(name);
                if (value instanceof List) {
                    List refList = (List)value;
                    for (Object dbRefObj : refList) {
                        DBRef dbRef = (DBRef)dbRefObj;
                        BasicDBObject refDbObject = (BasicDBObject)dbRef.fetch();
                        Object refObj = this.createEntityInstanceForDbObject(referenceObjClass, refDbObject);
                        refObj = this.mapDBObjectToEntity(refDbObject, refObj);
                        references.add(refObj);
                    }
                } else {
                    DBRef dbRef = (DBRef)dbObject.get(name);
                    BasicDBObject refDbObject = (BasicDBObject)dbRef.fetch();
                    Object refObj = this.createEntityInstanceForDbObject(referenceObjClass, refDbObject);
                    refObj = this.mapDBObjectToEntity(refDbObject, refObj);
                    references.add(refObj);
                }
            }
            field.set(entity, references);
        } else {
            Class<?> referenceObjClass = field.getType();
            if (dbObject.containsField(name)) {
                DBRef dbRef = (DBRef)dbObject.get(name);
                BasicDBObject refDbObject = (BasicDBObject)dbRef.fetch();
                Object refObj = this.createEntityInstanceForDbObject(referenceObjClass, refDbObject);
                refObj = this.mapDBObjectToEntity(refDbObject, refObj);
                field.set(entity, refObj);
            }
        }
    }

    private String getMongoName(Field field) {
        String name = null;
        if (field.isAnnotationPresent(MongoValue.class)) {
            MongoValue mv = field.getAnnotation(MongoValue.class);
            name = mv.value();
        } else if (field.isAnnotationPresent(MongoEmbedded.class)) {
            MongoEmbedded me = field.getAnnotation(MongoEmbedded.class);
            name = me.value();
        } else if (field.isAnnotationPresent(MongoReference.class)) {
            MongoReference mr = field.getAnnotation(MongoReference.class);
            name = mr.value();
        }
        if (name == null || name.equals("fieldName")) {
            return field.getName();
        }
        return name;
    }

    private Locale parseLocale(String localeString) {
        if (localeString != null && localeString.length() > 0) {
            StringTokenizer st = new StringTokenizer(localeString, "_");
            String language = st.hasMoreElements() ? st.nextToken() : Locale.getDefault().getLanguage();
            String country = st.hasMoreElements() ? st.nextToken() : "";
            String variant = st.hasMoreElements() ? st.nextToken() : "";
            return new Locale(language, country, variant);
        }
        return null;
    }
}

