/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.util.OWLObjectVisitorAdapter;
import uk.ac.manchester.cs.factplusplus.ClassPointer;
import uk.ac.manchester.cs.factplusplus.DataPropertyPointer;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlus;
import uk.ac.manchester.cs.factplusplus.ObjectPropertyPointer;
import uk.ac.manchester.cs.factplusplus.Pointer;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusReasonerException;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusRuntimeException;
import uk.ac.manchester.cs.factplusplus.owlapi.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorUtils
extends OWLObjectVisitorAdapter {
    private static final Logger logger = Logger.getLogger(TranslatorUtils.class.getName());
    private Translator translator;
    private FaCTPlusPlus faCTPlusPlus;
    private OWLOntologyManager mngr;

    public TranslatorUtils(OWLOntologyManager oWLOntologyManager, FaCTPlusPlus faCTPlusPlus, Translator translator) {
        this(oWLOntologyManager, translator);
    }

    public TranslatorUtils(OWLOntologyManager oWLOntologyManager, Translator translator) {
        this.mngr = oWLOntologyManager;
        this.faCTPlusPlus = translator.getFaCTPlusPlus();
        this.translator = translator;
    }

    public Set<Set<OWLClass>> getOWLAPISets(ClassPointer[][] classPointerArray) throws OWLReasonerException {
        HashSet<Set<OWLClass>> hashSet = new HashSet<Set<OWLClass>>();
        for (ClassPointer[] classPointerArray2 : classPointerArray) {
            HashSet<OWLClass> hashSet2 = new HashSet<OWLClass>();
            for (ClassPointer classPointer : classPointerArray2) {
                OWLClass oWLClass = this.translator.getOWLClass(classPointer);
                if (oWLClass != null) {
                    hashSet2.add(oWLClass);
                    continue;
                }
                try {
                    if (classPointer.equals(this.faCTPlusPlus.getThing())) {
                        hashSet2.add(this.mngr.getOWLDataFactory().getOWLThing());
                        logger.fine("Missing translation for Thing");
                        continue;
                    }
                    if (classPointer.equals(this.faCTPlusPlus.getNothing())) {
                        hashSet2.add(this.mngr.getOWLDataFactory().getOWLNothing());
                        logger.fine("Missing translation for Nothing");
                        continue;
                    }
                    logger.severe("Translation failed for class pointer: " + classPointer);
                }
                catch (Exception exception) {
                    throw new FaCTPlusPlusReasonerException(exception);
                }
            }
            hashSet.add(hashSet2);
        }
        return hashSet;
    }

    public Set<Set<OWLDescription>> getOWLAPIDescriptionSets(ClassPointer[][] classPointerArray) throws OWLReasonerException {
        HashSet<Set<OWLDescription>> hashSet = new HashSet<Set<OWLDescription>>();
        for (ClassPointer[] classPointerArray2 : classPointerArray) {
            HashSet<OWLClass> hashSet2 = new HashSet<OWLClass>();
            for (ClassPointer classPointer : classPointerArray2) {
                OWLClass oWLClass = this.translator.getOWLClass(classPointer);
                if (oWLClass != null) {
                    hashSet2.add(oWLClass);
                    continue;
                }
                try {
                    if (classPointer.equals(this.faCTPlusPlus.getThing())) {
                        hashSet2.add(this.mngr.getOWLDataFactory().getOWLThing());
                        logger.fine("Missing translation for Thing");
                        continue;
                    }
                    if (classPointer.equals(this.faCTPlusPlus.getNothing())) {
                        hashSet2.add(this.mngr.getOWLDataFactory().getOWLNothing());
                        logger.fine("Missing translation for Nothing");
                        continue;
                    }
                    logger.severe("Translation failed for class pointer: " + classPointer);
                }
                catch (Exception exception) {
                    throw new FaCTPlusPlusReasonerException(exception);
                }
            }
            hashSet.add(hashSet2);
        }
        return hashSet;
    }

    public Set<Set<OWLObjectProperty>> getOWLAPISets(ObjectPropertyPointer[][] objectPropertyPointerArray) throws OWLReasonerException {
        HashSet<Set<OWLObjectProperty>> hashSet = new HashSet<Set<OWLObjectProperty>>();
        for (ObjectPropertyPointer[] objectPropertyPointerArray2 : objectPropertyPointerArray) {
            HashSet<OWLObjectProperty> hashSet2 = new HashSet<OWLObjectProperty>();
            for (ObjectPropertyPointer objectPropertyPointer : objectPropertyPointerArray2) {
                OWLObjectProperty oWLObjectProperty = this.translator.getOWLObjectProperty(objectPropertyPointer);
                if (oWLObjectProperty != null) {
                    hashSet2.add(oWLObjectProperty);
                    continue;
                }
                logger.severe("Translation failed for object pointer: " + objectPropertyPointer);
            }
            hashSet.add(hashSet2);
        }
        return hashSet;
    }

    public Set<Set<OWLDataProperty>> getOWLAPISets(DataPropertyPointer[][] dataPropertyPointerArray) throws OWLReasonerException {
        HashSet<Set<OWLDataProperty>> hashSet = new HashSet<Set<OWLDataProperty>>();
        for (DataPropertyPointer[] dataPropertyPointerArray2 : dataPropertyPointerArray) {
            HashSet<OWLDataProperty> hashSet2 = new HashSet<OWLDataProperty>();
            for (DataPropertyPointer dataPropertyPointer : dataPropertyPointerArray2) {
                OWLDataProperty oWLDataProperty = this.translator.getOWLDataProperty(dataPropertyPointer);
                if (oWLDataProperty != null) {
                    hashSet2.add(oWLDataProperty);
                    continue;
                }
                logger.severe("Translation failed for object pointer: " + dataPropertyPointer);
            }
            hashSet.add(hashSet2);
        }
        return hashSet;
    }

    public <N extends OWLObject, P extends Pointer> Set<N> getOWLAPISet(P[] PArray) {
        HashSet<OWLObject> hashSet = new HashSet<OWLObject>();
        for (P p : PArray) {
            OWLObject oWLObject = this.translator.getOWLObject((Pointer)p);
            if (oWLObject == null) continue;
            hashSet.add(oWLObject);
        }
        return hashSet;
    }

    public Set<OWLDescription> getOWLAPIDescriptionSet(ClassPointer[][] classPointerArray) {
        HashSet<OWLDescription> hashSet = new HashSet<OWLDescription>();
        ClassPointer[][] classPointerArray2 = classPointerArray;
        int n = classPointerArray2.length;
        for (int i = 0; i < n; ++i) {
            ClassPointer[] classPointerArray3;
            for (ClassPointer classPointer : classPointerArray3 = classPointerArray2[i]) {
                OWLClass oWLClass = this.translator.getOWLClass(classPointer);
                if (oWLClass == null) continue;
                hashSet.add((OWLDescription)oWLClass);
            }
        }
        return hashSet;
    }

    public void checkParams(OWLObject ... oWLObjectArray) {
        for (OWLObject oWLObject : oWLObjectArray) {
            oWLObject.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLClass oWLClass) {
        if (!this.translator.contains(oWLClass)) {
            throw new FaCTPlusPlusRuntimeException("Asking about unknown class (" + oWLClass.getURI() + ").  (Check that the reasoner is synchronized)");
        }
    }

    public void visit(OWLObjectProperty oWLObjectProperty) {
        if (!this.translator.contains(oWLObjectProperty)) {
            throw new FaCTPlusPlusRuntimeException("Asking about unknown object property (" + oWLObjectProperty.getURI() + ").  (Check that the reasoner is synchronized)");
        }
    }

    public void visit(OWLDataProperty oWLDataProperty) {
        if (!this.translator.contains(oWLDataProperty)) {
            throw new FaCTPlusPlusRuntimeException("Asking about unknown data property (" + oWLDataProperty.getURI() + ").  (Check that the reasoner is synchronized)");
        }
    }

    public void visit(OWLIndividual oWLIndividual) {
        if (!this.translator.contains(oWLIndividual)) {
            throw new FaCTPlusPlusRuntimeException("Asking about unknown individual (" + oWLIndividual.getURI() + ") (Check that the reasoner is synchronized)");
        }
    }
}

