/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;
import uk.ac.manchester.cs.factplusplus.ClassPointer;
import uk.ac.manchester.cs.factplusplus.DataPropertyPointer;
import uk.ac.manchester.cs.factplusplus.DataTypeExpressionPointer;
import uk.ac.manchester.cs.factplusplus.DataTypeFacet;
import uk.ac.manchester.cs.factplusplus.DataTypePointer;
import uk.ac.manchester.cs.factplusplus.DataValuePointer;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlus;
import uk.ac.manchester.cs.factplusplus.IndividualPointer;
import uk.ac.manchester.cs.factplusplus.ObjectPropertyPointer;
import uk.ac.manchester.cs.factplusplus.Pointer;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusReasonerException;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusRuntimeException;

public class Translator
implements OWLDescriptionVisitor,
OWLEntityVisitor,
OWLPropertyExpressionVisitor,
OWLDataVisitor {
    private static final Logger logger = Logger.getLogger(Translator.class.getName());
    private FaCTPlusPlus faCTPlusPlus;
    private OWLOntologyManager owlOntologyManager;
    private ClassPointer lastClassPointer;
    private ObjectPropertyPointer lastObjectPropertyPointer;
    private DataPropertyPointer lastDataPropertyPointer;
    private IndividualPointer lastIndividualPointer;
    private DataTypePointer lastDataTypePointer;
    private DataTypeExpressionPointer lastDataTypeExpressionPointer;
    private DataValuePointer lastDataValuePointer;
    private Map<ClassPointer, OWLClass> classPointerMap;
    private Map<OWLClass, ClassPointer> owlClass2ClassPointerMap;
    private Map<ObjectPropertyPointer, OWLObjectProperty> objectPropertyPointerMap;
    private Map<OWLObjectProperty, ObjectPropertyPointer> owlObjectProperty2ObjectPropertyPointerMap;
    private Map<DataPropertyPointer, OWLDataProperty> dataPropertyPointerMap;
    private Map<OWLDataProperty, DataPropertyPointer> owlDataProperty2DataPropertyPointerMap;
    private Map<IndividualPointer, OWLIndividual> individualPointerMap;
    private Map<OWLIndividual, IndividualPointer> owlIndividual2IndividualPointerMap;
    private Map<DataValuePointer, OWLConstant> dataValuePointerMap;
    private Map<OWLConstant, DataValuePointer> owlConstant2DataValuePointerMap;
    private Map<DataTypeExpressionPointer, OWLDataRange> dataTypeExpressionPointerMap;
    private Map<OWLDataRange, DataTypeExpressionPointer> owlDataRange2DataTypeExpressionPointerMap;

    public Translator(OWLOntologyManager oWLOntologyManager, FaCTPlusPlus faCTPlusPlus) {
        this.owlOntologyManager = oWLOntologyManager;
        this.faCTPlusPlus = faCTPlusPlus;
        this.classPointerMap = new HashMap<ClassPointer, OWLClass>();
        this.owlClass2ClassPointerMap = new HashMap<OWLClass, ClassPointer>();
        this.objectPropertyPointerMap = new HashMap<ObjectPropertyPointer, OWLObjectProperty>();
        this.owlObjectProperty2ObjectPropertyPointerMap = new HashMap<OWLObjectProperty, ObjectPropertyPointer>();
        this.dataPropertyPointerMap = new HashMap<DataPropertyPointer, OWLDataProperty>();
        this.owlDataProperty2DataPropertyPointerMap = new HashMap<OWLDataProperty, DataPropertyPointer>();
        this.individualPointerMap = new HashMap<IndividualPointer, OWLIndividual>();
        this.owlIndividual2IndividualPointerMap = new HashMap<OWLIndividual, IndividualPointer>();
        this.dataValuePointerMap = new HashMap<DataValuePointer, OWLConstant>();
        this.owlConstant2DataValuePointerMap = new HashMap<OWLConstant, DataValuePointer>();
        this.dataTypeExpressionPointerMap = new HashMap<DataTypeExpressionPointer, OWLDataRange>();
        this.owlDataRange2DataTypeExpressionPointerMap = new HashMap<OWLDataRange, DataTypeExpressionPointer>();
    }

    public void reset() throws OWLException {
        try {
            this.classPointerMap.clear();
            this.owlClass2ClassPointerMap.clear();
            this.objectPropertyPointerMap.clear();
            this.owlObjectProperty2ObjectPropertyPointerMap.clear();
            this.owlDataProperty2DataPropertyPointerMap.clear();
            this.dataPropertyPointerMap.clear();
            this.individualPointerMap.clear();
            this.owlIndividual2IndividualPointerMap.clear();
            this.dataValuePointerMap.clear();
            this.owlConstant2DataValuePointerMap.clear();
            this.dataTypeExpressionPointerMap.clear();
            this.owlDataRange2DataTypeExpressionPointerMap.clear();
            this.lastClassPointer = null;
            this.lastObjectPropertyPointer = null;
            this.lastIndividualPointer = null;
            this.lastDataPropertyPointer = null;
            this.lastDataTypePointer = null;
            this.lastDataTypeExpressionPointer = null;
            this.lastDataValuePointer = null;
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public FaCTPlusPlus getFaCTPlusPlus() {
        return this.faCTPlusPlus;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public void dispose() {
        try {
            this.reset();
        }
        catch (OWLException oWLException) {
            logger.severe(oWLException.getMessage());
        }
    }

    public boolean contains(OWLClass oWLClass) {
        if (oWLClass.equals(this.owlOntologyManager.getOWLDataFactory().getOWLThing())) {
            return true;
        }
        if (oWLClass.equals(this.owlOntologyManager.getOWLDataFactory().getOWLNothing())) {
            return true;
        }
        return this.owlClass2ClassPointerMap.containsKey(oWLClass);
    }

    public boolean contains(OWLObjectProperty oWLObjectProperty) {
        if (oWLObjectProperty.equals(this.owlOntologyManager.getOWLDataFactory().getOWLThing())) {
            return true;
        }
        if (oWLObjectProperty.equals(this.owlOntologyManager.getOWLDataFactory().getOWLNothing())) {
            return true;
        }
        return this.owlObjectProperty2ObjectPropertyPointerMap.containsKey(oWLObjectProperty);
    }

    public boolean contains(OWLDataProperty oWLDataProperty) {
        if (oWLDataProperty.equals(this.owlOntologyManager.getOWLDataFactory().getOWLThing())) {
            return true;
        }
        if (oWLDataProperty.equals(this.owlOntologyManager.getOWLDataFactory().getOWLNothing())) {
            return true;
        }
        return this.owlDataProperty2DataPropertyPointerMap.containsKey(oWLDataProperty);
    }

    public boolean contains(OWLIndividual oWLIndividual) {
        return this.owlIndividual2IndividualPointerMap.containsKey(oWLIndividual);
    }

    public ClassPointer translate(OWLDescription oWLDescription) throws OWLException {
        oWLDescription.accept((OWLDescriptionVisitor)this);
        return this.getLastClassPointer();
    }

    public ObjectPropertyPointer translate(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws OWLException {
        oWLObjectPropertyExpression.accept((OWLPropertyExpressionVisitor)this);
        return this.getLastObjectPropertyPointer();
    }

    public DataPropertyPointer translate(OWLDataPropertyExpression oWLDataPropertyExpression) throws OWLException {
        oWLDataPropertyExpression.accept((OWLPropertyExpressionVisitor)this);
        return this.getLastDataPropertyPointer();
    }

    public IndividualPointer translate(OWLIndividual oWLIndividual) throws OWLException {
        oWLIndividual.accept((OWLEntityVisitor)this);
        return this.getLastIndividualPointer();
    }

    public DataTypePointer translate(OWLDataRange oWLDataRange) throws OWLException {
        oWLDataRange.accept((OWLDataVisitor)this);
        return this.getLastDataTypePointer();
    }

    public DataValuePointer translate(OWLConstant oWLConstant) throws OWLException {
        oWLConstant.accept((OWLDataVisitor)this);
        return this.getLastDataValuePointer();
    }

    public ClassPointer getLastClassPointer() {
        if (this.lastClassPointer == null) {
            throw new RuntimeException("Last class pointer is null!");
        }
        return this.lastClassPointer;
    }

    public ObjectPropertyPointer getLastObjectPropertyPointer() {
        if (this.lastObjectPropertyPointer == null) {
            throw new RuntimeException("Last object property pointer is null");
        }
        return this.lastObjectPropertyPointer;
    }

    public IndividualPointer getLastIndividualPointer() {
        if (this.lastIndividualPointer == null) {
            throw new RuntimeException("Last individual pointer is null!");
        }
        return this.lastIndividualPointer;
    }

    public DataPropertyPointer getLastDataPropertyPointer() {
        if (this.lastDataPropertyPointer == null) {
            throw new RuntimeException("Last data property pointer is null!");
        }
        return this.lastDataPropertyPointer;
    }

    public DataTypePointer getLastDataTypePointer() {
        if (this.lastDataTypePointer == null) {
            throw new RuntimeException("Last data type pointer is null");
        }
        return this.lastDataTypePointer;
    }

    public DataTypeExpressionPointer getLastDataTypeExpressionPointer() {
        if (this.lastDataTypeExpressionPointer != null) {
            return this.lastDataTypeExpressionPointer;
        }
        return this.getLastDataTypePointer();
    }

    public DataValuePointer getLastDataValuePointer() {
        if (this.lastDataValuePointer == null) {
            throw new RuntimeException("Last data value pointer is null");
        }
        return this.lastDataValuePointer;
    }

    public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
        try {
            HashSet<ClassPointer> hashSet = new HashSet<ClassPointer>();
            for (OWLDescription object : oWLObjectIntersectionOf.getOperands()) {
                object.accept((OWLDescriptionVisitor)this);
                ClassPointer classPointer = this.getLastClassPointer();
                hashSet.add(classPointer);
            }
            this.faCTPlusPlus.initArgList();
            for (ClassPointer classPointer : hashSet) {
                this.faCTPlusPlus.addArg(classPointer);
            }
            this.faCTPlusPlus.closeArgList();
            this.lastClassPointer = this.faCTPlusPlus.getConceptAnd();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
        try {
            oWLObjectComplementOf.getOperand().accept((OWLDescriptionVisitor)this);
            ClassPointer classPointer = this.getLastClassPointer();
            this.lastClassPointer = this.faCTPlusPlus.getConceptNot(classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataAllRestriction oWLDataAllRestriction) {
        try {
            DataPropertyPointer dataPropertyPointer = this.translate((OWLDataPropertyExpression)oWLDataAllRestriction.getProperty());
            ((OWLDataRange)oWLDataAllRestriction.getFiller()).accept((OWLDataVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getDataAll(dataPropertyPointer, this.getLastDataTypeExpressionPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataSomeRestriction oWLDataSomeRestriction) {
        try {
            DataPropertyPointer dataPropertyPointer = this.translate((OWLDataPropertyExpression)oWLDataSomeRestriction.getProperty());
            ((OWLDataRange)oWLDataSomeRestriction.getFiller()).accept((OWLDataVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getDataSome(dataPropertyPointer, this.getLastDataTypeExpressionPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataValueRestriction oWLDataValueRestriction) {
        try {
            DataPropertyPointer dataPropertyPointer = this.translate((OWLDataPropertyExpression)oWLDataValueRestriction.getProperty());
            OWLConstant oWLConstant = (OWLConstant)oWLDataValueRestriction.getValue();
            oWLConstant.accept((OWLDataVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getDataValue(dataPropertyPointer, this.getLastDataValuePointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectAllRestriction oWLObjectAllRestriction) {
        try {
            ((OWLDescription)oWLObjectAllRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
            ClassPointer classPointer = this.getLastClassPointer();
            ((OWLObjectPropertyExpression)oWLObjectAllRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ObjectPropertyPointer objectPropertyPointer = this.getLastObjectPropertyPointer();
            this.lastClassPointer = this.faCTPlusPlus.getObjectAll(objectPropertyPointer, classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectMinCardinalityRestriction oWLObjectMinCardinalityRestriction) {
        try {
            ((OWLDescription)oWLObjectMinCardinalityRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
            ClassPointer classPointer = this.getLastClassPointer();
            ((OWLObjectPropertyExpression)oWLObjectMinCardinalityRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ObjectPropertyPointer objectPropertyPointer = this.getLastObjectPropertyPointer();
            this.lastClassPointer = this.faCTPlusPlus.getObjectAtLeast(oWLObjectMinCardinalityRestriction.getCardinality(), objectPropertyPointer, classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectExactCardinalityRestriction oWLObjectExactCardinalityRestriction) {
        try {
            ((OWLDescription)oWLObjectExactCardinalityRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
            ClassPointer classPointer = this.getLastClassPointer();
            ((OWLObjectPropertyExpression)oWLObjectExactCardinalityRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ObjectPropertyPointer objectPropertyPointer = this.getLastObjectPropertyPointer();
            this.lastClassPointer = this.faCTPlusPlus.getObjectExact(oWLObjectExactCardinalityRestriction.getCardinality(), objectPropertyPointer, classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectMaxCardinalityRestriction oWLObjectMaxCardinalityRestriction) {
        try {
            ((OWLDescription)oWLObjectMaxCardinalityRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
            ClassPointer classPointer = this.getLastClassPointer();
            ((OWLObjectPropertyExpression)oWLObjectMaxCardinalityRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ObjectPropertyPointer objectPropertyPointer = this.getLastObjectPropertyPointer();
            this.lastClassPointer = this.faCTPlusPlus.getObjectAtMost(oWLObjectMaxCardinalityRestriction.getCardinality(), objectPropertyPointer, classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectSelfRestriction oWLObjectSelfRestriction) {
        try {
            ((OWLObjectPropertyExpression)oWLObjectSelfRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getSelf(this.getLastObjectPropertyPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectOneOf oWLObjectOneOf) {
        try {
            this.faCTPlusPlus.initArgList();
            for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
                oWLIndividual.accept((OWLEntityVisitor)this);
                this.faCTPlusPlus.addArg(this.getLastIndividualPointer());
            }
            this.faCTPlusPlus.closeArgList();
            this.lastClassPointer = this.faCTPlusPlus.getOneOf();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataMinCardinalityRestriction oWLDataMinCardinalityRestriction) {
        try {
            ((OWLDataPropertyExpression)oWLDataMinCardinalityRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            DataPropertyPointer dataPropertyPointer = this.getLastDataPropertyPointer();
            ((OWLDataRange)oWLDataMinCardinalityRestriction.getFiller()).accept((OWLDataVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getDataAtLeast(oWLDataMinCardinalityRestriction.getCardinality(), dataPropertyPointer, this.getLastDataTypeExpressionPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataExactCardinalityRestriction oWLDataExactCardinalityRestriction) {
        try {
            ((OWLDataPropertyExpression)oWLDataExactCardinalityRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            DataPropertyPointer dataPropertyPointer = this.getLastDataPropertyPointer();
            ((OWLDataRange)oWLDataExactCardinalityRestriction.getFiller()).accept((OWLDataVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getDataExact(oWLDataExactCardinalityRestriction.getCardinality(), dataPropertyPointer, this.getLastDataTypeExpressionPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataMaxCardinalityRestriction oWLDataMaxCardinalityRestriction) {
        try {
            ((OWLDataPropertyExpression)oWLDataMaxCardinalityRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            DataPropertyPointer dataPropertyPointer = this.getLastDataPropertyPointer();
            ((OWLDataRange)oWLDataMaxCardinalityRestriction.getFiller()).accept((OWLDataVisitor)this);
            this.lastClassPointer = this.faCTPlusPlus.getDataAtMost(oWLDataMaxCardinalityRestriction.getCardinality(), dataPropertyPointer, this.getLastDataTypeExpressionPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectSomeRestriction oWLObjectSomeRestriction) {
        try {
            ((OWLDescription)oWLObjectSomeRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
            ClassPointer classPointer = this.getLastClassPointer();
            ((OWLObjectPropertyExpression)oWLObjectSomeRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ObjectPropertyPointer objectPropertyPointer = this.getLastObjectPropertyPointer();
            this.lastClassPointer = this.faCTPlusPlus.getObjectSome(objectPropertyPointer, classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectValueRestriction oWLObjectValueRestriction) {
        try {
            ((OWLIndividual)oWLObjectValueRestriction.getValue()).accept((OWLEntityVisitor)this);
            IndividualPointer individualPointer = this.getLastIndividualPointer();
            ((OWLObjectPropertyExpression)oWLObjectValueRestriction.getProperty()).accept((OWLPropertyExpressionVisitor)this);
            ObjectPropertyPointer objectPropertyPointer = this.getLastObjectPropertyPointer();
            this.lastClassPointer = this.faCTPlusPlus.getObjectValue(objectPropertyPointer, individualPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
        try {
            HashSet<ClassPointer> hashSet = new HashSet<ClassPointer>();
            for (OWLDescription object : oWLObjectUnionOf.getOperands()) {
                object.accept((OWLDescriptionVisitor)this);
                hashSet.add(this.getLastClassPointer());
            }
            this.faCTPlusPlus.initArgList();
            for (ClassPointer classPointer : hashSet) {
                this.faCTPlusPlus.addArg(classPointer);
            }
            this.faCTPlusPlus.closeArgList();
            this.lastClassPointer = this.faCTPlusPlus.getConceptOr();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataComplementOf oWLDataComplementOf) {
        try {
            this.lastDataTypeExpressionPointer = this.owlDataRange2DataTypeExpressionPointerMap.get(oWLDataComplementOf);
            if (this.lastDataTypeExpressionPointer == null) {
                oWLDataComplementOf.getDataRange().accept((OWLDataVisitor)this);
                this.lastDataTypeExpressionPointer = this.faCTPlusPlus.getDataNot(this.getLastDataTypeExpressionPointer());
                this.owlDataRange2DataTypeExpressionPointerMap.put((OWLDataRange)oWLDataComplementOf, this.lastDataTypeExpressionPointer);
                this.dataTypeExpressionPointerMap.put(this.lastDataTypeExpressionPointer, (OWLDataRange)oWLDataComplementOf);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataOneOf oWLDataOneOf) {
        try {
            this.lastDataTypeExpressionPointer = this.owlDataRange2DataTypeExpressionPointerMap.get(oWLDataOneOf);
            if (this.lastDataTypeExpressionPointer == null) {
                ArrayList<DataValuePointer> arrayList = new ArrayList<DataValuePointer>();
                for (OWLConstant object : oWLDataOneOf.getValues()) {
                    object.accept((OWLDataVisitor)this);
                    arrayList.add(this.getLastDataValuePointer());
                }
                this.faCTPlusPlus.initArgList();
                for (DataValuePointer dataValuePointer : arrayList) {
                    this.faCTPlusPlus.addArg(dataValuePointer);
                }
                this.faCTPlusPlus.closeArgList();
                this.lastDataTypeExpressionPointer = this.faCTPlusPlus.getDataEnumeration();
                this.owlDataRange2DataTypeExpressionPointerMap.put((OWLDataRange)oWLDataOneOf, this.lastDataTypeExpressionPointer);
                this.dataTypeExpressionPointerMap.put(this.lastDataTypeExpressionPointer, (OWLDataRange)oWLDataOneOf);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataRangeRestriction oWLDataRangeRestriction) {
        try {
            this.lastDataTypeExpressionPointer = this.owlDataRange2DataTypeExpressionPointerMap.get(oWLDataRangeRestriction);
            if (this.lastDataTypeExpressionPointer == null) {
                this.lastDataTypeExpressionPointer = null;
                this.lastDataTypePointer = null;
                oWLDataRangeRestriction.getDataRange().accept((OWLDataVisitor)this);
                DataTypeExpressionPointer dataTypeExpressionPointer = this.getLastDataTypeExpressionPointer();
                for (OWLDataRangeFacetRestriction oWLDataRangeFacetRestriction : oWLDataRangeRestriction.getFacetRestrictions()) {
                    oWLDataRangeFacetRestriction.getFacetValue().accept((OWLDataVisitor)this);
                    DataValuePointer dataValuePointer = this.getLastDataValuePointer();
                    DataTypeFacet dataTypeFacet = null;
                    if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE)) {
                        dataTypeFacet = this.faCTPlusPlus.getMinInclusiveFacet(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE)) {
                        dataTypeFacet = this.faCTPlusPlus.getMaxInclusiveFacet(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE)) {
                        dataTypeFacet = this.faCTPlusPlus.getMinExclusiveFacet(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE)) {
                        dataTypeFacet = this.faCTPlusPlus.getMaxExclusiveFacet(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.LENGTH)) {
                        dataTypeFacet = this.faCTPlusPlus.getLength(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.MIN_LENGTH)) {
                        dataTypeFacet = this.faCTPlusPlus.getMinLength(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.MAX_LENGTH)) {
                        dataTypeFacet = this.faCTPlusPlus.getMaxLength(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.FRACTION_DIGITS)) {
                        dataTypeFacet = this.faCTPlusPlus.getFractionDigitsFacet(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.PATTERN)) {
                        dataTypeFacet = this.faCTPlusPlus.getPattern(dataValuePointer);
                    } else if (oWLDataRangeFacetRestriction.getFacet().equals((Object)OWLRestrictedDataRangeFacetVocabulary.TOTAL_DIGITS)) {
                        dataTypeFacet = this.faCTPlusPlus.getTotalDigitsFacet(dataValuePointer);
                    } else {
                        throw new FaCTPlusPlusReasonerException("Unsupported data type facet: " + oWLDataRangeFacetRestriction.getFacet());
                    }
                    dataTypeExpressionPointer = this.lastDataTypeExpressionPointer = this.faCTPlusPlus.getRestrictedDataType(dataTypeExpressionPointer, dataTypeFacet);
                }
                this.owlDataRange2DataTypeExpressionPointerMap.put((OWLDataRange)oWLDataRangeRestriction, this.lastDataTypeExpressionPointer);
                this.dataTypeExpressionPointerMap.put(this.lastDataTypeExpressionPointer, (OWLDataRange)oWLDataRangeRestriction);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataRangeFacetRestriction oWLDataRangeFacetRestriction) {
    }

    public void visit(OWLTypedConstant oWLTypedConstant) {
        try {
            this.lastDataValuePointer = this.owlConstant2DataValuePointerMap.get(oWLTypedConstant);
            if (this.lastDataValuePointer == null) {
                oWLTypedConstant.getDataType().accept((OWLDataVisitor)this);
                this.lastDataValuePointer = this.faCTPlusPlus.getDataValue(oWLTypedConstant.getLiteral(), this.getLastDataTypePointer());
                this.owlConstant2DataValuePointerMap.put((OWLConstant)oWLTypedConstant, this.lastDataValuePointer);
                this.dataValuePointerMap.put(this.lastDataValuePointer, (OWLConstant)oWLTypedConstant);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLUntypedConstant oWLUntypedConstant) {
        try {
            this.lastDataValuePointer = this.owlConstant2DataValuePointerMap.get(oWLUntypedConstant);
            if (this.lastDataValuePointer == null) {
                this.owlOntologyManager.getOWLDataFactory().getOWLDataType(XSDVocabulary.STRING.getURI()).accept((OWLDataVisitor)this);
                this.lastDataValuePointer = this.faCTPlusPlus.getDataValue(oWLUntypedConstant.getLiteral(), this.getLastDataTypePointer());
                this.owlConstant2DataValuePointerMap.put((OWLConstant)oWLUntypedConstant, this.lastDataValuePointer);
                this.dataValuePointerMap.put(this.lastDataValuePointer, (OWLConstant)oWLUntypedConstant);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataProperty oWLDataProperty) {
        try {
            this.lastDataPropertyPointer = this.owlDataProperty2DataPropertyPointerMap.get(oWLDataProperty);
            if (this.lastDataPropertyPointer == null) {
                this.lastDataPropertyPointer = this.faCTPlusPlus.getDataProperty(oWLDataProperty.getURI().toString());
                this.dataPropertyPointerMap.put(this.lastDataPropertyPointer, oWLDataProperty);
                this.owlDataProperty2DataPropertyPointerMap.put(oWLDataProperty, this.lastDataPropertyPointer);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectProperty oWLObjectProperty) {
        try {
            this.lastObjectPropertyPointer = this.owlObjectProperty2ObjectPropertyPointerMap.get(oWLObjectProperty);
            if (this.lastObjectPropertyPointer == null) {
                this.lastObjectPropertyPointer = this.faCTPlusPlus.getObjectProperty(oWLObjectProperty.getURI().toString());
                this.objectPropertyPointerMap.put(this.lastObjectPropertyPointer, oWLObjectProperty);
                this.owlObjectProperty2ObjectPropertyPointerMap.put(oWLObjectProperty, this.lastObjectPropertyPointer);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLClass oWLClass) {
        try {
            this.lastClassPointer = this.owlClass2ClassPointerMap.get(oWLClass);
            if (this.lastClassPointer == null) {
                this.lastClassPointer = oWLClass.getURI().equals(OWLRDFVocabulary.OWL_THING.getURI()) ? this.faCTPlusPlus.getThing() : (oWLClass.getURI().equals(OWLRDFVocabulary.OWL_NOTHING.getURI()) ? this.faCTPlusPlus.getNothing() : this.faCTPlusPlus.getNamedClass(oWLClass.getURI().toString()));
                this.classPointerMap.put(this.lastClassPointer, oWLClass);
                this.owlClass2ClassPointerMap.put(oWLClass, this.lastClassPointer);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyInverse oWLObjectPropertyInverse) {
        try {
            oWLObjectPropertyInverse.getInverse().accept((OWLPropertyExpressionVisitor)this);
            this.lastObjectPropertyPointer = this.faCTPlusPlus.getInverseProperty(this.getLastObjectPropertyPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLIndividual oWLIndividual) {
        try {
            this.lastIndividualPointer = this.owlIndividual2IndividualPointerMap.get(oWLIndividual);
            if (this.lastIndividualPointer == null) {
                this.lastIndividualPointer = this.faCTPlusPlus.getIndividual(oWLIndividual.getURI().toString());
                this.individualPointerMap.put(this.lastIndividualPointer, oWLIndividual);
                this.owlIndividual2IndividualPointerMap.put(oWLIndividual, this.lastIndividualPointer);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataType oWLDataType) {
        try {
            this.lastDataTypeExpressionPointer = null;
            this.lastDataTypePointer = (DataTypePointer)this.owlDataRange2DataTypeExpressionPointerMap.get(oWLDataType);
            if (this.lastDataTypePointer == null) {
                this.lastDataTypePointer = this.owlOntologyManager.getOWLDataFactory().getTopDataType().equals(oWLDataType) ? this.faCTPlusPlus.getDataTop() : this.faCTPlusPlus.getBuiltInDataType(oWLDataType.getURI().toString());
                this.owlDataRange2DataTypeExpressionPointerMap.put((OWLDataRange)oWLDataType, this.lastDataTypePointer);
                this.dataTypeExpressionPointerMap.put(this.lastDataTypePointer, (OWLDataRange)oWLDataType);
            }
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public OWLObject getOWLObject(Pointer pointer) {
        if (pointer instanceof ClassPointer) {
            return this.getOWLClass((ClassPointer)pointer);
        }
        if (pointer instanceof ObjectPropertyPointer) {
            return this.getOWLObjectProperty((ObjectPropertyPointer)pointer);
        }
        if (pointer instanceof DataPropertyPointer) {
            return this.getOWLDataProperty((DataPropertyPointer)pointer);
        }
        if (pointer instanceof IndividualPointer) {
            return this.getOWLIndividual((IndividualPointer)pointer);
        }
        if (pointer instanceof DataValuePointer) {
            return this.getOWLConstant((DataValuePointer)pointer);
        }
        if (pointer instanceof DataTypeExpressionPointer) {
            return this.getOWLDataRange((DataTypeExpressionPointer)pointer);
        }
        return null;
    }

    public OWLClass getOWLClass(ClassPointer classPointer) {
        return this.classPointerMap.get(classPointer);
    }

    public OWLObjectProperty getOWLObjectProperty(ObjectPropertyPointer objectPropertyPointer) {
        return this.objectPropertyPointerMap.get(objectPropertyPointer);
    }

    public OWLDataProperty getOWLDataProperty(DataPropertyPointer dataPropertyPointer) {
        return this.dataPropertyPointerMap.get(dataPropertyPointer);
    }

    public OWLIndividual getOWLIndividual(IndividualPointer individualPointer) {
        return this.individualPointerMap.get(individualPointer);
    }

    public OWLConstant getOWLConstant(DataValuePointer dataValuePointer) {
        return this.dataValuePointerMap.get(dataValuePointer);
    }

    public OWLDataRange getOWLDataRange(DataTypeExpressionPointer dataTypeExpressionPointer) {
        return this.dataTypeExpressionPointerMap.get(dataTypeExpressionPointer);
    }
}

