/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.inference.MonitorableOWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLAxiomChange;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyManager;
import uk.ac.manchester.cs.factplusplus.ClassPointer;
import uk.ac.manchester.cs.factplusplus.DataPropertyPointer;
import uk.ac.manchester.cs.factplusplus.DataTypeExpressionPointer;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlus;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlusProgressMonitor;
import uk.ac.manchester.cs.factplusplus.ObjectPropertyPointer;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusReasonerException;
import uk.ac.manchester.cs.factplusplus.owlapi.OntologyLoader;
import uk.ac.manchester.cs.factplusplus.owlapi.Translator;
import uk.ac.manchester.cs.factplusplus.owlapi.TranslatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reasoner
extends MonitorableOWLReasonerAdapter
implements FaCTPlusPlusProgressMonitor {
    private static final Logger logger = Logger.getLogger(Reasoner.class.getName());
    private Exception lastException;
    private OntologyLoader loader;
    private FaCTPlusPlus faCTPlusPlus;
    private final Translator translator;
    private boolean autoSync = false;
    private State state = State.EMPTY;
    private TranslatorUtils translatorUtils;
    private boolean incremental = true;
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
    private int count;

    public Reasoner(OWLOntologyManager oWLOntologyManager) throws Exception {
        super(oWLOntologyManager);
        this.faCTPlusPlus = new FaCTPlusPlus();
        this.translator = new Translator(oWLOntologyManager, this.faCTPlusPlus);
        this.loader = new OntologyLoader(this.getOWLOntologyManager(), this.translator);
        this.translatorUtils = new TranslatorUtils(oWLOntologyManager, this.translator);
    }

    public String toString() {
        return "FaCT++";
    }

    public void disposeReasoner() {
        try {
            if (this.faCTPlusPlus == null) {
                return;
            }
            this.faCTPlusPlus.dispose();
            this.faCTPlusPlus = null;
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
        }
    }

    public boolean isSychroniseOnlyOnClassify() {
        return !this.autoSync;
    }

    public void setSychroniseOnlyOnClassify(boolean bl) {
        this.autoSync = !bl;
    }

    public void setModeIncremental(boolean bl) {
        this.incremental = bl;
    }

    public final State getState() {
        return this.state;
    }

    public FaCTPlusPlus getReasoner() {
        return this.faCTPlusPlus;
    }

    public void classify() throws OWLReasonerException {
        while (this.state != State.CLASSIFIED_IN_SYNC) {
            switch (this.state) {
                case FAIL: {
                    throw new FaCTPlusPlusReasonerException(this.lastException);
                }
                case EMPTY: {
                    this.load();
                    break;
                }
                case UNCLASSIFIED_DIRTY: 
                case CLASSIFIED_DIRTY: {
                    this.resync();
                    break;
                }
                case UNCLASSIFIED_IN_SYNC: {
                    this.doClassify();
                    break;
                }
            }
        }
    }

    private void load() throws OWLReasonerException {
        try {
            this.faCTPlusPlus.setProgressMonitor(this);
            this.loader.loadOntologies(this.getLoadedOntologies());
            this.state = State.UNCLASSIFIED_IN_SYNC;
        }
        catch (Exception exception) {
            this.lastException = exception;
            this.state = State.FAIL;
        }
    }

    private void resync() {
        try {
            if (this.incremental) {
                if (!this.changes.isEmpty()) {
                    this.loader.applyChanges(this.changes);
                    this.changes.clear();
                    this.state = State.UNCLASSIFIED_IN_SYNC;
                }
            } else {
                this.clear();
                this.load();
            }
        }
        catch (Exception exception) {
            this.lastException = exception;
            this.state = State.FAIL;
        }
    }

    private void doClassify() {
        try {
            this.getReasoner().classify();
            this.state = State.CLASSIFIED_IN_SYNC;
        }
        catch (Exception exception) {
            this.lastException = exception;
            this.state = State.FAIL;
        }
    }

    private void clear() {
        try {
            this.getReasoner().clearKernel();
            this.loader.clear();
            this.translator.reset();
            this.changes.clear();
            this.state = State.EMPTY;
        }
        catch (Exception exception) {
            this.lastException = exception;
            this.state = State.FAIL;
        }
    }

    protected void ontologiesCleared() throws OWLReasonerException {
        this.clear();
        if (this.state == State.FAIL && this.lastException != null) {
            throw new FaCTPlusPlusReasonerException(this.lastException);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> list) throws OWLException {
        ArrayList<OWLAxiomChange> arrayList = null;
        for (OWLOntologyChange oWLOntologyChange : list) {
            if (!this.getLoadedOntologies().contains(oWLOntologyChange.getOntology()) || !oWLOntologyChange.isAxiomChange()) continue;
            OWLAxiomChange oWLAxiomChange = (OWLAxiomChange)oWLOntologyChange;
            if (arrayList == null) {
                arrayList = new ArrayList<OWLAxiomChange>();
            }
            arrayList.add(oWLAxiomChange);
        }
        if (arrayList != null) {
            this.handleOntologyChanges(arrayList);
        }
    }

    protected void ontologiesChanged() throws OWLReasonerException {
        this.clear();
        if (this.state == State.FAIL && this.lastException != null) {
            throw new FaCTPlusPlusReasonerException(this.lastException);
        }
    }

    protected void handleOntologyChanges(List<OWLOntologyChange> list) throws OWLReasonerException {
        switch (this.state) {
            case FAIL: 
            case UNCLASSIFIED_DIRTY: 
            case UNCLASSIFIED_IN_SYNC: {
                if (this.incremental) {
                    this.changes.addAll(list);
                }
                this.state = State.UNCLASSIFIED_DIRTY;
                break;
            }
            case CLASSIFIED_DIRTY: 
            case CLASSIFIED_IN_SYNC: {
                if (this.incremental) {
                    this.changes.addAll(list);
                }
                this.state = State.CLASSIFIED_DIRTY;
                break;
            }
        }
    }

    private void autoSynchronise() throws Exception {
        switch (this.state) {
            case FAIL: {
                throw this.lastException;
            }
            case EMPTY: {
                if (!this.autoSync) break;
                this.load();
                break;
            }
            case UNCLASSIFIED_DIRTY: 
            case CLASSIFIED_DIRTY: {
                if (!this.autoSync) break;
                this.resync();
            }
        }
    }

    public boolean isDefined(OWLClass oWLClass) throws OWLReasonerException {
        return this.containsReference(oWLClass);
    }

    public boolean isDefined(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        return this.containsReference(oWLObjectProperty);
    }

    public boolean isDefined(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        return this.containsReference(oWLDataProperty);
    }

    public boolean isDefined(OWLIndividual oWLIndividual) throws OWLReasonerException {
        return this.containsReference(oWLIndividual);
    }

    public boolean containsReference(OWLClass oWLClass) {
        return this.translator.contains(oWLClass);
    }

    public boolean containsReference(OWLObjectProperty oWLObjectProperty) {
        return this.translator.contains(oWLObjectProperty);
    }

    public boolean containsReference(OWLDataProperty oWLDataProperty) {
        return this.translator.contains(oWLDataProperty);
    }

    public boolean containsReference(OWLIndividual oWLIndividual) {
        return this.translator.contains(oWLIndividual);
    }

    public boolean isClassified() throws OWLReasonerException {
        return this.state == State.CLASSIFIED_IN_SYNC;
    }

    public boolean isRealised() throws OWLReasonerException {
        return this.isClassified();
    }

    public void realise() throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.faCTPlusPlus.realise();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isConsistent(OWLOntology oWLOntology) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            return this.faCTPlusPlus.isKBConsistent();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isSubClassOf(OWLDescription oWLDescription, OWLDescription oWLDescription2) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            return this.getReasoner().isClassSubsumedBy(this.translator.translate(oWLDescription), this.translator.translate(oWLDescription2));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isEquivalentClass(OWLDescription oWLDescription, OWLDescription oWLDescription2) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            return this.getReasoner().isClassEquivalentTo(this.translator.translate(oWLDescription), this.translator.translate(oWLDescription2));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isSatisfiable(OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            if (!this.faCTPlusPlus.isKBConsistent()) {
                return false;
            }
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            return this.getReasoner().isClassSatisfiable(this.translator.translate(oWLDescription));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLClass>> getSuperClasses(OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            ClassPointer[][] classPointerArray = this.getReasoner().askSuperClasses(this.translator.translate(oWLDescription), true);
            return this.translatorUtils.getOWLAPISets(classPointerArray);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLClass>> getAncestorClasses(OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            ClassPointer[][] classPointerArray = this.getReasoner().askSuperClasses(this.translator.translate(oWLDescription), false);
            return this.translatorUtils.getOWLAPISets(classPointerArray);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLClass>> getSubClasses(OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            ClassPointer[][] classPointerArray = this.getReasoner().askSubClasses(this.translator.translate(oWLDescription), true);
            return this.translatorUtils.getOWLAPISets(classPointerArray);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLClass>> getDescendantClasses(OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            ClassPointer[][] classPointerArray = this.getReasoner().askSubClasses(this.translator.translate(oWLDescription), false);
            return this.translatorUtils.getOWLAPISets(classPointerArray);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLClass> getEquivalentClasses(OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            return this.translatorUtils.getOWLAPISet(this.getReasoner().askEquivalentClasses(this.translator.translate(oWLDescription)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isInstanceOf(OWLIndividual oWLIndividual, OWLDescription oWLDescription) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual, oWLDescription});
            return this.getReasoner().isInstanceOf(this.translator.translate(oWLIndividual), this.translator.translate(oWLDescription));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLClass> getInconsistentClasses() throws OWLReasonerException {
        try {
            this.autoSynchronise();
            return this.getEquivalentClasses((OWLDescription)this.getOWLDataFactory().getOWLNothing());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLIndividual> getIndividuals(OWLDescription oWLDescription, boolean bl) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDescription});
            return this.translatorUtils.getOWLAPISet(this.getReasoner().askInstances(this.translator.translate(oWLDescription), bl));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLClass>> getTypes(OWLIndividual oWLIndividual, boolean bl) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual});
            return this.translatorUtils.getOWLAPISets(this.getReasoner().askIndividualTypes(this.translator.translate(oWLIndividual), bl));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Map<OWLObjectProperty, Set<OWLIndividual>> getObjectPropertyRelationships(OWLIndividual oWLIndividual) throws OWLReasonerException {
        try {
            ObjectPropertyPointer[] objectPropertyPointerArray;
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual});
            HashMap<OWLObjectProperty, Set<OWLIndividual>> hashMap = new HashMap<OWLObjectProperty, Set<OWLIndividual>>();
            for (ObjectPropertyPointer objectPropertyPointer : objectPropertyPointerArray = this.getReasoner().askObjectProperties(this.translator.translate(oWLIndividual))) {
                Set set = this.translatorUtils.getOWLAPISet(this.getReasoner().askRelatedIndividuals(this.translator.translate(oWLIndividual), objectPropertyPointer));
                if (set.isEmpty()) continue;
                hashMap.put(this.translator.getOWLObjectProperty(objectPropertyPointer), set);
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Map<OWLDataProperty, Set<OWLConstant>> getDataPropertyRelationships(OWLIndividual oWLIndividual) throws OWLReasonerException {
        try {
            DataPropertyPointer[] dataPropertyPointerArray;
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual});
            HashMap<OWLDataProperty, Set<OWLConstant>> hashMap = new HashMap<OWLDataProperty, Set<OWLConstant>>();
            for (DataPropertyPointer dataPropertyPointer : dataPropertyPointerArray = this.getReasoner().askDataProperties(this.translator.translate(oWLIndividual))) {
                Set set = this.translatorUtils.getOWLAPISet(this.getReasoner().askRelatedValues(this.translator.translate(oWLIndividual), dataPropertyPointer));
                if (set.isEmpty()) continue;
                hashMap.put(this.translator.getOWLDataProperty(dataPropertyPointer), set);
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLIndividual> getRelatedIndividuals(OWLIndividual oWLIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual, oWLObjectPropertyExpression});
            return this.translatorUtils.getOWLAPISet(this.getReasoner().askRelatedIndividuals(this.translator.translate(oWLIndividual), this.translator.translate(oWLObjectPropertyExpression)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLConstant> getRelatedValues(OWLIndividual oWLIndividual, OWLDataPropertyExpression oWLDataPropertyExpression) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual, oWLDataPropertyExpression});
            return this.translatorUtils.getOWLAPISet(this.getReasoner().askRelatedValues(this.translator.translate(oWLIndividual), this.translator.translate(oWLDataPropertyExpression)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean hasDataPropertyRelationship(OWLIndividual oWLIndividual, OWLDataPropertyExpression oWLDataPropertyExpression, OWLConstant oWLConstant) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual, oWLDataPropertyExpression});
            return this.getReasoner().hasDataPropertyRelationship(this.translator.translate(oWLIndividual), this.translator.translate(oWLDataPropertyExpression), this.translator.translate(oWLConstant));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean hasObjectPropertyRelationship(OWLIndividual oWLIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLIndividual oWLIndividual2) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual, oWLIndividual2});
            return this.getReasoner().hasObjectPropertyRelationship(this.translator.translate(oWLIndividual), this.translator.translate(oWLObjectPropertyExpression), this.translator.translate(oWLIndividual2));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean hasType(OWLIndividual oWLIndividual, OWLDescription oWLDescription, boolean bl) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLIndividual, oWLDescription});
            return this.getIndividuals(oWLDescription, bl).contains(oWLIndividual);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLObjectProperty>> getSuperProperties(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSuperObjectProperties(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty), true));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLObjectProperty>> getSubProperties(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSubObjectProperties(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty), true));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLObjectProperty>> getAncestorProperties(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSuperObjectProperties(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty), false));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLObjectProperty>> getDescendantProperties(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSubObjectProperties(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty), false));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLObjectProperty>> getInverseProperties(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            OWLObjectProperty oWLObjectProperty2 = this.translator.getOWLObjectProperty(this.faCTPlusPlus.getInverseProperty(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty)));
            HashSet<Set<OWLObjectProperty>> hashSet = new HashSet<Set<OWLObjectProperty>>();
            Set<Object> set = Collections.emptySet();
            if (oWLObjectProperty2 != null) {
                set = this.getEquivalentProperties(oWLObjectProperty2);
                set.add(oWLObjectProperty2);
            }
            hashSet.add(set);
            return hashSet;
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLObjectProperty> getEquivalentProperties(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPISet(this.faCTPlusPlus.askEquivalentObjectProperties(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLDescription>> getDomains(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPIDescriptionSets(this.getReasoner().askObjectPropertyDomain(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLDescription> getRanges(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.translatorUtils.getOWLAPIDescriptionSet(this.getReasoner().askObjectPropertyRange(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isFunctional(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertyFunctional(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isInverseFunctional(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertyInverseFunctional(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isSymmetric(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertySymmetric(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isTransitive(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertyTransitive(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isReflexive(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertyReflexive(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isIrreflexive(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertyIrreflexive(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isAntiSymmetric(OWLObjectProperty oWLObjectProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLObjectProperty});
            return this.getReasoner().isObjectPropertyAntiSymmetric(this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLDataProperty>> getSuperProperties(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSuperDataProperties(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty), true));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLDataProperty>> getSubProperties(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSubDataProperties(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty), true));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLDataProperty>> getAncestorProperties(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSuperDataProperties(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty), false));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLDataProperty>> getDescendantProperties(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPISets(this.faCTPlusPlus.askSubDataProperties(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty), false));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLDataProperty> getEquivalentProperties(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPISet(this.faCTPlusPlus.askEquivalentDataProperties(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<Set<OWLDescription>> getDomains(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPIDescriptionSets(this.getReasoner().askDataPropertyDomain(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty)));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public Set<OWLDataRange> getRanges(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.translatorUtils.getOWLAPISet(new DataTypeExpressionPointer[]{this.getReasoner().askDataPropertyRange(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty))});
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public boolean isFunctional(OWLDataProperty oWLDataProperty) throws OWLReasonerException {
        try {
            this.autoSynchronise();
            this.translatorUtils.checkParams(new OWLObject[]{oWLDataProperty});
            return this.faCTPlusPlus.isDataPropertyFunctional(this.translator.translate((OWLDataPropertyExpression)oWLDataProperty));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusReasonerException(exception);
        }
    }

    public OWLEntity getCurrentEntity() {
        return null;
    }

    @Override
    public void setClassificationStarted(int n) {
        this.count = 0;
        this.getProgressMonitor().setSize((long)n);
        this.getProgressMonitor().setStarted();
    }

    @Override
    public void setCurrentClass(String string) {
        ++this.count;
        this.getProgressMonitor().setProgress((long)this.count);
    }

    @Override
    public void setFinished() {
        this.getProgressMonitor().setFinished();
    }

    @Override
    public boolean isCancelled() {
        return this.getProgressMonitor().isCancelled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        EMPTY,
        UNCLASSIFIED_IN_SYNC,
        UNCLASSIFIED_DIRTY,
        CLASSIFIED_IN_SYNC,
        CLASSIFIED_DIRTY,
        FAIL;

    }
}

