/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeVisitor;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.SetOntologyURI;
import uk.ac.manchester.cs.factplusplus.AxiomPointer;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlusException;
import uk.ac.manchester.cs.factplusplus.owlapi.AxiomLoader;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusAxiomFilter;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusRuntimeException;
import uk.ac.manchester.cs.factplusplus.owlapi.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyLoader {
    private static final Logger logger = Logger.getLogger(OntologyLoader.class.getName());
    private OWLOntologyManager mngr;
    private Translator translator;
    private AxiomLoader axiomLoader;
    private FaCTPlusPlusAxiomFilter filter;
    private Map<OWLAxiom, AxiomPointer> axiom2PtrMap = new HashMap<OWLAxiom, AxiomPointer>();
    private OWLOntologyChangeVisitor changeVisitor = new OWLOntologyChangeVisitor(){

        public void visit(AddAxiom addAxiom) {
            try {
                OntologyLoader.this.loadAxiom(addAxiom.getAxiom());
            }
            catch (FaCTPlusPlusException faCTPlusPlusException) {
                throw new FaCTPlusPlusRuntimeException(faCTPlusPlusException);
            }
        }

        public void visit(RemoveAxiom removeAxiom) {
            try {
                OntologyLoader.this.retractAxiom(removeAxiom.getAxiom());
            }
            catch (FaCTPlusPlusException faCTPlusPlusException) {
                throw new FaCTPlusPlusRuntimeException(faCTPlusPlusException);
            }
        }

        public void visit(SetOntologyURI setOntologyURI) {
        }
    };

    public OntologyLoader(OWLOntologyManager oWLOntologyManager, Translator translator) {
        this.mngr = oWLOntologyManager;
        this.translator = translator;
        this.axiomLoader = new AxiomLoader(translator);
        this.filter = new FaCTPlusPlusAxiomFilter();
        try {
            translator.translate((OWLDescription)oWLOntologyManager.getOWLDataFactory().getOWLThing());
            translator.translate((OWLDescription)oWLOntologyManager.getOWLDataFactory().getOWLNothing());
        }
        catch (OWLException oWLException) {
            throw new FaCTPlusPlusRuntimeException(oWLException);
        }
        logger.setLevel(Level.INFO);
    }

    public void clear() {
        this.axiom2PtrMap.clear();
    }

    public void loadOntologies(Set<OWLOntology> set) throws FaCTPlusPlusException {
        for (OWLOntology oWLOntology : set) {
            this.loadAxioms(oWLOntology.getAxioms());
        }
    }

    public void loadAxioms(Set<OWLAxiom> set) throws FaCTPlusPlusException {
        for (OWLAxiom oWLAxiom : set) {
            this.loadAxiom(oWLAxiom);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadAxiom(OWLAxiom oWLAxiom) throws FaCTPlusPlusException {
        if (this.filter.passes(oWLAxiom)) {
            AxiomPointer axiomPointer = this.axiomLoader.load(oWLAxiom);
            if (axiomPointer == null) throw new FaCTPlusPlusException("Failed to load axiom: " + oWLAxiom);
            this.axiom2PtrMap.put(oWLAxiom, axiomPointer);
            return;
        } else {
            if (this.filter.getReason().length() <= 0) return;
            logger.info("WARNING! Ignoring axiom: " + oWLAxiom + " [" + this.filter.getReason() + "]");
        }
    }

    public void retractAxiom(OWLAxiom oWLAxiom) throws FaCTPlusPlusException {
        if (this.filter.passes(oWLAxiom)) {
            AxiomPointer axiomPointer = this.axiom2PtrMap.get(oWLAxiom);
            if (axiomPointer != null) {
                this.translator.getFaCTPlusPlus().retract(axiomPointer);
                this.axiom2PtrMap.remove(oWLAxiom);
            } else {
                throw new FaCTPlusPlusException("Axiom (" + oWLAxiom + ") not known in the reasoner");
            }
        }
    }

    public void applyChanges(List<OWLOntologyChange> list) throws OWLException {
        this.translator.getFaCTPlusPlus().startChanges();
        for (OWLOntologyChange oWLOntologyChange : list) {
            oWLOntologyChange.accept(this.changeVisitor);
        }
        this.translator.getFaCTPlusPlus().endChanges();
    }
}

