/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.OWLRestrictedDataRangeFacetVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class FaCTPlusPlusRenderer
implements OWLObjectVisitor {
    private Writer writer;
    private Map<OWLRestrictedDataRangeFacetVocabulary, String> facetRenderingMap;

    public FaCTPlusPlusRenderer(Writer writer) {
        this.writer = writer;
        this.facetRenderingMap = new HashMap<OWLRestrictedDataRangeFacetVocabulary, String>();
        this.facetRenderingMap.put(OWLRestrictedDataRangeFacetVocabulary.MIN_INCLUSIVE, "ge");
        this.facetRenderingMap.put(OWLRestrictedDataRangeFacetVocabulary.MAX_INCLUSIVE, "le");
        this.facetRenderingMap.put(OWLRestrictedDataRangeFacetVocabulary.MIN_EXCLUSIVE, "gt");
        this.facetRenderingMap.put(OWLRestrictedDataRangeFacetVocabulary.MAX_EXCLUSIVE, "lt");
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void write(OWLObject oWLObject) {
        this.write(" ");
        oWLObject.accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSubClassAxiom oWLSubClassAxiom) {
        this.write("implies_c");
        this.write((OWLObject)oWLSubClassAxiom.getSubClass());
        this.write((OWLObject)oWLSubClassAxiom.getSuperClass());
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        this.write("not-related");
        this.write((OWLObject)oWLNegativeObjectPropertyAssertionAxiom.getSubject());
        this.write((OWLObject)oWLNegativeObjectPropertyAssertionAxiom.getProperty());
        this.write(oWLNegativeObjectPropertyAssertionAxiom.getObject());
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom oWLAntiSymmetricObjectPropertyAxiom) {
        this.write("antisymmetric");
        this.write((OWLObject)oWLAntiSymmetricObjectPropertyAxiom.getProperty());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        this.write("reflexive");
        this.write((OWLObject)oWLReflexiveObjectPropertyAxiom.getProperty());
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        this.write("disjoint");
        for (OWLDescription oWLDescription : oWLDisjointClassesAxiom.getDescriptions()) {
            this.write((OWLObject)oWLDescription);
        }
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        this.write("domain");
        this.write((OWLObject)oWLDataPropertyDomainAxiom.getProperty());
        this.write((OWLObject)oWLDataPropertyDomainAxiom.getDomain());
    }

    public void visit(OWLEntityAnnotationAxiom oWLEntityAnnotationAxiom) {
    }

    public void visit(OWLImportsDeclaration oWLImportsDeclaration) {
    }

    public void visit(OWLAxiomAnnotationAxiom oWLAxiomAnnotationAxiom) {
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        this.write("domain ");
        this.write((OWLObject)oWLObjectPropertyDomainAxiom.getProperty());
        this.write((OWLObject)oWLObjectPropertyDomainAxiom.getDomain());
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        this.write("equal_r");
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLEquivalentObjectPropertiesAxiom.getProperties()) {
            this.write((OWLObject)oWLObjectPropertyExpression);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        this.write("instance");
        this.write((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getSubject());
        this.write("(all ");
        this.write((OWLObject)oWLNegativeDataPropertyAssertionAxiom.getProperty());
        this.write("(not ");
        this.write(oWLNegativeDataPropertyAssertionAxiom.getObject());
        this.write("))");
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        this.write("different ");
        for (OWLIndividual oWLIndividual : oWLDifferentIndividualsAxiom.getIndividuals()) {
            this.write((OWLObject)oWLIndividual);
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        this.write("disjoint_r");
        for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLDisjointDataPropertiesAxiom.getProperties()) {
            this.write((OWLObject)oWLDataPropertyExpression);
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        this.write("disjoint_r");
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLDisjointObjectPropertiesAxiom.getProperties()) {
            this.write((OWLObject)oWLObjectPropertyExpression);
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        this.write("range");
        this.write((OWLObject)oWLObjectPropertyRangeAxiom.getProperty());
        this.write((OWLObject)oWLObjectPropertyRangeAxiom.getRange());
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        this.write("related");
        this.write((OWLObject)oWLObjectPropertyAssertionAxiom.getSubject());
        this.write((OWLObject)oWLObjectPropertyAssertionAxiom.getProperty());
        this.write(oWLObjectPropertyAssertionAxiom.getObject());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        this.write("functional");
        this.write((OWLObject)oWLFunctionalObjectPropertyAxiom.getProperty());
    }

    public void visit(OWLObjectSubPropertyAxiom oWLObjectSubPropertyAxiom) {
        this.write("implies_r");
        this.write((OWLObject)oWLObjectSubPropertyAxiom.getSubProperty());
        this.write((OWLObject)oWLObjectSubPropertyAxiom.getSuperProperty());
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        this.write("equal_c ");
        oWLDisjointUnionAxiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.write("(disjoint-or ");
        for (OWLDescription oWLDescription : oWLDisjointUnionAxiom.getDescriptions()) {
            oWLDescription.accept((OWLObjectVisitor)this);
            this.write(" ");
        }
        this.write(")");
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        this.write("symmetric");
        this.write((OWLObject)oWLSymmetricObjectPropertyAxiom.getProperty());
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        if (!(oWLDataPropertyRangeAxiom.getRange() instanceof OWLDataOneOf)) {
            this.write("range");
            this.write((OWLObject)oWLDataPropertyRangeAxiom.getProperty());
            this.write((OWLObject)oWLDataPropertyRangeAxiom.getRange());
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        this.write("functional");
        this.write((OWLObject)oWLFunctionalDataPropertyAxiom.getProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        this.write("equal_r");
        for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLEquivalentDataPropertiesAxiom.getProperties()) {
            this.write((OWLObject)oWLDataPropertyExpression);
        }
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        this.write("instance");
        this.write((OWLObject)oWLClassAssertionAxiom.getIndividual());
        this.write((OWLObject)oWLClassAssertionAxiom.getDescription());
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        this.write("equal_c");
        for (OWLDescription oWLDescription : oWLEquivalentClassesAxiom.getDescriptions()) {
            this.write((OWLObject)oWLDescription);
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        this.write("instance");
        this.write((OWLObject)oWLDataPropertyAssertionAxiom.getSubject());
        this.write("(some ");
        this.write((OWLObject)oWLDataPropertyAssertionAxiom.getProperty());
        this.write(oWLDataPropertyAssertionAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        this.write("transitive");
        this.write((OWLObject)oWLTransitiveObjectPropertyAxiom.getProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        this.write("irreflexive");
        this.write((OWLObject)oWLIrreflexiveObjectPropertyAxiom.getProperty());
    }

    public void visit(OWLDataSubPropertyAxiom oWLDataSubPropertyAxiom) {
        this.write("implies_r");
        this.write((OWLObject)oWLDataSubPropertyAxiom.getSubProperty());
        this.write((OWLObject)oWLDataSubPropertyAxiom.getSuperProperty());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        this.write("functional (inverse");
        this.write((OWLObject)oWLInverseFunctionalObjectPropertyAxiom.getProperty());
        this.write(")");
    }

    public void visit(OWLSameIndividualsAxiom oWLSameIndividualsAxiom) {
        this.write("same");
        for (OWLIndividual oWLIndividual : oWLSameIndividualsAxiom.getIndividuals()) {
            this.write((OWLObject)oWLIndividual);
        }
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom oWLObjectPropertyChainSubPropertyAxiom) {
        this.write("implies_r (compose ");
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLObjectPropertyChainSubPropertyAxiom.getPropertyChain()) {
            this.write((OWLObject)oWLObjectPropertyExpression);
        }
        this.write(")");
        this.write((OWLObject)oWLObjectPropertyChainSubPropertyAxiom.getSuperProperty());
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        this.write("equal_r");
        this.write((OWLObject)oWLInverseObjectPropertiesAxiom.getFirstProperty());
        this.write(" (inverse");
        this.write((OWLObject)oWLInverseObjectPropertiesAxiom.getSecondProperty());
        this.write(")");
    }

    public void visit(OWLClass oWLClass) {
        if (oWLClass.getURI().equals(OWLRDFVocabulary.OWL_THING.getURI())) {
            this.write("*TOP*");
        } else if (oWLClass.getURI().equals(OWLRDFVocabulary.OWL_NOTHING.getURI())) {
            this.write("*BOTTOM*");
        } else {
            this.write(oWLClass.getURI().toString());
        }
    }

    public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
        this.write("(and");
        for (OWLDescription oWLDescription : oWLObjectIntersectionOf.getOperands()) {
            this.write((OWLObject)oWLDescription);
        }
        this.write(")");
    }

    public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
        this.write("(or");
        for (OWLDescription oWLDescription : oWLObjectUnionOf.getOperands()) {
            this.write((OWLObject)oWLDescription);
        }
        this.write(")");
    }

    public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
        this.write("(not");
        this.write((OWLObject)oWLObjectComplementOf.getOperand());
        this.write(")");
    }

    public void visit(OWLObjectSomeRestriction oWLObjectSomeRestriction) {
        this.write("(some");
        this.write((OWLObject)oWLObjectSomeRestriction.getProperty());
        this.write((OWLObject)oWLObjectSomeRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLObjectAllRestriction oWLObjectAllRestriction) {
        this.write("(all");
        this.write((OWLObject)oWLObjectAllRestriction.getProperty());
        this.write((OWLObject)oWLObjectAllRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLObjectValueRestriction oWLObjectValueRestriction) {
        this.write("(some");
        this.write((OWLObject)oWLObjectValueRestriction.getProperty());
        this.write(" (one-of");
        this.write(oWLObjectValueRestriction.getValue());
        this.write("))");
    }

    public void visit(OWLObjectMinCardinalityRestriction oWLObjectMinCardinalityRestriction) {
        this.write("(atleast ");
        this.write(Integer.toString(oWLObjectMinCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLObjectMinCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLObjectMinCardinalityRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLObjectExactCardinalityRestriction oWLObjectExactCardinalityRestriction) {
        this.write("(and (atleast ");
        this.write(Integer.toString(oWLObjectExactCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLObjectExactCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLObjectExactCardinalityRestriction.getFiller());
        this.write(") (atmost ");
        this.write(Integer.toString(oWLObjectExactCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLObjectExactCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLObjectExactCardinalityRestriction.getFiller());
        this.write("))");
    }

    public void visit(OWLObjectMaxCardinalityRestriction oWLObjectMaxCardinalityRestriction) {
        this.write("(atmost ");
        this.write(Integer.toString(oWLObjectMaxCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLObjectMaxCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLObjectMaxCardinalityRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLObjectSelfRestriction oWLObjectSelfRestriction) {
        this.write("(self-ref");
        this.write((OWLObject)oWLObjectSelfRestriction.getProperty());
        this.write(")");
    }

    public void visit(OWLObjectOneOf oWLObjectOneOf) {
        this.write("(one-of");
        for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
            this.write((OWLObject)oWLIndividual);
        }
        this.write(")");
    }

    public void visit(OWLDataSomeRestriction oWLDataSomeRestriction) {
        this.write("(some");
        this.write((OWLObject)oWLDataSomeRestriction.getProperty());
        this.write((OWLObject)oWLDataSomeRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLDataAllRestriction oWLDataAllRestriction) {
        this.write("(all");
        this.write((OWLObject)oWLDataAllRestriction.getProperty());
        this.write((OWLObject)oWLDataAllRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLDataValueRestriction oWLDataValueRestriction) {
        this.write("(some");
        this.write((OWLObject)oWLDataValueRestriction.getProperty());
        this.write(oWLDataValueRestriction.getValue());
        this.write(")");
    }

    public void visit(OWLDataMinCardinalityRestriction oWLDataMinCardinalityRestriction) {
        this.write("(atleast ");
        this.write(Integer.toString(oWLDataMinCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLDataMinCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLDataMinCardinalityRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLDataExactCardinalityRestriction oWLDataExactCardinalityRestriction) {
        this.write("(and (atleast ");
        this.write(Integer.toString(oWLDataExactCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLDataExactCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLDataExactCardinalityRestriction.getFiller());
        this.write(") (atmost ");
        this.write(Integer.toString(oWLDataExactCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLDataExactCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLDataExactCardinalityRestriction.getFiller());
        this.write("))");
    }

    public void visit(OWLDataMaxCardinalityRestriction oWLDataMaxCardinalityRestriction) {
        this.write("(atmost ");
        this.write(Integer.toString(oWLDataMaxCardinalityRestriction.getCardinality()));
        this.write((OWLObject)oWLDataMaxCardinalityRestriction.getProperty());
        this.write((OWLObject)oWLDataMaxCardinalityRestriction.getFiller());
        this.write(")");
    }

    public void visit(OWLDataType oWLDataType) {
        if (oWLDataType.getURI().equals(XSDVocabulary.STRING.getURI())) {
            this.write("string");
        } else if (oWLDataType.getURI().equals(XSDVocabulary.DOUBLE.getURI())) {
            this.write("real");
        } else if (oWLDataType.getURI().equals(XSDVocabulary.FLOAT.getURI())) {
            this.write("real");
        } else {
            this.write("number");
        }
    }

    public void visit(OWLDataComplementOf oWLDataComplementOf) {
        this.write("(not ");
        oWLDataComplementOf.getDataRange().accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLDataOneOf oWLDataOneOf) {
        throw new OWLRuntimeException("Unsupported operation");
    }

    public void visit(OWLDataRangeRestriction oWLDataRangeRestriction) {
        this.write("(and");
        for (OWLDataRangeFacetRestriction oWLDataRangeFacetRestriction : oWLDataRangeRestriction.getFacetRestrictions()) {
            oWLDataRangeFacetRestriction.accept((OWLObjectVisitor)this);
        }
        this.write(")");
    }

    public void visit(OWLDataRangeFacetRestriction oWLDataRangeFacetRestriction) {
        this.write("(");
        String string = this.facetRenderingMap.get(oWLDataRangeFacetRestriction.getFacet());
        if (string == null) {
            this.write("\n;unsupported facet " + oWLDataRangeFacetRestriction.getFacet());
        } else {
            this.write(string);
            oWLDataRangeFacetRestriction.getFacetValue().accept((OWLObjectVisitor)this);
        }
        this.write(")");
    }

    public void visit(OWLTypedConstant oWLTypedConstant) {
        this.write("(");
        oWLTypedConstant.getDataType().accept((OWLObjectVisitor)this);
        this.write(" ");
        if (oWLTypedConstant.getDataType().getURI().equals(XSDVocabulary.STRING.getURI())) {
            this.write("\"");
            this.write(oWLTypedConstant.getLiteral());
            this.write("\"");
        } else {
            this.write(oWLTypedConstant.getLiteral());
        }
        this.write(")");
    }

    public void visit(OWLUntypedConstant oWLUntypedConstant) {
        this.write("(string \"");
        this.write(oWLUntypedConstant.getLiteral());
        this.write("\")");
    }

    public void visit(OWLObjectProperty oWLObjectProperty) {
        this.write(oWLObjectProperty.getURI().toString());
    }

    public void visit(OWLObjectPropertyInverse oWLObjectPropertyInverse) {
        this.write("(inverse");
        this.write((OWLObject)oWLObjectPropertyInverse.getInverse());
        this.write(")");
    }

    public void visit(OWLDataProperty oWLDataProperty) {
        this.write(oWLDataProperty.getURI().toString());
    }

    public void visit(OWLIndividual oWLIndividual) {
        this.write(oWLIndividual.getURI().toString());
    }

    public void visit(OWLOntology oWLOntology) {
        for (OWLObjectProperty oWLObjectProperty : oWLOntology.getReferencedObjectProperties()) {
            this.write("(defprimrole");
            this.write((OWLObject)oWLObjectProperty);
            this.write(")\n");
        }
        for (OWLObjectProperty oWLObjectProperty : oWLOntology.getReferencedDataProperties()) {
            this.write("(defdatarole");
            this.write((OWLObject)oWLObjectProperty);
            this.write(")\n");
        }
        for (OWLObjectProperty oWLObjectProperty : oWLOntology.getAxioms()) {
            if (!oWLObjectProperty.isLogicalAxiom()) continue;
            this.write("(");
            this.write((OWLObject)oWLObjectProperty);
            this.write(")\n");
        }
    }

    public void visit(SWRLRule sWRLRule) {
    }

    public void visit(OWLConstantAnnotation oWLConstantAnnotation) {
    }

    public void visit(OWLObjectAnnotation oWLObjectAnnotation) {
    }

    public void visit(OWLOntologyAnnotationAxiom oWLOntologyAnnotationAxiom) {
    }

    public void visit(SWRLClassAtom sWRLClassAtom) {
    }

    public void visit(SWRLDataRangeAtom sWRLDataRangeAtom) {
    }

    public void visit(SWRLObjectPropertyAtom sWRLObjectPropertyAtom) {
    }

    public void visit(SWRLDataValuedPropertyAtom sWRLDataValuedPropertyAtom) {
    }

    public void visit(SWRLBuiltInAtom sWRLBuiltInAtom) {
    }

    public void visit(SWRLAtomDVariable sWRLAtomDVariable) {
    }

    public void visit(SWRLAtomIVariable sWRLAtomIVariable) {
    }

    public void visit(SWRLAtomIndividualObject sWRLAtomIndividualObject) {
    }

    public void visit(SWRLAtomConstantObject sWRLAtomConstantObject) {
    }

    public void visit(SWRLDifferentFromAtom sWRLDifferentFromAtom) {
    }

    public void visit(SWRLSameAsAtom sWRLSameAsAtom) {
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            String string;
            Object object2;
            File file = new File(".");
            File file2 = new File(file, "mapping.txt");
            final HashMap<Object, URI> hashMap = new HashMap<Object, URI>();
            if (file2.exists()) {
                object2 = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                while ((string = ((BufferedReader)object2).readLine()) != null) {
                    int n = string.indexOf(" ");
                    object = new URI(string.substring(0, n).trim());
                    URI uRI = new URI(string.substring(n + 1, string.length()).trim());
                    hashMap.put(object, uRI);
                }
            }
            object2 = OWLManager.createOWLOntologyManager();
            object2.addURIMapper(new OWLOntologyURIMapper(){

                public URI getPhysicalURI(URI uRI) {
                    URI uRI2 = (URI)hashMap.get(uRI);
                    if (uRI2 != null) {
                        return uRI2;
                    }
                    return uRI;
                }
            });
            string = object2.loadOntology(URI.create(stringArray[0]));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            object = new FaCTPlusPlusRenderer(bufferedWriter);
            string.accept((OWLObjectVisitor)object);
            ((Writer)bufferedWriter).flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

