/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.logging.Logger;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyStorageException;
import org.semanticweb.owl.model.OWLOntologyStorer;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusOntologyFormat;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusRenderer;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusRendererException;

public class FaCTPlusPlusOWLOntologyStorer
implements OWLOntologyStorer {
    private Logger logger = Logger.getLogger(FaCTPlusPlusOWLOntologyStorer.class.toString());

    public boolean canStoreOntology(OWLOntologyFormat oWLOntologyFormat) {
        return oWLOntologyFormat.equals((Object)new FaCTPlusPlusOntologyFormat());
    }

    public void storeOntology(OWLOntologyManager oWLOntologyManager, OWLOntology oWLOntology, URI uRI, OWLOntologyFormat oWLOntologyFormat) throws OWLOntologyStorageException {
        try {
            this.storeOntology(oWLOntologyManager, oWLOntology, new FileOutputStream(new File(uRI)), oWLOntologyFormat);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OWLOntologyStorageException((Throwable)fileNotFoundException);
        }
    }

    public void storeOntology(OWLOntologyManager oWLOntologyManager, OWLOntology oWLOntology, OWLOntologyOutputTarget oWLOntologyOutputTarget, OWLOntologyFormat oWLOntologyFormat) throws OWLOntologyStorageException {
        this.storeOntology(oWLOntologyManager, oWLOntology, oWLOntologyOutputTarget.getOutputStream(), oWLOntologyFormat);
    }

    private void storeOntology(OWLOntologyManager oWLOntologyManager, OWLOntology oWLOntology, OutputStream outputStream, OWLOntologyFormat oWLOntologyFormat) throws OWLOntologyStorageException {
        try {
            this.logger.info("FaCT++ ignoring ontology format requested. Not supported");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            FaCTPlusPlusRenderer faCTPlusPlusRenderer = new FaCTPlusPlusRenderer(bufferedWriter);
            oWLOntology.accept((OWLObjectVisitor)faCTPlusPlusRenderer);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new FaCTPlusPlusRendererException(iOException);
        }
    }
}

