/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.util.OWLAxiomFilter;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

public class FaCTPlusPlusAxiomFilter
implements OWLAxiomFilter,
OWLAxiomVisitor,
OWLDescriptionVisitor,
OWLEntityVisitor,
OWLDataVisitor {
    private boolean passes = false;
    private boolean passDataStuff = false;
    private Set<URI> supportedDataTypes = new HashSet<URI>();
    private String reason;

    public FaCTPlusPlusAxiomFilter() {
        this.supportedDataTypes.add(XSDVocabulary.INT.getURI());
        this.supportedDataTypes.add(XSDVocabulary.INTEGER.getURI());
        this.supportedDataTypes.add(XSDVocabulary.NON_NEGATIVE_INTEGER.getURI());
        this.supportedDataTypes.add(XSDVocabulary.DOUBLE.getURI());
        this.supportedDataTypes.add(XSDVocabulary.FLOAT.getURI());
        this.supportedDataTypes.add(XSDVocabulary.INTEGER.getURI());
        this.supportedDataTypes.add(XSDVocabulary.STRING.getURI());
        this.supportedDataTypes.add(XSDVocabulary.BOOLEAN.getURI());
        this.supportedDataTypes.add(OWLRDFVocabulary.RDFS_LITERAL.getURI());
    }

    public boolean isSupportedDatatype(URI uRI) {
        return this.supportedDataTypes.contains(uRI);
    }

    public boolean passes(OWLAxiom oWLAxiom) {
        this.reason = "";
        this.passes = true;
        oWLAxiom.accept((OWLAxiomVisitor)this);
        return this.passes;
    }

    public String getReason() {
        return this.reason;
    }

    public void visit(OWLSubClassAxiom oWLSubClassAxiom) {
        oWLSubClassAxiom.getSubClass().accept((OWLDescriptionVisitor)this);
        oWLSubClassAxiom.getSuperClass().accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom oWLAntiSymmetricObjectPropertyAxiom) {
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        if (oWLDisjointClassesAxiom.getDescriptions().size() < 2) {
            this.passes = false;
            this.reason = "Disjoint classes axiom with less than 2 classes detected.";
        } else {
            for (OWLDescription oWLDescription : oWLDisjointClassesAxiom.getDescriptions()) {
                oWLDescription.accept((OWLDescriptionVisitor)this);
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        oWLDataPropertyDomainAxiom.getDomain().accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLImportsDeclaration oWLImportsDeclaration) {
        this.passes = false;
    }

    public void visit(OWLAxiomAnnotationAxiom oWLAxiomAnnotationAxiom) {
        this.passes = false;
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        oWLObjectPropertyDomainAxiom.getDomain().accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        ((OWLConstant)oWLNegativeDataPropertyAssertionAxiom.getObject()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        ((OWLDescription)oWLObjectPropertyRangeAxiom.getRange()).accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
    }

    public void visit(OWLObjectSubPropertyAxiom oWLObjectSubPropertyAxiom) {
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        for (OWLDescription oWLDescription : oWLDisjointUnionAxiom.getDescriptions()) {
            oWLDescription.accept((OWLDescriptionVisitor)this);
        }
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
    }

    public void visit(OWLEntityAnnotationAxiom oWLEntityAnnotationAxiom) {
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        ((OWLDataRange)oWLDataPropertyRangeAxiom.getRange()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        oWLClassAssertionAxiom.getDescription().accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        for (OWLDescription oWLDescription : oWLEquivalentClassesAxiom.getDescriptions()) {
            oWLDescription.accept((OWLDescriptionVisitor)this);
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        ((OWLConstant)oWLDataPropertyAssertionAxiom.getObject()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
    }

    public void visit(OWLDataSubPropertyAxiom oWLDataSubPropertyAxiom) {
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
    }

    public void visit(OWLSameIndividualsAxiom oWLSameIndividualsAxiom) {
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom oWLObjectPropertyChainSubPropertyAxiom) {
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
    }

    public void visit(OWLClass oWLClass) {
    }

    public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
        for (OWLDescription oWLDescription : oWLObjectIntersectionOf.getOperands()) {
            oWLDescription.accept((OWLDescriptionVisitor)this);
        }
    }

    public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
        for (OWLDescription oWLDescription : oWLObjectUnionOf.getOperands()) {
            oWLDescription.accept((OWLDescriptionVisitor)this);
        }
    }

    public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
        oWLObjectComplementOf.getOperand().accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectSomeRestriction oWLObjectSomeRestriction) {
        ((OWLDescription)oWLObjectSomeRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectAllRestriction oWLObjectAllRestriction) {
        ((OWLDescription)oWLObjectAllRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectValueRestriction oWLObjectValueRestriction) {
    }

    public void visit(OWLObjectMinCardinalityRestriction oWLObjectMinCardinalityRestriction) {
        ((OWLDescription)oWLObjectMinCardinalityRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectExactCardinalityRestriction oWLObjectExactCardinalityRestriction) {
        ((OWLDescription)oWLObjectExactCardinalityRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectMaxCardinalityRestriction oWLObjectMaxCardinalityRestriction) {
        ((OWLDescription)oWLObjectMaxCardinalityRestriction.getFiller()).accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectSelfRestriction oWLObjectSelfRestriction) {
    }

    public void visit(OWLObjectOneOf oWLObjectOneOf) {
    }

    public void visit(OWLDataSomeRestriction oWLDataSomeRestriction) {
        ((OWLDataRange)oWLDataSomeRestriction.getFiller()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLDataAllRestriction oWLDataAllRestriction) {
        ((OWLDataRange)oWLDataAllRestriction.getFiller()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLDataValueRestriction oWLDataValueRestriction) {
        ((OWLConstant)oWLDataValueRestriction.getValue()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLDataMinCardinalityRestriction oWLDataMinCardinalityRestriction) {
        ((OWLDataRange)oWLDataMinCardinalityRestriction.getFiller()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLDataExactCardinalityRestriction oWLDataExactCardinalityRestriction) {
        ((OWLDataRange)oWLDataExactCardinalityRestriction.getFiller()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLDataMaxCardinalityRestriction oWLDataMaxCardinalityRestriction) {
        ((OWLDataRange)oWLDataMaxCardinalityRestriction.getFiller()).accept((OWLDataVisitor)this);
    }

    public void visit(OWLObjectProperty oWLObjectProperty) {
    }

    public void visit(OWLDataProperty oWLDataProperty) {
    }

    public void visit(OWLIndividual oWLIndividual) {
    }

    public void visit(OWLDataType oWLDataType) {
        this.passes = this.isSupportedDatatype(oWLDataType.getURI());
        if (!this.passes) {
            this.reason = oWLDataType.getURI() + " is not supported";
        }
    }

    public void visit(SWRLRule sWRLRule) {
    }

    public void visit(OWLOntologyAnnotationAxiom oWLOntologyAnnotationAxiom) {
        this.passes = false;
    }

    public void visit(OWLDataComplementOf oWLDataComplementOf) {
        oWLDataComplementOf.getDataRange().accept((OWLDataVisitor)this);
    }

    public void visit(OWLDataOneOf oWLDataOneOf) {
        for (OWLConstant oWLConstant : oWLDataOneOf.getValues()) {
            oWLConstant.accept((OWLDataVisitor)this);
        }
    }

    public void visit(OWLDataRangeRestriction oWLDataRangeRestriction) {
        oWLDataRangeRestriction.getDataRange().accept((OWLDataVisitor)this);
    }

    public void visit(OWLTypedConstant oWLTypedConstant) {
        oWLTypedConstant.getDataType().accept((OWLDataVisitor)this);
    }

    public void visit(OWLUntypedConstant oWLUntypedConstant) {
    }

    public void visit(OWLDataRangeFacetRestriction oWLDataRangeFacetRestriction) {
    }
}

