/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataVisitor;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.SWRLRule;
import uk.ac.manchester.cs.factplusplus.AxiomPointer;
import uk.ac.manchester.cs.factplusplus.ClassPointer;
import uk.ac.manchester.cs.factplusplus.DataPropertyPointer;
import uk.ac.manchester.cs.factplusplus.DataValuePointer;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlus;
import uk.ac.manchester.cs.factplusplus.IndividualPointer;
import uk.ac.manchester.cs.factplusplus.ObjectPropertyPointer;
import uk.ac.manchester.cs.factplusplus.owlapi.FaCTPlusPlusRuntimeException;
import uk.ac.manchester.cs.factplusplus.owlapi.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomLoader
implements OWLAxiomVisitor {
    private static final Logger logger = Logger.getLogger(AxiomLoader.class.getName());
    private FaCTPlusPlus faCTPlusPlus;
    private Translator translator;
    private AxiomPointer lastAxiom;
    private OWLDataFactory df;
    private OWLEntityVisitor declarationVisitor = new OWLEntityVisitor(){

        public void visit(OWLClass oWLClass) {
            try {
                ClassPointer classPointer = AxiomLoader.this.translator.translate((OWLDescription)oWLClass);
                AxiomLoader.this.lastAxiom = AxiomLoader.this.faCTPlusPlus.tellClassDeclaration(classPointer);
            }
            catch (Exception exception) {
                throw new FaCTPlusPlusRuntimeException(exception);
            }
        }

        public void visit(OWLObjectProperty oWLObjectProperty) {
            try {
                ObjectPropertyPointer objectPropertyPointer = AxiomLoader.this.translator.translate((OWLObjectPropertyExpression)oWLObjectProperty);
                AxiomLoader.this.lastAxiom = AxiomLoader.this.faCTPlusPlus.tellObjectPropertyDeclaration(objectPropertyPointer);
            }
            catch (Exception exception) {
                throw new FaCTPlusPlusRuntimeException(exception);
            }
        }

        public void visit(OWLDataProperty oWLDataProperty) {
            try {
                DataPropertyPointer dataPropertyPointer = AxiomLoader.this.translator.translate((OWLDataPropertyExpression)oWLDataProperty);
                AxiomLoader.this.lastAxiom = AxiomLoader.this.faCTPlusPlus.tellDataPropertyDeclaration(dataPropertyPointer);
            }
            catch (Exception exception) {
                throw new FaCTPlusPlusRuntimeException(exception);
            }
        }

        public void visit(OWLIndividual oWLIndividual) {
            try {
                IndividualPointer individualPointer = AxiomLoader.this.translator.translate(oWLIndividual);
                AxiomLoader.this.lastAxiom = AxiomLoader.this.faCTPlusPlus.tellIndividualDeclaration(individualPointer);
            }
            catch (Exception exception) {
                throw new FaCTPlusPlusRuntimeException(exception);
            }
        }

        public void visit(OWLDataType oWLDataType) {
        }
    };

    public AxiomLoader(Translator translator) {
        this.translator = translator;
        this.faCTPlusPlus = translator.getFaCTPlusPlus();
        this.df = translator.getOWLOntologyManager().getOWLDataFactory();
    }

    public AxiomPointer load(OWLAxiom oWLAxiom) {
        this.lastAxiom = null;
        oWLAxiom.accept((OWLAxiomVisitor)this);
        return this.lastAxiom;
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        try {
            this.translateDescriptionArgList(oWLDisjointClassesAxiom.getDescriptions());
            this.lastAxiom = this.faCTPlusPlus.tellDisjointClasses();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        try {
            this.translateDescriptionArgList(oWLEquivalentClassesAxiom.getDescriptions());
            this.lastAxiom = this.faCTPlusPlus.tellEquivalentClass();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLSubClassAxiom oWLSubClassAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellSubClassOf(this.translate(oWLSubClassAxiom.getSubClass()), this.translate(oWLSubClassAxiom.getSuperClass()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        try {
            ((OWLDataPropertyExpression)oWLDataPropertyRangeAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            DataPropertyPointer dataPropertyPointer = this.translator.getLastDataPropertyPointer();
            ((OWLDataRange)oWLDataPropertyRangeAxiom.getRange()).accept((OWLDataVisitor)this.translator);
            this.lastAxiom = this.faCTPlusPlus.tellDataPropertyRange(dataPropertyPointer, this.translator.getLastDataTypeExpressionPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        try {
            this.translateObjectPropertyArgList(oWLEquivalentObjectPropertiesAxiom.getProperties());
            this.lastAxiom = this.faCTPlusPlus.tellEquivalentObjectProperties();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        try {
            this.translateDataPropertyArgList(oWLEquivalentDataPropertiesAxiom.getProperties());
            this.lastAxiom = this.faCTPlusPlus.tellEquivalentDataProperties();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        try {
            ((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            this.lastAxiom = this.faCTPlusPlus.tellFunctionalObjectProperty(this.translator.getLastObjectPropertyPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellInverseFunctionalObjectProperty(this.translate((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellObjectPropertyRange(this.translate((OWLObjectPropertyExpression)oWLObjectPropertyRangeAxiom.getProperty()), this.translate((OWLDescription)oWLObjectPropertyRangeAxiom.getRange()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellObjectPropertyDomain(this.translate((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty()), this.translate(oWLObjectPropertyDomainAxiom.getDomain()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectSubPropertyAxiom oWLObjectSubPropertyAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellSubObjectProperties(this.translate((OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSubProperty()), this.translate((OWLObjectPropertyExpression)oWLObjectSubPropertyAxiom.getSuperProperty()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellSymmetricObjectProperty(this.translate((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellTransitiveObjectProperty(this.translate((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellInverseProperties(this.translate(oWLInverseObjectPropertiesAxiom.getFirstProperty()), this.translate(oWLInverseObjectPropertiesAxiom.getSecondProperty()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        try {
            this.translateIndividualArgList(oWLDifferentIndividualsAxiom.getIndividuals());
            this.lastAxiom = this.faCTPlusPlus.tellDifferentIndividuals();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLSameIndividualsAxiom oWLSameIndividualsAxiom) {
        try {
            this.translateIndividualArgList(oWLSameIndividualsAxiom.getIndividuals());
            this.lastAxiom = this.faCTPlusPlus.tellSameIndividuals();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    private void translateDescriptionArgList(Set<OWLDescription> set) {
        try {
            HashSet<ClassPointer> hashSet = new HashSet<ClassPointer>();
            for (OWLDescription object : set) {
                hashSet.add(this.translate(object));
            }
            this.faCTPlusPlus.initArgList();
            for (ClassPointer classPointer : hashSet) {
                this.faCTPlusPlus.addArg(classPointer);
            }
            this.faCTPlusPlus.closeArgList();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    private void translateIndividualArgList(Set<? extends OWLIndividual> set) {
        try {
            this.faCTPlusPlus.initArgList();
            for (OWLIndividual oWLIndividual : set) {
                this.faCTPlusPlus.addArg(this.translate(oWLIndividual));
            }
            this.faCTPlusPlus.closeArgList();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    private void translateObjectPropertyArgList(Set<? extends OWLObjectPropertyExpression> set) throws OWLException {
        try {
            this.faCTPlusPlus.initArgList();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : set) {
                this.faCTPlusPlus.addArg(this.translate(oWLObjectPropertyExpression));
            }
            this.faCTPlusPlus.closeArgList();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    private void translateDataPropertyArgList(Set<? extends OWLDataPropertyExpression> set) throws OWLException {
        try {
            this.faCTPlusPlus.initArgList();
            for (OWLDataPropertyExpression oWLDataPropertyExpression : set) {
                this.faCTPlusPlus.addArg(this.translate(oWLDataPropertyExpression));
            }
            this.faCTPlusPlus.closeArgList();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    private ClassPointer translate(OWLDescription oWLDescription) {
        oWLDescription.accept((OWLDescriptionVisitor)this.translator);
        return this.translator.getLastClassPointer();
    }

    private DataPropertyPointer translate(OWLDataPropertyExpression oWLDataPropertyExpression) {
        oWLDataPropertyExpression.accept((OWLPropertyExpressionVisitor)this.translator);
        return this.translator.getLastDataPropertyPointer();
    }

    private ObjectPropertyPointer translate(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        oWLObjectPropertyExpression.accept((OWLPropertyExpressionVisitor)this.translator);
        return this.translator.getLastObjectPropertyPointer();
    }

    private IndividualPointer translate(OWLIndividual oWLIndividual) {
        oWLIndividual.accept((OWLEntityVisitor)this.translator);
        return this.translator.getLastIndividualPointer();
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        try {
            HashSet<ClassPointer> hashSet = new HashSet<ClassPointer>();
            for (OWLDescription object2 : oWLDisjointUnionAxiom.getDescriptions()) {
                object2.accept((OWLDescriptionVisitor)this.translator);
                hashSet.add(this.translator.getLastClassPointer());
            }
            this.faCTPlusPlus.initArgList();
            for (ClassPointer classPointer : hashSet) {
                this.faCTPlusPlus.addArg(classPointer);
            }
            this.faCTPlusPlus.closeArgList();
            this.lastAxiom = this.faCTPlusPlus.tellDisjointClasses();
            hashSet.clear();
            for (OWLDescription oWLDescription : oWLDisjointUnionAxiom.getDescriptions()) {
                oWLDescription.accept((OWLDescriptionVisitor)this.translator);
                hashSet.add(this.translator.getLastClassPointer());
            }
            this.faCTPlusPlus.initArgList();
            for (ClassPointer classPointer : hashSet) {
                this.faCTPlusPlus.addArg(classPointer);
            }
            this.faCTPlusPlus.closeArgList();
            ClassPointer classPointer = this.faCTPlusPlus.getConceptOr();
            ClassPointer classPointer2 = this.translate((OWLDescription)oWLDisjointUnionAxiom.getOWLClass());
            this.faCTPlusPlus.initArgList();
            this.faCTPlusPlus.addArg(classPointer2);
            this.faCTPlusPlus.addArg(classPointer);
            this.faCTPlusPlus.closeArgList();
            this.lastAxiom = this.faCTPlusPlus.tellEquivalentClass();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        try {
            HashSet<ObjectPropertyPointer> hashSet = new HashSet<ObjectPropertyPointer>();
            for (OWLObjectPropertyExpression object : oWLDisjointObjectPropertiesAxiom.getProperties()) {
                object.accept((OWLPropertyExpressionVisitor)this.translator);
                hashSet.add(this.translator.getLastObjectPropertyPointer());
            }
            this.faCTPlusPlus.initArgList();
            for (ObjectPropertyPointer objectPropertyPointer : hashSet) {
                this.faCTPlusPlus.addArg(objectPropertyPointer);
            }
            this.faCTPlusPlus.closeArgList();
            this.lastAxiom = this.faCTPlusPlus.tellDisjointObjectProperties();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        try {
            HashSet<DataPropertyPointer> hashSet = new HashSet<DataPropertyPointer>();
            for (OWLDataPropertyExpression object : oWLDisjointDataPropertiesAxiom.getProperties()) {
                object.accept((OWLPropertyExpressionVisitor)this.translator);
                hashSet.add(this.translator.getLastDataPropertyPointer());
            }
            this.faCTPlusPlus.initArgList();
            for (DataPropertyPointer dataPropertyPointer : hashSet) {
                this.faCTPlusPlus.addArg(dataPropertyPointer);
            }
            this.faCTPlusPlus.closeArgList();
            this.lastAxiom = this.faCTPlusPlus.tellDisjointDataProperties();
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom oWLObjectPropertyChainSubPropertyAxiom) {
        try {
            ArrayList<ObjectPropertyPointer> arrayList = new ArrayList<ObjectPropertyPointer>();
            for (OWLObjectPropertyExpression object2 : oWLObjectPropertyChainSubPropertyAxiom.getPropertyChain()) {
                arrayList.add(this.translate(object2));
            }
            this.faCTPlusPlus.initArgList();
            for (ObjectPropertyPointer objectPropertyPointer : arrayList) {
                this.faCTPlusPlus.addArg(objectPropertyPointer);
            }
            this.faCTPlusPlus.closeArgList();
            ObjectPropertyPointer objectPropertyPointer = this.faCTPlusPlus.getPropertyComposition();
            ObjectPropertyPointer objectPropertyPointer2 = this.translate(oWLObjectPropertyChainSubPropertyAxiom.getSuperProperty());
            this.lastAxiom = this.faCTPlusPlus.tellSubObjectProperties(objectPropertyPointer, objectPropertyPointer2);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        try {
            ((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            this.lastAxiom = this.faCTPlusPlus.tellReflexiveObjectProperty(this.translator.getLastObjectPropertyPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        try {
            ((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            this.lastAxiom = this.faCTPlusPlus.tellIrreflexiveObjectProperty(this.translator.getLastObjectPropertyPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom oWLAntiSymmetricObjectPropertyAxiom) {
        try {
            ((OWLObjectPropertyExpression)oWLAntiSymmetricObjectPropertyAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            this.lastAxiom = this.faCTPlusPlus.tellAntiSymmetricObjectProperty(this.translator.getLastObjectPropertyPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        try {
            oWLNegativeObjectPropertyAssertionAxiom.getSubject().accept((OWLEntityVisitor)this.translator);
            IndividualPointer individualPointer = this.translator.getLastIndividualPointer();
            ((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            ObjectPropertyPointer objectPropertyPointer = this.translator.getLastObjectPropertyPointer();
            ((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject()).accept((OWLEntityVisitor)this.translator);
            IndividualPointer individualPointer2 = this.translator.getLastIndividualPointer();
            this.lastAxiom = this.faCTPlusPlus.tellNotRelatedIndividuals(individualPointer, objectPropertyPointer, individualPointer2);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        try {
            IndividualPointer individualPointer = this.translator.translate(oWLNegativeDataPropertyAssertionAxiom.getSubject());
            DataPropertyPointer dataPropertyPointer = this.translator.translate((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty());
            DataValuePointer dataValuePointer = this.translator.translate((OWLConstant)oWLNegativeDataPropertyAssertionAxiom.getObject());
            this.lastAxiom = this.faCTPlusPlus.tellNotRelatedIndividualValue(individualPointer, dataPropertyPointer, dataValuePointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        try {
            ((OWLDataPropertyExpression)oWLDataPropertyDomainAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            DataPropertyPointer dataPropertyPointer = this.translator.getLastDataPropertyPointer();
            oWLDataPropertyDomainAxiom.getDomain().accept((OWLDescriptionVisitor)this.translator);
            this.lastAxiom = this.faCTPlusPlus.tellDataPropertyDomain(dataPropertyPointer, this.translator.getLastClassPointer());
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        try {
            IndividualPointer individualPointer = this.translator.translate(oWLObjectPropertyAssertionAxiom.getSubject());
            ((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            ObjectPropertyPointer objectPropertyPointer = this.translator.getLastObjectPropertyPointer();
            IndividualPointer individualPointer2 = this.translator.translate((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject());
            this.lastAxiom = this.faCTPlusPlus.tellRelatedIndividuals(individualPointer, objectPropertyPointer, individualPointer2);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        try {
            this.lastAxiom = this.faCTPlusPlus.tellFunctionalDataProperty(this.translate((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()));
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        try {
            IndividualPointer individualPointer = this.translator.translate(oWLClassAssertionAxiom.getIndividual());
            ClassPointer classPointer = this.translator.translate(oWLClassAssertionAxiom.getDescription());
            this.lastAxiom = this.faCTPlusPlus.tellIndividualType(individualPointer, classPointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        try {
            IndividualPointer individualPointer = this.translator.translate(oWLDataPropertyAssertionAxiom.getSubject());
            ((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).accept((OWLPropertyExpressionVisitor)this.translator);
            DataPropertyPointer dataPropertyPointer = this.translator.getLastDataPropertyPointer();
            DataValuePointer dataValuePointer = this.translator.translate((OWLConstant)oWLDataPropertyAssertionAxiom.getObject());
            this.lastAxiom = this.faCTPlusPlus.tellRelatedIndividualValue(individualPointer, dataPropertyPointer, dataValuePointer);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLDataSubPropertyAxiom oWLDataSubPropertyAxiom) {
        try {
            DataPropertyPointer dataPropertyPointer = this.translator.translate((OWLDataPropertyExpression)oWLDataSubPropertyAxiom.getSubProperty());
            DataPropertyPointer dataPropertyPointer2 = this.translator.translate((OWLDataPropertyExpression)oWLDataSubPropertyAxiom.getSuperProperty());
            this.lastAxiom = this.faCTPlusPlus.tellSubDataProperties(dataPropertyPointer, dataPropertyPointer2);
        }
        catch (Exception exception) {
            throw new FaCTPlusPlusRuntimeException(exception);
        }
    }

    public void visit(OWLImportsDeclaration oWLImportsDeclaration) {
    }

    public void visit(OWLAxiomAnnotationAxiom oWLAxiomAnnotationAxiom) {
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        oWLDeclarationAxiom.getEntity().accept(this.declarationVisitor);
    }

    public void visit(OWLEntityAnnotationAxiom oWLEntityAnnotationAxiom) {
        OWLDeclarationAxiom oWLDeclarationAxiom = this.df.getOWLDeclarationAxiom((OWLEntity)oWLEntityAnnotationAxiom.getSubject());
        oWLDeclarationAxiom.accept((OWLAxiomVisitor)this);
    }

    public void visit(SWRLRule sWRLRule) {
    }

    public void visit(OWLOntologyAnnotationAxiom oWLOntologyAnnotationAxiom) {
    }
}

