/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.bing.search.client.impl;

import com.google.code.bing.search.client.BingSearchClient;
import com.google.code.bing.search.client.BingSearchException;
import com.google.code.bing.search.client.constant.ApplicationConstants;
import com.google.code.bing.search.client.constant.BingSearchApiUrls;
import com.google.code.bing.search.client.impl.BaseBingSearchApiClient;
import com.google.code.bing.search.schema.AdultOption;
import com.google.code.bing.search.schema.Error;
import com.google.code.bing.search.schema.Query;
import com.google.code.bing.search.schema.SearchOption;
import com.google.code.bing.search.schema.SearchRequest;
import com.google.code.bing.search.schema.SearchResponse;
import com.google.code.bing.search.schema.SourceType;
import com.google.code.bing.search.schema.instantanswer.InstantAnswerResponse;
import com.google.code.bing.search.schema.instantanswer.InstantAnswerResult;
import com.google.code.bing.search.schema.mobileweb.MobileWebRequest;
import com.google.code.bing.search.schema.mobileweb.MobileWebResponse;
import com.google.code.bing.search.schema.mobileweb.MobileWebResult;
import com.google.code.bing.search.schema.mobileweb.MobileWebSearchOption;
import com.google.code.bing.search.schema.multimedia.ImageRequest;
import com.google.code.bing.search.schema.multimedia.ImageResponse;
import com.google.code.bing.search.schema.multimedia.ImageResult;
import com.google.code.bing.search.schema.multimedia.Thumbnail;
import com.google.code.bing.search.schema.multimedia.VideoRequest;
import com.google.code.bing.search.schema.multimedia.VideoResponse;
import com.google.code.bing.search.schema.multimedia.VideoResult;
import com.google.code.bing.search.schema.multimedia.VideoSortOption;
import com.google.code.bing.search.schema.news.NewsArticle;
import com.google.code.bing.search.schema.news.NewsCollection;
import com.google.code.bing.search.schema.news.NewsRelatedSearch;
import com.google.code.bing.search.schema.news.NewsRequest;
import com.google.code.bing.search.schema.news.NewsResponse;
import com.google.code.bing.search.schema.news.NewsResult;
import com.google.code.bing.search.schema.news.NewsSortOption;
import com.google.code.bing.search.schema.phonebook.PhonebookRequest;
import com.google.code.bing.search.schema.phonebook.PhonebookResponse;
import com.google.code.bing.search.schema.phonebook.PhonebookResult;
import com.google.code.bing.search.schema.phonebook.PhonebookSortOption;
import com.google.code.bing.search.schema.relatedsearch.RelatedSearchResponse;
import com.google.code.bing.search.schema.relatedsearch.RelatedSearchResult;
import com.google.code.bing.search.schema.spell.SpellResponse;
import com.google.code.bing.search.schema.spell.SpellResult;
import com.google.code.bing.search.schema.translation.TranslationRequest;
import com.google.code.bing.search.schema.translation.TranslationResponse;
import com.google.code.bing.search.schema.translation.TranslationResult;
import com.google.code.bing.search.schema.web.DeepLink;
import com.google.code.bing.search.schema.web.WebRequest;
import com.google.code.bing.search.schema.web.WebResponse;
import com.google.code.bing.search.schema.web.WebResult;
import com.google.code.bing.search.schema.web.WebSearchOption;
import com.google.code.bing.search.schema.web.WebSearchTag;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class BingSearchJsonClientImpl
extends BaseBingSearchApiClient {
    private static final JsonElementFactory OBJECT_FACTORY = new JsonElementFactory();
    protected static final Charset UTF_8_CHAR_SET = Charset.forName(ApplicationConstants.CONTENT_ENCODING);
    private final JsonParser parser = new JsonParser();

    @Override
    protected <T> T unmarshallObject(Class<T> clazz, InputStream jsonContent) {
        try {
            JsonElement response = this.parser.parse((Reader)new InputStreamReader(jsonContent, UTF_8_CHAR_SET));
            if (response.isJsonObject() && response.getAsJsonObject().get("SearchResponse") != null) {
                Gson gson = this.getGsonBuilder().create();
                return (T)gson.fromJson(response.getAsJsonObject().get("SearchResponse"), clazz);
            }
            throw new BingSearchException("Unknown content found in response:" + response.toString());
        }
        catch (Exception e) {
            throw new BingSearchException(e);
        }
    }

    @Override
    protected String marshallObject(Object element) {
        try {
            StringWriter writer = new StringWriter();
            return writer.toString();
        }
        catch (Exception e) {
            throw new BingSearchException(e);
        }
    }

    @Override
    protected BingSearchApiUrls.BingSearchApiUrlBuilder createBingSearchApiUrlBuilder(String urlFormat) {
        return new BingSearchApiUrls.BingSearchApiUrlBuilder(urlFormat);
    }

    @Override
    public BingSearchClient.SearchRequestBuilder newSearchRequestBuilder() {
        return new SearchRequestBuilderImpl(OBJECT_FACTORY);
    }

    @Override
    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public void setTaskExecutor(ExecutorService taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat(ApplicationConstants.DATE_FORMAT);
        builder.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
        return builder;
    }

    protected JsonObject unmarshall(InputStream jsonContent) {
        try {
            JsonElement element = this.parser.parse((Reader)new InputStreamReader(jsonContent, UTF_8_CHAR_SET));
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                return jsonObject;
            }
            try {
                throw new BingSearchException("Unknown content found in response." + element);
            }
            catch (Exception e) {
                throw new BingSearchException(e);
            }
        }
        finally {
            this.closeStream(jsonContent);
        }
    }

    private static class JsonElementFactory {
        public DeepLink createDeepLink() {
            return new DeepLink();
        }

        public Error createError() {
            return new Error();
        }

        public ImageRequest createImageRequest() {
            return new ImageRequest();
        }

        public ImageResponse createImageResponse() {
            return new ImageResponse();
        }

        public ImageResult createImageResult() {
            return new ImageResult();
        }

        public InstantAnswerResponse createInstantAnswerResponse() {
            return new InstantAnswerResponse();
        }

        public InstantAnswerResult createInstantAnswerResult() {
            return new InstantAnswerResult();
        }

        public MobileWebRequest createMobileWebRequest() {
            return new MobileWebRequest();
        }

        public MobileWebResponse createMobileWebResponse() {
            return new MobileWebResponse();
        }

        public MobileWebResult createMobileWebResult() {
            return new MobileWebResult();
        }

        public NewsArticle createNewsArticle() {
            return new NewsArticle();
        }

        public NewsCollection createNewsCollection() {
            return new NewsCollection();
        }

        public NewsRelatedSearch createNewsRelatedSearch() {
            return new NewsRelatedSearch();
        }

        public NewsRequest createNewsRequest() {
            return new NewsRequest();
        }

        public NewsResponse createNewsResponse() {
            return new NewsResponse();
        }

        public NewsResult createNewsResult() {
            return new NewsResult();
        }

        public PhonebookRequest createPhonebookRequest() {
            return new PhonebookRequest();
        }

        public PhonebookResponse createPhonebookResponse() {
            return new PhonebookResponse();
        }

        public PhonebookResult createPhonebookResult() {
            return new PhonebookResult();
        }

        public Query createQuery() {
            return new Query();
        }

        public RelatedSearchResponse createRelatedSearchResponse() {
            return new RelatedSearchResponse();
        }

        public RelatedSearchResult createRelatedSearchResult() {
            return new RelatedSearchResult();
        }

        public SearchRequest createSearchRequest() {
            return new SearchRequest();
        }

        public SearchResponse createSearchResponse() {
            return new SearchResponse();
        }

        public SpellResponse createSpellResponse() {
            return new SpellResponse();
        }

        public SpellResult createSpellResult() {
            return new SpellResult();
        }

        public Thumbnail createThumbnail() {
            return new Thumbnail();
        }

        public TranslationRequest createTranslationRequest() {
            return new TranslationRequest();
        }

        public TranslationResponse createTranslationResponse() {
            return new TranslationResponse();
        }

        public TranslationResult createTranslationResult() {
            return new TranslationResult();
        }

        public VideoRequest createVideoRequest() {
            return new VideoRequest();
        }

        public VideoResponse createVideoResponse() {
            return new VideoResponse();
        }

        public VideoResult createVideoResult() {
            return new VideoResult();
        }

        public WebRequest createWebRequest() {
            return new WebRequest();
        }

        public WebResponse createWebResponse() {
            return new WebResponse();
        }

        public WebResult createWebResult() {
            return new WebResult();
        }

        public WebSearchTag createWebSearchTag() {
            return new WebSearchTag();
        }
    }

    public static class SearchRequestBuilderImpl
    implements BingSearchClient.SearchRequestBuilder {
        protected SearchRequest result;
        protected JsonElementFactory factory;

        protected SearchRequestBuilderImpl(JsonElementFactory factory) {
            this.factory = factory;
            this.result = factory.createSearchRequest();
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withAppId(String applicationId) {
            this.getParameters().setAppId(applicationId);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withAdultOption(AdultOption adult) {
            this.getParameters().setAdult(adult);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withImageRequestCount(Long count) {
            this.getImageRequest().setCount(count);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withImageRequestFilter(String filter) {
            this.getImageRequestFilters().add(filter);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withImageRequestOffset(Long offset) {
            this.getImageRequest().setOffset(offset);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withLatitude(Double latitude) {
            this.getParameters().setLatitude(latitude);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withLongitude(Double longitude) {
            this.getParameters().setLongitude(longitude);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withMarket(String market) {
            this.getParameters().setMarket(market);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withMobileWebRequestCount(Long count) {
            this.getMobileWebRequest().setCount(count);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withMobileWebRequestOffset(Long offset) {
            this.getMobileWebRequest().setOffset(offset);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withMobileWebRequestSearchOption(MobileWebSearchOption mobileWebSearchOption) {
            this.getMobileWebRequestOptions().add(mobileWebSearchOption);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withNewsRequestCategory(String category) {
            this.getNewsRequest().setCategory(category);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withNewsRequestCount(Long count) {
            this.getNewsRequest().setCount(count);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withNewsRequestLocationOverride(String locationOverride) {
            this.getNewsRequest().setLocationOverride(locationOverride);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withNewsRequestOffset(Long offset) {
            this.getNewsRequest().setOffset(offset);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withNewsRequestSortOption(NewsSortOption newsSortOption) {
            this.getNewsRequest().setSortBy(newsSortOption);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withPhonebookRequestCategory(String category) {
            this.getPhonebookRequest().setCategory(category);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withPhonebookRequestCount(Long count) {
            this.getPhonebookRequest().setCount(count);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withPhonebookRequestFileType(String fileType) {
            this.getPhonebookRequest().setFileType(fileType);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withPhonebookRequestLocId(String locId) {
            this.getPhonebookRequest().setLocId(locId);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withPhonebookRequestOffset(Long offset) {
            this.getPhonebookRequest().setOffset(offset);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withPhonebookRequestSortOption(PhonebookSortOption phonebookSortOption) {
            this.getPhonebookRequest().setSortBy(phonebookSortOption);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withQuery(String query) {
            this.getParameters().setQuery(query);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withRadius(Double radius) {
            this.getParameters().setRadius(radius);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withSearchOption(SearchOption searchOption) {
            this.getParameterOptions().add(searchOption);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withSourceType(SourceType sourceType) {
            this.getParameterSources().add(sourceType);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withTranslationRequestSourceLanguage(String sourceLanguage) {
            this.getTranslationRequest().setSourceLanguage(sourceLanguage);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withTranslationRequestTargetLanguage(String targetLanguage) {
            this.getTranslationRequest().setTargetLanguage(targetLanguage);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withUILanguage(String uiLanguage) {
            this.getParameters().setUILanguage(uiLanguage);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withVersion(String version) {
            this.getParameters().setVersion(version);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withVideoRequestCount(Long count) {
            this.getVideoRequest().setCount(count);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withVideoRequestFilter(String filter) {
            this.getVideoRequestFilters().add(filter);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withVideoRequestOffset(Long offset) {
            this.getVideoRequest().setOffset(offset);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withVideoRequestSortOption(VideoSortOption videoSortOption) {
            this.getVideoRequest().setSortBy(videoSortOption);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withWebRequestCount(Long count) {
            this.getWebRequest().setCount(count);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withWebRequestFileType(String fileType) {
            this.getWebRequest().setFileType(fileType);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withWebRequestOffset(Long offset) {
            this.getWebRequest().setOffset(offset);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withWebRequestSearchOption(WebSearchOption webSearchOption) {
            this.getWebRequestOptions().add(webSearchOption);
            return this;
        }

        @Override
        public BingSearchClient.SearchRequestBuilder withWebRequestSearchTag(String searchTag) {
            this.getWebRequestSearchTags().add(searchTag);
            return this;
        }

        @Override
        public SearchRequest getResult() {
            return this.result;
        }

        @Override
        public void reset() {
            this.result = this.factory.createSearchRequest();
        }

        private SearchRequest getParameters() {
            return this.result;
        }

        private ImageRequest getImageRequest() {
            if (this.getParameters().getImageRequest() == null) {
                this.getParameters().setImageRequest(this.factory.createImageRequest());
            }
            return this.getParameters().getImageRequest();
        }

        private MobileWebRequest getMobileWebRequest() {
            if (this.getParameters().getMobileWebRequest() == null) {
                this.getParameters().setMobileWebRequest(this.factory.createMobileWebRequest());
            }
            return this.getParameters().getMobileWebRequest();
        }

        private NewsRequest getNewsRequest() {
            if (this.getParameters().getNewsRequest() == null) {
                this.getParameters().setNewsRequest(this.factory.createNewsRequest());
            }
            return this.getParameters().getNewsRequest();
        }

        private PhonebookRequest getPhonebookRequest() {
            if (this.getParameters().getPhonebookRequest() == null) {
                this.getParameters().setPhonebookRequest(this.factory.createPhonebookRequest());
            }
            return this.getParameters().getPhonebookRequest();
        }

        private TranslationRequest getTranslationRequest() {
            if (this.getParameters().getTranslationRequest() == null) {
                this.getParameters().setTranslationRequest(this.factory.createTranslationRequest());
            }
            return this.getParameters().getTranslationRequest();
        }

        private VideoRequest getVideoRequest() {
            if (this.getParameters().getVideoRequest() == null) {
                this.getParameters().setVideoRequest(this.factory.createVideoRequest());
            }
            return this.getParameters().getVideoRequest();
        }

        private WebRequest getWebRequest() {
            if (this.getParameters().getWebRequest() == null) {
                this.getParameters().setWebRequest(this.factory.createWebRequest());
            }
            return this.getParameters().getWebRequest();
        }

        private List<String> getImageRequestFilters() {
            return this.getImageRequest().getFilterList();
        }

        private List<MobileWebSearchOption> getMobileWebRequestOptions() {
            return this.getMobileWebRequest().getMobileWebSearchOptionList();
        }

        private List<SearchOption> getParameterOptions() {
            return this.getParameters().getSearchOptionList();
        }

        private List<SourceType> getParameterSources() {
            return this.getParameters().getSourceTypeList();
        }

        private List<String> getVideoRequestFilters() {
            return this.getVideoRequest().getFilterList();
        }

        private List<WebSearchOption> getWebRequestOptions() {
            return this.getWebRequest().getWebSearchOptionList();
        }

        private List<String> getWebRequestSearchTags() {
            return this.getWebRequest().getSearchTagList();
        }
    }
}

