/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.bing.search.client.impl;

import com.google.code.bing.search.client.BingSearchClient;
import com.google.code.bing.search.client.BingSearchException;
import com.google.code.bing.search.client.constant.BingSearchApiUrls;
import com.google.code.bing.search.schema.SearchRequest;
import com.google.code.bing.search.schema.SearchResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public abstract class BaseBingSearchApiClient
implements BingSearchClient {
    private static final String GZIP_ENCODING = "gzip";
    protected final Logger LOG = Logger.getLogger(this.getClass().getCanonicalName());
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    protected ExecutorService taskExecutor;

    protected BaseBingSearchApiClient() {
        this.requestHeaders.put("Accept-Encoding", "gzip, deflate");
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.put(headerName, headerValue);
    }

    public void removeRequestHeader(String headerName) {
        this.requestHeaders.remove(headerName);
    }

    protected Future execute(Runnable task) {
        return this.taskExecutor.submit(task);
    }

    protected <T> Future<T> execute(Callable<T> task) {
        return this.taskExecutor.submit(task);
    }

    @Override
    public SearchResponse search(SearchRequest request) {
        this.assertNotNull("search request", request);
        BingSearchApiUrls.BingSearchApiUrlBuilder builder = this.createBingSearchApiUrlBuilder(BingSearchApiUrls.BASE_URL);
        String apiUrl = builder.withSearchRequest(request).buildUrl();
        return this.readResponse(SearchResponse.class, this.callApiMethod(apiUrl));
    }

    @Override
    public Future<SearchResponse> searchAsync(final SearchRequest request) {
        return this.execute(new Callable<SearchResponse>(){

            @Override
            public SearchResponse call() throws Exception {
                return BaseBingSearchApiClient.this.search(request);
            }
        });
    }

    protected <T> T readResponse(Class<T> clazz, InputStream is) {
        try {
            T t = this.unmarshallObject(clazz, is);
            return t;
        }
        finally {
            this.closeStream(is);
        }
    }

    protected InputStream callApiMethod(String apiUrl) {
        return this.callApiMethod(apiUrl, 200);
    }

    protected InputStream callApiMethod(String apiUrl, int expected) {
        try {
            URL url = new URL(apiUrl);
            HttpURLConnection request = (HttpURLConnection)url.openConnection();
            for (String headerName : this.requestHeaders.keySet()) {
                request.setRequestProperty(headerName, this.requestHeaders.get(headerName));
            }
            request.connect();
            if (request.getResponseCode() != expected) {
                Error error = this.readResponse(Error.class, this.getWrappedInputStream(request.getErrorStream(), GZIP_ENCODING.equalsIgnoreCase(request.getContentEncoding())));
                throw this.createBingSearchApiClientException(error);
            }
            return this.getWrappedInputStream(request.getInputStream(), GZIP_ENCODING.equalsIgnoreCase(request.getContentEncoding()));
        }
        catch (IOException e) {
            throw new BingSearchException(e);
        }
    }

    protected void closeStream(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            this.LOG.log(Level.SEVERE, "An error occurred while closing stream.", e);
        }
    }

    protected void closeConnection(HttpURLConnection connection) {
        try {
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "An error occurred while disconnecting connection.", e);
        }
    }

    protected BingSearchException createBingSearchApiClientException(Error error) {
        return new BingSearchException();
    }

    protected InputStream getWrappedInputStream(InputStream is, boolean gzip) throws IOException {
        if (gzip) {
            return new BufferedInputStream(new GZIPInputStream(is));
        }
        return new BufferedInputStream(is);
    }

    protected boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void assertNotNullOrEmpty(String name, String value) {
        if (this.isNullOrEmpty(value)) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null or empty.");
        }
    }

    protected void assertNotNullOrEmpty(String name, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null or empty.");
        }
    }

    protected void assertPositiveNumber(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be less than zero.");
        }
    }

    protected void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be null.");
        }
    }

    protected abstract <T> T unmarshallObject(Class<T> var1, InputStream var2);

    protected abstract String marshallObject(Object var1);

    protected abstract BingSearchApiUrls.BingSearchApiUrlBuilder createBingSearchApiUrlBuilder(String var1);

    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(ExecutorService taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

