/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.bing.search.client.constant;

import com.google.code.bing.search.client.constant.ApplicationConstants;
import com.google.code.bing.search.schema.SearchOption;
import com.google.code.bing.search.schema.SearchRequest;
import com.google.code.bing.search.schema.SourceType;
import com.google.code.bing.search.schema.mobileweb.MobileWebRequest;
import com.google.code.bing.search.schema.mobileweb.MobileWebSearchOption;
import com.google.code.bing.search.schema.multimedia.ImageRequest;
import com.google.code.bing.search.schema.multimedia.VideoRequest;
import com.google.code.bing.search.schema.news.NewsRequest;
import com.google.code.bing.search.schema.phonebook.PhonebookRequest;
import com.google.code.bing.search.schema.translation.TranslationRequest;
import com.google.code.bing.search.schema.web.WebRequest;
import com.google.code.bing.search.schema.web.WebSearchOption;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BingSearchApiUrls {
    public static final String API_URLS_FILE = "BingSearchApiUrls.properties";
    private static final Logger LOG = Logger.getLogger(BingSearchApiUrls.class.getCanonicalName());
    private static final Properties bingSearchApiUrls = new Properties();
    public static final String BASE_URL;

    static {
        try {
            bingSearchApiUrls.load(BingSearchApiUrls.class.getResourceAsStream(API_URLS_FILE));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "An error occurred while loading urls.", e);
        }
        BASE_URL = bingSearchApiUrls.getProperty("com.google.code.bing.search.client.url");
    }

    private BingSearchApiUrls() {
    }

    public static class BingSearchApiUrlBuilder {
        private static final String API_PROTOCOL = "json";
        private static final char API_URLS_PLACEHOLDER_START = '{';
        private static final char API_URLS_PLACEHOLDER_END = '}';
        private static final String PROTOCOL_PLACEHOLDER = "protocol";
        private static final String QUERY_PARAMETERS_PLACEHOLDER = "queryParameters";
        private String urlFormat;
        private Map<String, String> parametersMap = new HashMap<String, String>();

        public BingSearchApiUrlBuilder(String urlFormat) {
            this.urlFormat = urlFormat;
        }

        public BingSearchApiUrlBuilder withParameter(String name, String value) {
            if (value != null && value.length() > 0) {
                this.parametersMap.put(name, BingSearchApiUrlBuilder.encodeUrl(value));
            }
            return this;
        }

        private BingSearchApiUrlBuilder withParameter(String name, List<String> values) {
            if (values != null && values.size() > 0) {
                StringBuilder builder = new StringBuilder();
                Iterator<String> iter = values.iterator();
                while (iter.hasNext()) {
                    builder.append(BingSearchApiUrlBuilder.encodeUrl(iter.next()));
                    if (!iter.hasNext()) continue;
                    builder.append("+");
                }
                this.parametersMap.put(name, builder.toString());
            }
            return this;
        }

        private BingSearchApiUrlBuilder withParameter(String name, Object value) {
            if (value != null) {
                this.parametersMap.put(name, BingSearchApiUrlBuilder.encodeUrl(value.toString()));
            }
            return this;
        }

        public BingSearchApiUrlBuilder withSearchRequest(SearchRequest parameters) {
            ArrayList<String> values;
            this.withParameter("Version", parameters.getVersion());
            this.withParameter("Market", parameters.getMarket());
            this.withParameter("UILanguage", parameters.getUILanguage());
            this.withParameter("Query", parameters.getQuery());
            if (parameters.getAdult() != null) {
                this.withParameter("Adult", parameters.getAdult().value());
            }
            this.withParameter("AppId", parameters.getAppId());
            this.withParameter("Latitude", parameters.getLatitude());
            this.withParameter("Longitude", parameters.getLongitude());
            this.withParameter("Radius", parameters.getRadius());
            if (!parameters.getSearchOptionList().isEmpty()) {
                values = new ArrayList<String>();
                for (SearchOption option : parameters.getSearchOptionList()) {
                    values.add(option.value());
                }
                this.withParameter("Options", values);
            }
            if (!parameters.getSourceTypeList().isEmpty()) {
                values = new ArrayList();
                for (SourceType sourceType : parameters.getSourceTypeList()) {
                    values.add(sourceType.value());
                }
                this.withParameter("Sources", values);
            }
            if (parameters.getWebRequest() != null) {
                this.withWebRequest("Web", parameters.getWebRequest());
            }
            if (parameters.getImageRequest() != null) {
                this.withImageRequest("Image", parameters.getImageRequest());
            }
            if (parameters.getPhonebookRequest() != null) {
                this.withPhonebookRequest("Phonebook", parameters.getPhonebookRequest());
            }
            if (parameters.getVideoRequest() != null) {
                this.withVideoRequest("Video", parameters.getVideoRequest());
            }
            if (parameters.getNewsRequest() != null) {
                this.withNewsRequest("News", parameters.getNewsRequest());
            }
            if (parameters.getMobileWebRequest() != null) {
                this.withMobileWebRequest("MobileWeb", parameters.getMobileWebRequest());
            }
            if (parameters.getTranslationRequest() != null) {
                this.withTranslationRequest("Translation", parameters.getTranslationRequest());
            }
            return this;
        }

        public BingSearchApiUrlBuilder withWebRequest(String name, WebRequest request) {
            ArrayList<String> values;
            this.withParameter(String.valueOf(name) + ".Offset", request.getOffset());
            this.withParameter(String.valueOf(name) + ".Count", request.getCount());
            this.withParameter(String.valueOf(name) + ".FileType", request.getFileType());
            if (!request.getWebSearchOptionList().isEmpty()) {
                values = new ArrayList<String>();
                for (WebSearchOption option : request.getWebSearchOptionList()) {
                    values.add(option.value());
                }
                this.withParameter(String.valueOf(name) + ".Options", values);
            }
            if (!request.getSearchTagList().isEmpty()) {
                values = new ArrayList();
                for (String tag : request.getSearchTagList()) {
                    values.add(tag);
                }
                this.withParameter(String.valueOf(name) + ".SearchTags", values);
            }
            return this;
        }

        public BingSearchApiUrlBuilder withImageRequest(String name, ImageRequest request) {
            this.withParameter(String.valueOf(name) + ".Offset", request.getOffset());
            this.withParameter(String.valueOf(name) + ".Count", request.getCount());
            if (!request.getFilterList().isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String filter : request.getFilterList()) {
                    values.add(filter);
                }
                this.withParameter(String.valueOf(name) + ".Filters", values);
            }
            return this;
        }

        public BingSearchApiUrlBuilder withPhonebookRequest(String name, PhonebookRequest request) {
            this.withParameter(String.valueOf(name) + ".Offset", request.getOffset());
            this.withParameter(String.valueOf(name) + ".Count", request.getCount());
            this.withParameter(String.valueOf(name) + ".FileType", request.getFileType());
            if (request.getSortBy() != null) {
                this.withParameter(String.valueOf(name) + ".SortBy", request.getSortBy().value());
            }
            this.withParameter(String.valueOf(name) + ".LocId", request.getLocId());
            this.withParameter(String.valueOf(name) + ".Category", request.getCategory());
            return this;
        }

        public BingSearchApiUrlBuilder withVideoRequest(String name, VideoRequest request) {
            this.withParameter(String.valueOf(name) + ".Offset", request.getOffset());
            this.withParameter(String.valueOf(name) + ".Count", request.getCount());
            if (!request.getFilterList().isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String filter : request.getFilterList()) {
                    values.add(filter);
                }
                this.withParameter(String.valueOf(name) + ".Filters", values);
            }
            if (request.getSortBy() != null) {
                this.withParameter(String.valueOf(name) + ".SortBy", request.getSortBy().value());
            }
            return this;
        }

        public BingSearchApiUrlBuilder withNewsRequest(String name, NewsRequest request) {
            this.withParameter(String.valueOf(name) + ".Offset", request.getOffset());
            this.withParameter(String.valueOf(name) + ".Count", request.getCount());
            this.withParameter(String.valueOf(name) + ".LocationOverride", request.getLocationOverride());
            this.withParameter(String.valueOf(name) + ".Category", request.getCategory());
            if (request.getSortBy() != null) {
                this.withParameter(String.valueOf(name) + ".SortBy", request.getSortBy().value());
            }
            return this;
        }

        public BingSearchApiUrlBuilder withMobileWebRequest(String name, MobileWebRequest request) {
            this.withParameter(String.valueOf(name) + ".Offset", request.getOffset());
            this.withParameter(String.valueOf(name) + ".Count", request.getCount());
            if (!request.getMobileWebSearchOptionList().isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                for (MobileWebSearchOption option : request.getMobileWebSearchOptionList()) {
                    values.add(option.value());
                }
                this.withParameter(String.valueOf(name) + ".Options", values);
            }
            return this;
        }

        public BingSearchApiUrlBuilder withTranslationRequest(String name, TranslationRequest request) {
            this.withParameter(String.valueOf(name) + ".SourceLanguage", request.getSourceLanguage());
            this.withParameter(String.valueOf(name) + ".TargetLanguage", request.getTargetLanguage());
            return this;
        }

        public String buildUrl() {
            StringBuilder urlBuilder = new StringBuilder();
            StringBuilder placeHolderBuilder = new StringBuilder();
            boolean placeHolderFlag = false;
            int i = 0;
            while (i < this.urlFormat.length()) {
                if (this.urlFormat.charAt(i) == '{') {
                    placeHolderBuilder = new StringBuilder();
                    placeHolderFlag = true;
                } else if (placeHolderFlag && this.urlFormat.charAt(i) == '}') {
                    String placeHolder = placeHolderBuilder.toString();
                    if (PROTOCOL_PLACEHOLDER.equals(placeHolder)) {
                        urlBuilder.append(API_PROTOCOL);
                    } else if (QUERY_PARAMETERS_PLACEHOLDER.equals(placeHolder)) {
                        StringBuilder builder = new StringBuilder();
                        if (!this.parametersMap.isEmpty()) {
                            Iterator<String> iter = this.parametersMap.keySet().iterator();
                            while (iter.hasNext()) {
                                String name = iter.next();
                                String value = this.parametersMap.get(name);
                                builder.append(name);
                                builder.append("=");
                                builder.append(value);
                                if (!iter.hasNext()) continue;
                                builder.append("&");
                            }
                        }
                        urlBuilder.append(builder.toString());
                    } else {
                        urlBuilder.append('{');
                        urlBuilder.append(placeHolder);
                        urlBuilder.append('}');
                    }
                    placeHolderFlag = false;
                } else if (placeHolderFlag) {
                    placeHolderBuilder.append(this.urlFormat.charAt(i));
                } else {
                    urlBuilder.append(this.urlFormat.charAt(i));
                }
                ++i;
            }
            return urlBuilder.toString();
        }

        private static String encodeUrl(String original) {
            try {
                return URLEncoder.encode(original, ApplicationConstants.CONTENT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                return original;
            }
        }
    }
}

