/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.bing.search.client.constant;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApplicationConstants {
    public static final String APP_CONSTANTS_FILE = "ApplicationConstants.properties";
    private static final Logger LOG = Logger.getLogger(ApplicationConstants.class.getCanonicalName());
    private static final Properties applicationConstants = new Properties();
    public static final String CONTENT_TYPE_XML;
    public static final String CONTENT_ENCODING;
    public static final String DATE_FORMAT;

    static {
        try {
            applicationConstants.load(ApplicationConstants.class.getResourceAsStream(APP_CONSTANTS_FILE));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "An error occurred while loading properties.", e);
        }
        CONTENT_TYPE_XML = ApplicationConstants.getProperty("com.google.code.bing.search.client.contentTypeXml");
        CONTENT_ENCODING = ApplicationConstants.getProperty("com.google.code.bing.search.client.encoding");
        DATE_FORMAT = ApplicationConstants.getProperty("com.google.code.bing.search.client.dateFormat");
    }

    private ApplicationConstants() {
    }

    public static String getProperty(String key) {
        return applicationConstants.getProperty(key);
    }

    public static int getIntProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return 0;
        }
        return Integer.parseInt(property);
    }

    public static boolean getBooleanProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return false;
        }
        return Boolean.parseBoolean(property);
    }

    public static double getDoubleProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return 0.0;
        }
        return Double.parseDouble(property);
    }

    public static long getLongProperty(String key) {
        String property = applicationConstants.getProperty(key);
        if (ApplicationConstants.isNullOrEmpty(property)) {
            return 0L;
        }
        return Long.parseLong(property);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

