/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.query.DatastoreQuery;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.util.StringUtils;

final class QueryData {
    final Map parameters;
    final AbstractClassMetaData acmd;
    final Map<String, DatastoreTable> tableMap = Utils.newHashMap();
    final QueryCompilation compilation;
    final Query primaryDatastoreQuery;
    final DatastoreQuery.ResultType resultType;
    final Utils.Function<Entity, Object> resultTransformer;
    final LinkedHashMap<String, List<Object>> inFilters = new LinkedHashMap();
    Set<Key> batchGetKeys;
    VariableExpression joinVariableExpression;
    OrderExpression joinOrderExpression;
    Query joinQuery;
    String currentOrProperty;
    boolean isOrExpression = false;

    QueryData(Map parameters, AbstractClassMetaData acmd, DatastoreTable table, QueryCompilation compilation, Query primaryDatastoreQuery, DatastoreQuery.ResultType resultType, Utils.Function<Entity, Object> resultTransformer) {
        this.parameters = parameters;
        this.acmd = acmd;
        this.tableMap.put(acmd.getFullClassName(), table);
        this.compilation = compilation;
        this.primaryDatastoreQuery = primaryDatastoreQuery;
        this.resultType = resultType;
        this.resultTransformer = resultTransformer;
    }

    public String getDatastoreQueryAsString() {
        List sortPreds;
        StringBuilder str = new StringBuilder();
        str.append("Kind=" + StringUtils.collectionToString(this.tableMap.values()));
        List filterPreds = this.primaryDatastoreQuery.getFilterPredicates();
        if (filterPreds.size() > 0) {
            str.append(" Filter : ");
            Iterator filterIter = filterPreds.iterator();
            while (filterIter.hasNext()) {
                Query.FilterPredicate pred = (Query.FilterPredicate)filterIter.next();
                str.append(pred.getPropertyName() + pred.getOperator() + pred.getValue());
                if (!filterIter.hasNext()) continue;
                str.append(" AND ");
            }
        }
        if ((sortPreds = this.primaryDatastoreQuery.getSortPredicates()).size() > 0) {
            str.append(" Sort : ");
            Iterator sortIter = sortPreds.iterator();
            while (sortIter.hasNext()) {
                Query.SortPredicate pred = (Query.SortPredicate)sortIter.next();
                str.append(pred.getPropertyName() + " " + pred.getDirection());
                if (!sortIter.hasNext()) continue;
                str.append(",");
            }
        }
        return str.toString();
    }
}

