/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.datanucleus.DatastoreExceptionTranslator;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.FetchFieldManager;
import com.google.appengine.datanucleus.KeyRegistry;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.query.QueryEntityPKFetchFieldManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class EntityUtils {
    private static final Field PROPERTY_MAP_FIELD;

    public static String getKindName(IdentifierFactory idFactory, AbstractClassMetaData cmd) {
        String kindName = null;
        kindName = cmd.getTable() != null ? cmd.getTable() : idFactory.newDatastoreContainerIdentifier(cmd).getIdentifierName();
        return kindName;
    }

    public static String getPropertyName(IdentifierFactory idFactory, AbstractMemberMetaData ammd) {
        AbstractClassMetaData acmd = ammd.getAbstractClassMetaData();
        VersionMetaData vermd = acmd.getVersionMetaDataForClass();
        if (acmd.isVersioned() && ammd.getName().equals(vermd.getFieldName())) {
            return EntityUtils.getVersionPropertyName(idFactory, acmd.getVersionMetaData());
        }
        if (ammd.getColumn() != null) {
            return ammd.getColumn();
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length > 0 && ammd.getColumnMetaData()[0].getName() != null) {
            if (ammd.getColumnMetaData().length != 1) {
                throw new NucleusUserException("Field " + ammd.getFullFieldName() + " has been specified with more than 1 column! This is unsupported with GAE/J");
            }
            return ammd.getColumnMetaData()[0].getName();
        }
        return idFactory.newDatastoreFieldIdentifier(ammd.getName()).getIdentifierName();
    }

    public static String getVersionPropertyName(IdentifierFactory idFactory, VersionMetaData vmd) {
        ColumnMetaData columnMetaData = vmd.getColumnMetaData();
        if (columnMetaData == null) {
            return idFactory.newVersionFieldIdentifier().getIdentifierName();
        }
        return columnMetaData.getName();
    }

    public static String getDiscriminatorPropertyName(IdentifierFactory idFactory, DiscriminatorMetaData dismd) {
        ColumnMetaData columnMetaData = dismd.getColumnMetaData();
        if (columnMetaData == null) {
            return idFactory.newDiscriminatorFieldIdentifier().getIdentifierName();
        }
        return columnMetaData.getName();
    }

    public static void setEntityProperty(Entity entity, MetaData md, String propertyName, Object value) {
        boolean unindexed = false;
        String val = md.getValueForExtension("gae.unindexed");
        if (val != null && val.equalsIgnoreCase("true")) {
            unindexed = true;
        } else if (md instanceof VersionMetaData && ((VersionMetaData)md).getFieldName() != null) {
            VersionMetaData vmd = (VersionMetaData)md;
            AbstractMemberMetaData vermmd = ((AbstractClassMetaData)vmd.getParent()).getMetaDataForMember(vmd.getFieldName());
            val = vermmd.getValueForExtension("gae.unindexed");
            boolean bl = unindexed = val != null && val.equalsIgnoreCase("true");
        }
        if (unindexed) {
            entity.setUnindexedProperty(propertyName, value);
        } else {
            entity.setProperty(propertyName, value);
        }
    }

    public static String determineKind(AbstractClassMetaData acmd, ExecutionContext ec) {
        MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        return EntityUtils.determineKind(acmd, storeMgr, ec.getClassLoaderResolver());
    }

    public static String determineKind(AbstractClassMetaData acmd, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        DatastoreClass table = storeMgr.getDatastoreClass(acmd.getFullClassName(), clr);
        if (table == null) {
            throw new NoPersistenceInformationException(acmd.getFullClassName());
        }
        return table.getIdentifier().getIdentifierName();
    }

    public static Object idToInternalKey(ExecutionContext ec, Class<?> cls, Object val, boolean allowSubclasses) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cls, ec.getClassLoaderResolver());
        String kind = EntityUtils.determineKind(cmd, ec);
        AbstractMemberMetaData pkMemberMetaData = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[0]);
        return EntityUtils.idToInternalKey(kind, pkMemberMetaData, cls, val, ec, allowSubclasses);
    }

    static Object idToInternalKey(String kind, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Object val, ExecutionContext ec, boolean allowSubclasses) {
        Object result = null;
        Class pkType = pkMemberMetaData.getType();
        if (val instanceof String) {
            result = EntityUtils.stringToInternalKey(kind, pkType, pkMemberMetaData, cls, val);
        } else if (val instanceof Long || val instanceof Integer || Long.TYPE.isInstance(val)) {
            result = EntityUtils.intOrLongToInternalKey(kind, pkType, pkMemberMetaData, cls, val);
        } else if (val instanceof Key) {
            result = EntityUtils.keyToInternalKey(kind, pkType, pkMemberMetaData, cls, (Key)val, ec, allowSubclasses);
        }
        if (result == null && val != null) {
            throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + " identified by " + val + ".  This is not a valid representation of a primary key for an instance of " + cls.getName() + ".");
        }
        return result;
    }

    public static Key getKeyForObject(Object pc, ExecutionContext ec) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)ec.getApiAdapter().getIdForObject(pc);
            if (oid == null) {
                return null;
            }
            Object keyValue = oid.getKeyValue();
            return EntityUtils.getPkAsKey(keyValue, cmd, ec);
        }
        Object internalPk = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(ec.getApiAdapter().getIdForObject(pc));
        if (internalPk == null) {
            return null;
        }
        return EntityUtils.getPkAsKey(internalPk, ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver()), ec);
    }

    public static Key getPkAsKey(ObjectProvider op) {
        if (op.getClassMetaData().getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)op.getInternalObjectId();
            Object keyValue = oid.getKeyValue();
            return EntityUtils.getPkAsKey(keyValue, op.getClassMetaData(), op.getExecutionContext());
        }
        Object pk = op.getExecutionContext().getApiAdapter().getTargetKeyForSingleFieldIdentity(op.getInternalObjectId());
        if (pk == null) {
            throw new IllegalStateException("Primary key for object of type " + op.getClassMetaData().getName() + " is null.");
        }
        return EntityUtils.getPkAsKey(pk, op.getClassMetaData(), op.getExecutionContext());
    }

    static Key getPkAsKey(Object pk, AbstractClassMetaData acmd, ExecutionContext ec) {
        if (pk == null) {
            throw new IllegalStateException("Primary key for object of type " + acmd.getName() + " is null.");
        }
        if (pk instanceof Key) {
            return (Key)pk;
        }
        if (pk instanceof String) {
            if (MetaDataUtils.hasEncodedPKField(acmd)) {
                return KeyFactory.stringToKey((String)((String)pk));
            }
            String kind = EntityUtils.determineKind(acmd, ec);
            return KeyFactory.createKey((String)kind, (String)((String)pk));
        }
        if (pk instanceof Long || Long.TYPE.isInstance(pk)) {
            String kind = EntityUtils.determineKind(acmd, ec);
            return KeyFactory.createKey((String)kind, (long)((Long)pk));
        }
        throw new IllegalStateException("Primary key for object of type " + acmd.getName() + " is of unexpected type " + pk.getClass().getName() + " (must be String, Long, long, or " + Key.class.getName() + ")");
    }

    private static boolean keyKindIsValid(String kind, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Key key, ExecutionContext ec, boolean allowSubclasses) {
        if (key.getKind().equals(kind)) {
            return true;
        }
        if (!allowSubclasses) {
            return false;
        }
        MetaDataManager mdm = ec.getMetaDataManager();
        String[] subclasses = mdm.getSubclassesForClass(cls.getName(), true);
        if (subclasses != null) {
            for (String subclass : subclasses) {
                AbstractClassMetaData subAcmd = mdm.getMetaDataForClass(subclass, ec.getClassLoaderResolver());
                if (!key.getKind().equals(EntityUtils.determineKind(subAcmd, ec))) continue;
                return true;
            }
        }
        return false;
    }

    private static Object keyToInternalKey(String kind, Class<?> pkType, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Key key, ExecutionContext ec, boolean allowSubclasses) {
        Object result = null;
        if (!EntityUtils.keyKindIsValid(kind, pkMemberMetaData, cls, key, ec, allowSubclasses)) {
            throw new NucleusFatalUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is a Key for kind " + key.getKind());
        }
        if (!key.isComplete()) {
            throw new NucleusFatalUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is is an incomplete Key");
        }
        if (pkType.equals(String.class)) {
            if (pkMemberMetaData.hasExtension("gae.encoded-pk")) {
                result = KeyFactory.keyToString((Key)key);
            } else {
                if (key.getParent() != null) {
                    throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String, which means instances of this type " + "never have parents.  However, the Key that was provided as an argument has a " + "parent.");
                }
                result = key.getName();
            }
        } else if (pkType.equals(Long.class) || pkType.equals(Long.TYPE)) {
            if (key.getParent() != null) {
                throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is a Long, which means instances of this type " + "never have parents.  However, the Key that was provided as an argument has a " + "parent.");
            }
            if (key.getName() != null) {
                throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is a Long.  However, the encoded string " + "representation of the Key that was provided as an argument has its name field " + "set, not its id.  This makes it an invalid key for this class.");
            }
            result = key.getId();
        } else if (pkType.equals(Key.class)) {
            result = key;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object intOrLongToInternalKey(String kind, Class<?> pkType, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Object val) {
        String result = null;
        Key keyWithId = KeyFactory.createKey((String)kind, (long)((Number)val).longValue());
        if (pkType.equals(String.class)) {
            if (!pkMemberMetaData.hasExtension("gae.encoded-pk")) throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String.  However, the provided value is of type " + val.getClass().getName() + ".");
            return KeyFactory.keyToString((Key)keyWithId);
        }
        if (pkType.equals(Long.class)) return keyWithId.getId();
        if (pkType.equals(Long.TYPE)) {
            return keyWithId.getId();
        }
        if (!pkType.equals(Key.class)) return result;
        return keyWithId;
    }

    private static Object stringToInternalKey(String kind, Class<?> pkType, AbstractMemberMetaData pkMemberMetaData, Class<?> cls, Object val) {
        Key decodedKey;
        Object result = null;
        try {
            decodedKey = KeyFactory.stringToKey((String)((String)val));
            if (!decodedKey.isComplete()) {
                throw new NucleusFatalUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is the String representation of an incomplete Key for kind " + decodedKey.getKind());
            }
        }
        catch (IllegalArgumentException iae) {
            if (pkType.equals(Long.class) || pkType.equals(Long.TYPE)) {
                throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + " identified by the String " + val + ", but the primary key of " + cls.getName() + " is of type Long.");
            }
            decodedKey = KeyFactory.createKey((String)kind, (String)((String)val));
        }
        if (!decodedKey.getKind().equals(kind)) {
            throw new NucleusFatalUserException("Received a request to find an object of kind " + kind + " but the provided " + "identifier is the String representation of a Key for kind " + decodedKey.getKind());
        }
        if (pkType.equals(String.class)) {
            if (pkMemberMetaData.hasExtension("gae.encoded-pk")) {
                result = KeyFactory.keyToString((Key)decodedKey);
            } else {
                if (decodedKey.getParent() != null) {
                    throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String, which means instances of this type " + "never have parents.  However, the encoded string representation of the Key that " + "was provided as an argument has a parent.");
                }
                if (decodedKey.getName() == null) {
                    throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is an unencoded String.  However, the encoded string " + "representation of the Key that was provided as an argument has its id field " + "set, not its name.  This makes it an invalid key for this class.");
                }
                result = decodedKey.getName();
            }
        } else if (pkType.equals(Long.class) || pkType.equals(Long.TYPE)) {
            if (decodedKey.getParent() != null) {
                throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + ".  The primary " + "key for this type is a Long, which means instances of this type " + "never have parents.  However, the encoded string representation of the Key that " + "was provided as an argument has a parent.");
            }
            if (decodedKey.getName() != null) {
                throw new NucleusFatalUserException("Received a request to find an object of type " + cls.getName() + " identified by the " + "encoded String representation of " + decodedKey + ", but the primary key of " + cls.getName() + " is of type Long and the " + "encoded String has its name component set.  It must have its id component set " + "instead in order to be legal.");
            }
            result = decodedKey.getId();
        } else if (pkType.equals(Key.class)) {
            result = decodedKey;
        }
        return result;
    }

    public static Key getPrimaryKeyAsKey(Object pk, ExecutionContext ec, AbstractClassMetaData cmd) {
        String kind = EntityUtils.determineKind(cmd, ec);
        if (pk instanceof Key) {
            return (Key)pk;
        }
        if (Long.TYPE.isInstance(pk) || pk instanceof Long) {
            return KeyFactory.createKey((String)kind, (long)((Long)pk));
        }
        try {
            return KeyFactory.stringToKey((String)((String)pk));
        }
        catch (IllegalArgumentException iae) {
            return KeyFactory.createKey((String)kind, (String)((String)pk));
        }
    }

    public static Key getPrimaryKeyAsKey(ApiAdapter apiAdapter, ObjectProvider op) {
        if (op.getClassMetaData().getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)op.getInternalObjectId();
            Object keyValue = oid.getKeyValue();
            return EntityUtils.getPrimaryKeyAsKey(keyValue, op.getExecutionContext(), op.getClassMetaData());
        }
        Object primaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(op.getInternalObjectId());
        return EntityUtils.getPrimaryKeyAsKey(primaryKey, op.getExecutionContext(), op.getClassMetaData());
    }

    private static Map<String, Object> getPropertyMap(Entity entity) {
        try {
            return (Map)PROPERTY_MAP_FIELD.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyProperties(Entity src, Entity dest) {
        for (Map.Entry<String, Object> entry : EntityUtils.getPropertyMap(src).entrySet()) {
            if (entry.getValue() != null && entry.getValue().getClass().getName().equals("com.google.appengine.api.datastore.Entity$UnindexedValue")) {
                dest.setUnindexedProperty(entry.getKey(), src.getProperty(entry.getKey()));
                continue;
            }
            dest.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static void checkParentage(Object child, ObjectProvider parentOP) {
        if (child == null) {
            return;
        }
        ExecutionContext ec = parentOP.getExecutionContext();
        ApiAdapter apiAdapter = ec.getApiAdapter();
        ObjectProvider childOP = ec.findObjectProvider(child);
        if (apiAdapter.isNew(child) && (childOP == null || childOP.getAssociatedValue((Object)((DatastoreManager)ec.getStoreManager()).getDatastoreTransaction(ec)) == null)) {
            return;
        }
        Object childKeyOrString = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(child));
        if (childKeyOrString == null) {
            return;
        }
        Key childKey = childKeyOrString instanceof Key ? (Key)childKeyOrString : KeyFactory.stringToKey((String)((String)childKeyOrString));
        Key parentKey = EntityUtils.getPrimaryKeyAsKey(apiAdapter, parentOP);
        if (childKey.getParent() == null) {
            throw new ChildWithoutParentException(parentKey, childKey);
        }
        if (!parentKey.equals((Object)childKey.getParent())) {
            throw new ChildWithWrongParentException(parentKey, childKey);
        }
    }

    public static List<Entity> getEntitiesFromDatastore(DatastoreService ds, List<Key> keys, ExecutionContext ec) {
        Map entityMap;
        DatastoreTransaction txn = ((DatastoreManager)ec.getStoreManager()).getDatastoreTransaction(ec);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Getting entities for keys " + StringUtils.collectionToString(keys)));
        }
        if ((entityMap = txn == null ? ds.get(keys) : ds.get(txn.getInnerTxn(), keys)).size() != keys.size()) {
            NucleusObjectNotFoundException[] excs = new NucleusObjectNotFoundException[keys.size() - entityMap.size()];
            int excNum = 0;
            for (Key key : keys) {
                if (entityMap.containsKey(key)) continue;
                excs[excNum++] = new NucleusObjectNotFoundException("Entity with key not found", (Object)key);
                ++excNum;
            }
            throw new NucleusObjectNotFoundException("Some entities could not be found", (Throwable[])excs);
        }
        ArrayList<Object> entities = Utils.newArrayList(new Object[0]);
        for (Key key : keys) {
            entities.add(entityMap.get(key));
        }
        return entities;
    }

    public static Entity getEntityFromDatastore(DatastoreService ds, ObjectProvider op, Key key) {
        Entity entity;
        ExecutionContext ec = op.getExecutionContext();
        DatastoreTransaction txn = ((DatastoreManager)ec.getStoreManager()).getDatastoreTransaction(ec);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Getting entity of kind " + key.getKind() + " with key " + key));
        }
        try {
            entity = txn == null ? ds.get(key) : ds.get(txn.getInnerTxn(), key);
        }
        catch (EntityNotFoundException e) {
            throw DatastoreExceptionTranslator.wrapEntityNotFoundException(e, key);
        }
        if (op != null) {
            if (op.getExecutionContext().getStoreManager().getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(op.getClassMetaData().getValueForExtension("multitenancy-disable"))) {
                String name = op.getExecutionContext().getStoreManager().getNamingFactory().getColumnName(op.getClassMetaData(), ColumnType.MULTITENANCY_COLUMN);
                if (!entity.hasProperty(name)) {
                    throw new NucleusObjectNotFoundException("Could not retrieve entity of kind " + key.getKind() + " with key " + key);
                }
                String tenantVal = (String)entity.getProperty(name);
                if (!op.getExecutionContext().getStoreManager().getStringProperty("datanucleus.TenantID").equals(tenantVal)) {
                    throw new NucleusObjectNotFoundException("Could not retrieve entity of kind " + key.getKind() + " with key " + key + " : was for different tenant " + tenantVal);
                }
            }
            op.setAssociatedValue((Object)txn, (Object)entity);
        }
        return entity;
    }

    public static DatastoreTransaction putEntityIntoDatastore(ExecutionContext ec, Entity entity) {
        return EntityUtils.putEntitiesIntoDatastore(ec, Collections.singletonList(entity));
    }

    public static DatastoreTransaction putEntitiesIntoDatastore(ExecutionContext ec, List<Entity> entities) {
        DatastoreTransaction txn = ((DatastoreManager)ec.getStoreManager()).getDatastoreTransaction(ec);
        DatastoreService ds = ((DatastoreManager)ec.getStoreManager()).getDatastoreService(ec);
        ArrayList<Object> putMe = Utils.newArrayList(new Object[0]);
        for (Entity entity : entities) {
            Entity previouslyPut;
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer();
                for (Map.Entry entry : entity.getProperties().entrySet()) {
                    str.append((String)entry.getKey() + "[" + entry.getValue() + "]");
                    str.append(", ");
                }
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Putting entity of kind " + entity.getKind() + " with key " + entity.getKey() + " as {" + str.toString() + "}"));
            }
            if (txn == null) {
                putMe.add(entity);
                continue;
            }
            if (txn.getDeletedKeys().contains(entity.getKey()) || (previouslyPut = txn.getPutEntities().get(entity.getKey())) != null && ((Object)previouslyPut.getProperties()).equals(entity.getProperties())) continue;
            putMe.add(entity);
        }
        if (!putMe.isEmpty()) {
            if (txn == null) {
                if (putMe.size() == 1) {
                    ds.put((Entity)putMe.get(0));
                } else {
                    ds.put(putMe);
                }
            } else {
                Transaction innerTxn = txn.getInnerTxn();
                if (putMe.size() == 1) {
                    ds.put(innerTxn, (Entity)putMe.get(0));
                } else {
                    ds.put(innerTxn, putMe);
                }
                txn.addPutEntities(putMe);
            }
        }
        return txn;
    }

    public static void deleteEntitiesFromDatastore(ExecutionContext ec, List<Key> keys) {
        DatastoreTransaction txn;
        DatastoreService ds = ((DatastoreManager)ec.getStoreManager()).getDatastoreService(ec);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting entities with keys " + StringUtils.collectionToString(keys)));
        }
        if ((txn = ((DatastoreManager)ec.getStoreManager()).getDatastoreTransaction(ec)) == null) {
            if (keys.size() == 1) {
                ds.delete(new Key[]{keys.get(0)});
            } else {
                ds.delete(keys);
            }
        } else {
            Transaction innerTxn = txn.getInnerTxn();
            if (keys.size() == 1) {
                ds.delete(innerTxn, new Key[]{keys.get(0)});
            } else {
                ds.delete(innerTxn, keys);
            }
        }
    }

    public static Entity recreateEntityWithParent(Key parentKey, Entity originalEntity) {
        Entity entity = null;
        entity = originalEntity.getKey().getName() != null ? new Entity(originalEntity.getKind(), originalEntity.getKey().getName(), parentKey) : new Entity(originalEntity.getKind(), parentKey);
        EntityUtils.copyProperties(originalEntity, entity);
        return entity;
    }

    public static Key getParentKey(Entity entity, ObjectProvider op) {
        Object parentPojo;
        ObjectProvider mergeOP;
        ObjectProvider ownerOP;
        DatastoreTable table;
        AbstractMemberMetaData parentField;
        Key parentKey = entity.getParent();
        if (parentKey != null) {
            return parentKey;
        }
        ExecutionContext ec = op.getExecutionContext();
        parentKey = KeyRegistry.getKeyRegistry(ec).getParentKeyForOwnedObject(op.getObject());
        if (parentKey == null && (parentField = (table = ((DatastoreManager)ec.getStoreManager()).getDatastoreClass(op.getClassMetaData().getFullClassName(), ec.getClassLoaderResolver())).getParentMappingMemberMetaData()) != null && MetaDataUtils.isOwnedRelation(parentField)) {
            Object parent = op.provideField(parentField.getAbsoluteFieldNumber());
            Key key = parentKey = parent == null ? null : EntityUtils.getKeyForObject(parent, ec);
        }
        if (parentKey == null && (ownerOP = op.getExecutionContext().getObjectProviderOfOwnerForAttachingObject(op.getObject())) != null && (mergeOP = ec.findObjectProvider(parentPojo = ownerOP.getObject())) != null) {
            parentKey = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), mergeOP);
        }
        return parentKey;
    }

    public static Key extractChildKey(Object childObj, ExecutionContext ec, Entity parentEntity) {
        if (childObj == null) {
            return null;
        }
        AbstractClassMetaData childCmd = ec.getMetaDataManager().getMetaDataForClass(childObj.getClass(), ec.getClassLoaderResolver());
        if (ec.getApiAdapter().isDetached(childObj)) {
            Object valueID = ec.getApiAdapter().getIdForObject(childObj);
            if (childCmd.getIdentityType() == IdentityType.DATASTORE) {
                OID oid = (OID)valueID;
                Object keyValue = oid.getKeyValue();
                return EntityUtils.getPkAsKey(keyValue, childCmd, ec);
            }
            Object valuePK = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(valueID);
            Key key = EntityUtils.getPrimaryKeyAsKey(valuePK, ec, ec.getMetaDataManager().getMetaDataForClass(childObj.getClass(), ec.getClassLoaderResolver()));
            return key;
        }
        if (ec.getApiAdapter().isDeleted(childObj)) {
            return null;
        }
        ObjectProvider childOP = ec.findObjectProvider(childObj);
        if (childOP == null) {
            return null;
        }
        Key key = null;
        if (childCmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)childOP.getInternalObjectId();
            if (oid == null) {
                return null;
            }
            key = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), childOP);
        } else {
            Object primaryKey = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(childOP.getInternalObjectId());
            if (primaryKey == null) {
                return null;
            }
            key = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), childOP);
        }
        if (key == null) {
            throw new NullPointerException("Could not extract a key from " + childObj);
        }
        if (parentEntity != null) {
            if (key.getParent() == null) {
                throw new ChildWithoutParentException(parentEntity.getKey(), key);
            }
            if (!key.getParent().equals((Object)parentEntity.getKey())) {
                throw new ChildWithWrongParentException(parentEntity.getKey(), key);
            }
        }
        return key;
    }

    public static Object entityToPojo(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, ExecutionContext ec, boolean ignoreCache, final FetchPlan fetchPlan) {
        DatastoreManager storeMgr = (DatastoreManager)ec.getStoreManager();
        DatastoreTable table = storeMgr.getDatastoreClass(acmd.getFullClassName(), ec.getClassLoaderResolver());
        storeMgr.validateMetaDataForClass(acmd);
        Object fv = null;
        if (fetchPlan != null) {
            fetchPlan.manageFetchPlanForClass(acmd);
            final int[] fieldsToFetch = fetchPlan.getFetchPlanForClass(acmd).getMemberNumbers();
            fv = new FieldValues(){

                public void fetchFields(ObjectProvider op) {
                    op.replaceFields(fieldsToFetch, (FieldManager)new FetchFieldManager(op, entity));
                }

                public void fetchNonLoadedFields(ObjectProvider op) {
                    op.replaceNonLoadedFields(fieldsToFetch, (FieldManager)new FetchFieldManager(op, entity));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return fetchPlan;
                }
            };
        } else {
            fv = new FieldValues(){

                public void fetchFields(ObjectProvider op) {
                    op.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(op, entity));
                }

                public void fetchNonLoadedFields(ObjectProvider op) {
                    op.replaceNonLoadedFields(acmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(op, entity));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            };
        }
        Object id = null;
        Class<?> cls = EntityUtils.getClassFromDiscriminator(entity, acmd, table, clr, ec);
        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            Key key = entity.getKey();
            id = key.getName() != null ? OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)key.getName()) : OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cls.getName(), (Object)key.getId());
        } else {
            QueryEntityPKFetchFieldManager fm = new QueryEntityPKFetchFieldManager(acmd, entity);
            id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)acmd, cls, (boolean)true, (FieldManager)fm);
        }
        Object pojo = ec.findObject(id, fv, cls, ignoreCache);
        ObjectProvider op = ec.findObjectProvider(pojo);
        op.setAssociatedValue((Object)((DatastoreManager)ec.getStoreManager()).getDatastoreTransaction(ec), (Object)entity);
        if (fetchPlan == null) {
            storeMgr.getPersistenceHandler().fetchObject(op, acmd.getAllMemberPositions());
        }
        return pojo;
    }

    private static Class<?> getClassFromDiscriminator(Entity entity, AbstractClassMetaData acmd, DatastoreTable table, ClassLoaderResolver clr, ExecutionContext ec) {
        if (!acmd.hasDiscriminatorStrategy()) {
            return clr.classForName(acmd.getFullClassName());
        }
        String discrimPropertyName = EntityUtils.getDiscriminatorPropertyName(table.getStoreManager().getIdentifierFactory(), acmd.getDiscriminatorMetaDataRoot());
        Object discrimValue = entity.getProperty(discrimPropertyName);
        if (discrimValue == null) {
            throw new NucleusUserException("Discriminator of this entity is null: " + entity);
        }
        String rowClassName = null;
        if (acmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME) {
            rowClassName = (String)discrimValue;
        } else if (acmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            Object discrimMDValue = acmd.getDiscriminatorValue();
            if (discrimMDValue.equals(discrimValue)) {
                rowClassName = acmd.getFullClassName();
            } else {
                for (Object o : ec.getStoreManager().getSubClassesForClass(acmd.getFullClassName(), true, clr)) {
                    String className = (String)o;
                    AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(className, clr);
                    discrimMDValue = cmd.getDiscriminatorValue();
                    if (!discrimValue.equals(discrimMDValue)) continue;
                    rowClassName = className;
                    break;
                }
            }
        }
        if (rowClassName == null) {
            throw new NucleusUserException("Cannot get the class for entity " + entity + "\n" + "This can happen if the meta data for the subclasses of " + acmd.getFullClassName() + " is not yet loaded! You may want to consider using the datanucleus autostart mechanism" + " to tell datanucleus about these classes.");
        }
        return clr.classForName(rowClassName);
    }

    static {
        try {
            PROPERTY_MAP_FIELD = Entity.class.getDeclaredField("propertyMap");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        PROPERTY_MAP_FIELD.setAccessible(true);
    }

    static class ChildWithWrongParentException
    extends NucleusFatalUserException {
        public ChildWithWrongParentException(Key parentKey, Key childKey) {
            super("Detected attempt to establish " + parentKey + " as the " + "parent of " + childKey + " but the entity identified by " + childKey + " is already a child of " + childKey.getParent() + ".  A parent cannot " + "be established or changed once an object has been persisted.");
        }
    }

    static class ChildWithoutParentException
    extends NucleusFatalUserException {
        public ChildWithoutParentException(Key parentKey, Key childKey) {
            super("Detected attempt to establish " + parentKey + " as the " + "parent of " + childKey + " but the entity identified by " + childKey + " has already been persisted without a parent.  A parent cannot " + "be established or changed once an object has been persisted.");
        }
    }
}

