/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.datanucleus.BatchDeleteManager;
import com.google.appengine.datanucleus.BatchPutManager;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.FetchFieldManager;
import com.google.appengine.datanucleus.KeyRegistry;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.StoreFieldManager;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.mapping.DependentDeleteRequest;
import com.google.appengine.datanucleus.mapping.FetchMappingConsumer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.PersistenceBatchType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.mapped.mapping.IndexMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class DatastorePersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser GAE_LOCALISER = Localiser.getInstance((String)"com.google.appengine.datanucleus.Localisation", (ClassLoader)DatastoreManager.class.getClassLoader());
    private final DatastoreManager storeMgr;
    private final Map<ExecutionContext, BatchPutManager> batchPutManagerByExecutionContext = new HashMap<ExecutionContext, BatchPutManager>();
    private final Map<ExecutionContext, BatchDeleteManager> batchDeleteManagerByExecutionContext = new HashMap<ExecutionContext, BatchDeleteManager>();

    public DatastorePersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (DatastoreManager)storeMgr;
    }

    public void close() {
    }

    public boolean useReferentialIntegrity() {
        return true;
    }

    protected BatchPutManager getBatchPutManager(ExecutionContext ec) {
        BatchPutManager putMgr = this.batchPutManagerByExecutionContext.get(ec);
        if (putMgr == null) {
            putMgr = new BatchPutManager();
            this.batchPutManagerByExecutionContext.put(ec, putMgr);
        }
        return putMgr;
    }

    protected BatchDeleteManager getBatchDeleteManager(ExecutionContext ec) {
        BatchDeleteManager deleteMgr = this.batchDeleteManagerByExecutionContext.get(ec);
        if (deleteMgr == null) {
            deleteMgr = new BatchDeleteManager(ec);
            this.batchDeleteManagerByExecutionContext.put(ec, deleteMgr);
        }
        return deleteMgr;
    }

    public void batchStart(ExecutionContext ec, PersistenceBatchType batchType) {
        if (batchType == PersistenceBatchType.PERSIST) {
            this.getBatchPutManager(ec).start();
        } else if (batchType == PersistenceBatchType.DELETE) {
            this.getBatchDeleteManager(ec).start();
        }
    }

    public void batchEnd(ExecutionContext ec, PersistenceBatchType batchType) {
        if (batchType == PersistenceBatchType.PERSIST) {
            this.getBatchPutManager(ec).finish(this);
            this.batchPutManagerByExecutionContext.remove(ec);
        } else if (batchType == PersistenceBatchType.DELETE) {
            this.getBatchDeleteManager(ec).finish(this);
            this.batchDeleteManagerByExecutionContext.remove(ec);
        }
    }

    public void insertObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        this.storeMgr.validateMetaDataForClass(op.getClassMetaData());
        BatchPutManager batchPutMgr = this.getBatchPutManager(op.getExecutionContext());
        if (batchPutMgr.batchOperationInProgress()) {
            batchPutMgr.add(op);
            return;
        }
        this.insertObjectsInternal(Collections.singletonList(op));
    }

    /*
     * WARNING - void declaration
     */
    void insertObjectsInternal(List<ObjectProvider> opsToInsert) {
        AbstractClassMetaData cmd;
        if (opsToInsert == null || opsToInsert.isEmpty()) {
            return;
        }
        ExecutionContext ec = opsToInsert.get(0).getExecutionContext();
        ArrayList<Object> putStateList = Utils.newArrayList(new Object[0]);
        for (ObjectProvider objectProvider : opsToInsert) {
            cmd = objectProvider.getClassMetaData();
            StoreFieldManager fieldMgr = new StoreFieldManager(objectProvider, EntityUtils.determineKind(cmd, ec));
            objectProvider.provideFields(objectProvider.getClassMetaData().getAllMemberPositions(), (FieldManager)fieldMgr);
            Object object = fieldMgr.establishEntityGroup();
            Entity entity = fieldMgr.getEntity();
            DatastoreTable table = this.storeMgr.getDatastoreClass(objectProvider.getClassMetaData().getFullClassName(), ec.getClassLoaderResolver());
            Collection<JavaTypeMapping> orderMappings = table.getExternalOrderMappings().values();
            for (JavaTypeMapping orderMapping : orderMappings) {
                Object orderValue;
                if (!(orderMapping instanceof IndexMapping) || (orderValue = objectProvider.getAssociatedValue((Object)orderMapping)) == null) continue;
                DatastoreField indexProp = orderMapping.getDatastoreMapping(0).getDatastoreField();
                entity.setProperty(indexProp.getIdentifier().toString(), orderValue);
            }
            this.handleVersioningBeforeWrite(objectProvider, entity, true, "inserting");
            if (objectProvider.getClassMetaData().hasDiscriminatorStrategy()) {
                DiscriminatorMetaData dismd = objectProvider.getClassMetaData().getDiscriminatorMetaDataRoot();
                EntityUtils.setEntityProperty(entity, (MetaData)dismd, EntityUtils.getDiscriminatorPropertyName(this.storeMgr.getIdentifierFactory(), dismd), objectProvider.getClassMetaData().getDiscriminatorValue());
            }
            if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String name = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
                EntityUtils.setEntityProperty(entity, (MetaData)cmd, name, this.storeMgr.getStringProperty("datanucleus.TenantID"));
            }
            AbstractMemberMetaData parentPkMmd = this.storeMgr.getMetaDataForParentPK(cmd);
            if (object != null) {
                objectProvider.replaceField(parentPkMmd.getAbsoluteFieldNumber(), object);
            }
            putStateList.add(new PutState(objectProvider, fieldMgr, entity));
        }
        if (!putStateList.isEmpty()) {
            DatastoreTransaction txn = null;
            Object var5_6 = null;
            ArrayList<Object> entityList = Utils.newArrayList(new Object[0]);
            for (PutState putState : putStateList) {
                void var5_7;
                if (txn == null) {
                    txn = this.storeMgr.getDatastoreTransaction(ec);
                }
                if (var5_7 == null) {
                    AbstractClassMetaData abstractClassMetaData = putState.op.getClassMetaData();
                }
                entityList.add(putState.entity);
            }
            EntityUtils.putEntitiesIntoDatastore(ec, entityList);
            for (PutState putState : putStateList) {
                putState.op.setAssociatedValue((Object)txn, (Object)putState.entity);
            }
        }
        for (PutState putState : putStateList) {
            cmd = putState.op.getClassMetaData();
            Object newId = null;
            Object var8_20 = null;
            boolean identityStrategyUsed = false;
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFields = cmd.getPKMemberPositions();
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFields[0]);
                if (pkMmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
                    identityStrategyUsed = true;
                    Class clazz = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[0]).getType();
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE && cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.IDENTITY) {
                identityStrategyUsed = true;
                Class<Key> clazz = Key.class;
                ColumnMetaData colmd = cmd.getIdentityMetaData().getColumnMetaData();
                if (colmd != null) {
                    if ("varchar".equalsIgnoreCase(colmd.getJdbcType()) || "char".equalsIgnoreCase(colmd.getJdbcType())) {
                        Class<String> clazz2 = String.class;
                    } else if ("integer".equalsIgnoreCase(colmd.getJdbcType()) || "numeric".equalsIgnoreCase(colmd.getJdbcType())) {
                        Class<Long> clazz3 = Long.class;
                    }
                }
            }
            if (identityStrategyUsed) {
                void var8_26;
                if (var8_26.equals(Key.class)) {
                    newId = putState.entity.getKey();
                } else if (var8_26.equals(String.class)) {
                    newId = MetaDataUtils.hasEncodedPKField(cmd) ? KeyFactory.keyToString((Key)putState.entity.getKey()) : putState.entity.getKey().getName();
                } else if (var8_26.equals(Long.class) || var8_26.equals(Long.TYPE)) {
                    newId = putState.entity.getKey().getId();
                }
                putState.op.setPostStoreNewObjectId(newId);
            }
            if (putState.fieldMgr.storeRelations(KeyRegistry.getKeyRegistry(ec))) {
                EntityUtils.putEntityIntoDatastore(ec, putState.entity);
            }
            putState.op.replaceAllLoadedSCOFieldsWithWrappers();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        ExecutionContext ec;
        Entity entity;
        if (op.getLifecycleState().isDeleted()) {
            return;
        }
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        this.storeMgr.validateMetaDataForClass(op.getClassMetaData());
        AbstractClassMetaData cmd = op.getClassMetaData();
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            StringBuffer fieldStr = new StringBuffer();
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    fieldStr.append(",");
                }
                fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            NucleusLogger.DATASTORE_PERSIST.debug((Object)GAE_LOCALISER.msg("AppEngine.Update.Start", (Object)op.toPrintableID(), op.getInternalObjectId(), (Object)fieldStr.toString()));
        }
        if ((entity = (Entity)op.getAssociatedValue((Object)this.storeMgr.getDatastoreTransaction(ec = op.getExecutionContext()))) == null) {
            Key key = EntityUtils.getPkAsKey(op);
            entity = EntityUtils.getEntityFromDatastore(this.storeMgr.getDatastoreServiceForReads(ec), op, key);
        }
        StoreFieldManager fieldMgr = new StoreFieldManager(op, entity, fieldNumbers);
        op.provideFields(fieldNumbers, (FieldManager)fieldMgr);
        this.handleVersioningBeforeWrite(op, entity, true, "updating");
        fieldMgr.storeRelations(KeyRegistry.getKeyRegistry(op.getExecutionContext()));
        DatastoreTransaction txn = EntityUtils.putEntityIntoDatastore(ec, entity);
        op.setAssociatedValue((Object)txn, (Object)entity);
        op.replaceAllLoadedSCOFieldsWithWrappers();
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)GAE_LOCALISER.msg("AppEngine.ExecutionTime", System.currentTimeMillis() - startTime));
        }
    }

    public void deleteObject(ObjectProvider op) {
        DatastoreTransaction txn;
        ExecutionContext ec;
        Entity entity;
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        this.storeMgr.validateMetaDataForClass(op.getClassMetaData());
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)GAE_LOCALISER.msg("AppEngine.Delete.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
        }
        if ((entity = (Entity)op.getAssociatedValue((Object)this.storeMgr.getDatastoreTransaction(ec = op.getExecutionContext()))) == null) {
            Key key = EntityUtils.getPkAsKey(op);
            entity = EntityUtils.getEntityFromDatastore(this.storeMgr.getDatastoreServiceForReads(ec), op, key);
        }
        if ((txn = this.storeMgr.getDatastoreTransaction(ec)) != null) {
            txn.addDeletedKey(entity.getKey());
        }
        this.handleVersioningBeforeWrite(op, entity, false, "deleting");
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        DatastoreTable dc = this.storeMgr.getDatastoreClass(op.getObject().getClass().getName(), clr);
        DependentDeleteRequest req = new DependentDeleteRequest(dc, op.getClassMetaData(), clr);
        Set relatedObjectsToDelete = req.execute(op, entity);
        Key keyToDelete = EntityUtils.getPkAsKey(op);
        BatchDeleteManager bdm = this.getBatchDeleteManager(ec);
        if (bdm.batchOperationInProgress()) {
            bdm.add(new BatchDeleteManager.BatchDeleteState(txn, keyToDelete));
            if (relatedObjectsToDelete != null && !relatedObjectsToDelete.isEmpty()) {
                for (Object relatedObject : relatedObjectsToDelete) {
                    ec.deleteObjectInternal(relatedObject);
                }
            }
            return;
        }
        EntityUtils.deleteEntitiesFromDatastore(ec, Collections.singletonList(keyToDelete));
        if (relatedObjectsToDelete != null && !relatedObjectsToDelete.isEmpty()) {
            for (Object relatedObject : relatedObjectsToDelete) {
                ec.deleteObjectInternal(relatedObject);
            }
        }
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)GAE_LOCALISER.msg("AppEngine.ExecutionTime", System.currentTimeMillis() - startTime));
        }
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        this.storeMgr.validateMetaDataForClass(cmd);
        ExecutionContext ec = op.getExecutionContext();
        Entity entity = (Entity)op.getAssociatedValue((Object)this.storeMgr.getDatastoreTransaction(ec));
        if (entity == null) {
            Key pk = EntityUtils.getPkAsKey(op);
            entity = EntityUtils.getEntityFromDatastore(this.storeMgr.getDatastoreServiceForReads(ec), op, pk);
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(op.toPrintableID()).append("\" (id=");
            str.append(ec.getApiAdapter().getObjectId(op)).append(")").append(" fields [");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str);
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)GAE_LOCALISER.msg("AppEngine.Fetch.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
        }
        op.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(op, entity, fieldNumbers));
        VersionMetaData vmd = cmd.getVersionMetaDataForClass();
        if (cmd.isVersioned()) {
            Object versionValue = entity.getProperty(EntityUtils.getVersionPropertyName(this.storeMgr.getIdentifierFactory(), vmd));
            if (vmd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                versionValue = new Timestamp((Long)versionValue);
            }
            op.setVersion(versionValue);
        }
        AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[fieldNumbers.length];
        for (int i = 0; i < fmds.length; ++i) {
            fmds[i] = op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        DatastoreTable dc = this.storeMgr.getDatastoreClass(op.getObject().getClass().getName(), clr);
        FetchMappingConsumer consumer = new FetchMappingConsumer(op.getClassMetaData());
        dc.provideMappingsForMembers(consumer, fmds, true);
        dc.provideDatastoreIdMappings(consumer);
        dc.providePrimaryKeyMappings(consumer);
        for (MappingCallbacks callback : consumer.getMappingCallbacks()) {
            if (callback instanceof ArrayMapping || callback instanceof MapMapping) continue;
            if (callback instanceof CollectionMapping) {
                CollectionMapping m = (CollectionMapping)callback;
                Object val = op.provideField(m.getMemberMetaData().getAbsoluteFieldNumber());
                if (val != null && val instanceof SCO) continue;
                callback.postFetch(op);
                continue;
            }
            callback.postFetch(op);
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)GAE_LOCALISER.msg("AppEngine.ExecutionTime", System.currentTimeMillis() - startTime));
        }
    }

    public void locateObjects(ObjectProvider[] ops) {
        if (ops == null) {
            return;
        }
        ArrayList<Object> keysToLocate = Utils.newArrayList(new Object[0]);
        for (int i = 0; i < ops.length; ++i) {
            Key key = EntityUtils.getPkAsKey(ops[i]);
            keysToLocate.add(key);
        }
        EntityUtils.getEntitiesFromDatastore(this.storeMgr.getDatastoreServiceForReads(ops[0].getExecutionContext()), keysToLocate, ops[0].getExecutionContext());
    }

    public void locateObject(ObjectProvider op) {
        this.storeMgr.validateMetaDataForClass(op.getClassMetaData());
        EntityUtils.getEntityFromDatastore(this.storeMgr.getDatastoreServiceForReads(op.getExecutionContext()), op, EntityUtils.getPkAsKey(op));
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    private void handleVersioningBeforeWrite(ObjectProvider op, Entity entity, boolean increment, String operation) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        VersionMetaData vmd = cmd.getVersionMetaDataForClass();
        if (cmd.isVersioned()) {
            String versionPropertyName = EntityUtils.getVersionPropertyName(this.storeMgr.getIdentifierFactory(), vmd);
            Object curVersion = op.getExecutionContext().getApiAdapter().getVersion(op);
            if (curVersion != null) {
                Entity refreshedEntity;
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Getting entity with key " + entity.getKey()));
                }
                try {
                    refreshedEntity = this.storeMgr.getDatastoreServiceForReads(op.getExecutionContext()).get(entity.getKey());
                }
                catch (EntityNotFoundException e) {
                    throw new NucleusOptimisticException(GAE_LOCALISER.msg("AppEngine.OptimisticError.EntityHasBeenDeleted", (Object)operation, (Object)cmd.getFullClassName(), (Object)entity.getKey()));
                }
                Object datastoreVersion = refreshedEntity.getProperty(versionPropertyName);
                if (vmd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    datastoreVersion = new Timestamp((Long)datastoreVersion);
                }
                if (!datastoreVersion.equals(curVersion)) {
                    throw new NucleusOptimisticException(GAE_LOCALISER.msg("AppEngine.OptimisticError.EntityHasBeenUpdated", (Object)operation, (Object)cmd.getFullClassName(), (Object)entity.getKey()));
                }
            }
            Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vmd.getVersionStrategy(), (Object)curVersion);
            op.setTransactionalVersion(nextVersion);
            if (vmd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                EntityUtils.setEntityProperty(entity, (MetaData)vmd, versionPropertyName, ((Timestamp)nextVersion).getTime());
            } else {
                EntityUtils.setEntityProperty(entity, (MetaData)vmd, versionPropertyName, nextVersion);
            }
            if (increment && vmd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vmd.getParent()).getMetaDataForMember(vmd.getFieldName());
                if (nextVersion instanceof Number) {
                    Number nextNumber = (Number)nextVersion;
                    if (verfmd.getType().equals(Long.class) || verfmd.getType().equals(Long.TYPE)) {
                        nextVersion = nextNumber.longValue();
                    } else if (verfmd.getType().equals(Integer.class) || verfmd.getType().equals(Integer.TYPE)) {
                        nextVersion = nextNumber.intValue();
                    } else if (verfmd.getType().equals(Short.class) || verfmd.getType().equals(Short.TYPE)) {
                        nextVersion = nextNumber.shortValue();
                    }
                }
                op.replaceField(verfmd.getAbsoluteFieldNumber(), nextVersion);
            }
        }
    }

    private static final class PutState {
        private final ObjectProvider op;
        private final StoreFieldManager fieldMgr;
        private final Entity entity;

        private PutState(ObjectProvider op, StoreFieldManager fieldMgr, Entity entity) {
            this.op = op;
            this.fieldMgr = fieldMgr;
            this.entity = entity;
        }
    }
}

