/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ReflectionMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtil {
    public static Map<String, Object> mapOf(Object data) {
        if (data == null) {
            return Collections.emptyMap();
        }
        if (data instanceof Map) {
            Map result = (Map)data;
            return result;
        }
        return new ReflectionMap(data);
    }

    public static <T> T clone(T data) {
        Object copy;
        if (FieldInfo.isPrimitive(data)) {
            return data;
        }
        if (data instanceof GenericData) {
            GenericData copyTmp = ((GenericData)data).clone();
            copy = copyTmp;
        } else if (data instanceof ArrayMap) {
            Object copyTmp;
            copy = copyTmp = ((ArrayMap)data).clone();
        } else {
            Object copyTmp = ClassInfo.newInstance(data.getClass());
            copy = copyTmp;
        }
        DataUtil.cloneInternal(data, copy);
        return (T)copy;
    }

    static void cloneInternal(Object src, Object dest) {
        Class<?> srcClass = src.getClass();
        if (Collection.class.isAssignableFrom(srcClass)) {
            Collection srcCollection = (Collection)src;
            if (ArrayList.class.isAssignableFrom(srcClass)) {
                ArrayList destArrayList = (ArrayList)dest;
                destArrayList.ensureCapacity(srcCollection.size());
            }
            Collection destCollection = (Collection)dest;
            for (Object srcValue : srcCollection) {
                destCollection.add(DataUtil.clone(srcValue));
            }
        } else {
            boolean isGenericData = GenericData.class.isAssignableFrom(srcClass);
            if (isGenericData || !Map.class.isAssignableFrom(srcClass)) {
                ClassInfo classInfo = ClassInfo.of(srcClass);
                for (String fieldName : classInfo.getKeyNames()) {
                    Object srcValue;
                    FieldInfo fieldInfo = classInfo.getFieldInfo(fieldName);
                    if (fieldInfo.isFinal || isGenericData && fieldInfo.isPrimitive || (srcValue = fieldInfo.getValue(src)) == null) continue;
                    fieldInfo.setValue(dest, DataUtil.clone(srcValue));
                }
            } else if (ArrayMap.class.isAssignableFrom(srcClass)) {
                ArrayMap destMap = (ArrayMap)dest;
                ArrayMap srcMap = (ArrayMap)src;
                int size = srcMap.size();
                for (int i = 0; i < size; ++i) {
                    Object srcValue = srcMap.getValue(i);
                    if (FieldInfo.isPrimitive(srcValue)) continue;
                    destMap.set(i, DataUtil.clone(srcValue));
                }
            } else {
                Map destMap = (Map)dest;
                Map srcMap = (Map)src;
                for (Map.Entry srcEntry : srcMap.entrySet()) {
                    destMap.put(srcEntry.getKey(), DataUtil.clone(srcEntry.getValue()));
                }
            }
        }
    }

    private DataUtil() {
    }
}

