/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.SyntaxLabels;

class JenaRDF2JSONLD
implements RDFParser {
    NodeToLabel labels = SyntaxLabels.createNodeToLabel();

    JenaRDF2JSONLD() {
    }

    public RDFDataset parse(Object object) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (object instanceof DatasetGraph) {
            DatasetGraph dsg = (DatasetGraph)object;
            Iterator iter = dsg.find();
            while (iter.hasNext()) {
                Quad q = (Quad)iter.next();
                Node s = q.getSubject();
                Node p = q.getPredicate();
                Node o = q.getObject();
                Node g = q.getGraph();
                String gq = g == null || Quad.isDefaultGraph((Node)g) ? null : g.getURI();
                String sq = this.resourceString(s);
                String pq = p.getURI();
                if (o.isLiteral()) {
                    String lex = o.getLiteralLexicalForm();
                    String lang = o.getLiteralLanguage();
                    String dt = o.getLiteralDatatypeURI();
                    if (lang != null && lang.length() == 0) {
                        lang = null;
                    }
                    if (dt == null) {
                        dt = XSDDatatype.XSDstring.getURI();
                    }
                    result.addQuad(sq, pq, lex, dt, lang, gq);
                    continue;
                }
                String oq = this.resourceString(o);
                result.addQuad(sq, pq, oq, gq);
            }
        } else {
            Log.warn(JenaRDF2JSONLD.class, (String)"unknown");
        }
        return result;
    }

    private String resourceString(Node x) {
        if (x.isURI()) {
            return x.getURI();
        }
        if (x.isBlank()) {
            return (String)this.labels.get(null, (Object)x);
        }
        return null;
    }
}

