/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecution;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLStageGenerator;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Model;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;

public class SparqlDLExecutionFactory {
    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        QueryEngineType engineType = QueryEngineType.ARQ;
        Graph graph = dataset.getDefaultModel().getGraph();
        if (graph instanceof PelletInfGraph) {
            if (dataset.listNames().hasNext() || query.isDescribeType()) {
                engineType = QueryEngineType.MIXED;
            } else {
                PelletInfGraph pelletInfGraph = (PelletInfGraph)graph;
                KnowledgeBase kb = pelletInfGraph.getKB();
                pelletInfGraph.prepare();
                ARQParser parser = new ARQParser();
                parser.setInitialBinding(initialBinding);
                try {
                    parser.parse(query, kb);
                    engineType = QueryEngineType.PELLET;
                }
                catch (UnsupportedQueryException e) {
                    engineType = QueryEngineType.MIXED;
                }
            }
        }
        return SparqlDLExecutionFactory.create(query, dataset, initialBinding, engineType);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding, QueryEngineType queryEngineType) {
        return SparqlDLExecutionFactory.create(query, dataset, initialBinding, queryEngineType, true);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding, QueryEngineType queryEngineType, boolean handleVariableSPO) throws QueryException {
        QueryExecution queryExec = null;
        switch (queryEngineType) {
            case PELLET: {
                queryExec = new SparqlDLExecution(query, dataset, handleVariableSPO);
                ((SparqlDLExecution)queryExec).setPurePelletQueryExec(true);
                break;
            }
            case ARQ: {
                queryExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                break;
            }
            case MIXED: {
                queryExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                queryExec.getContext().set(ARQ.stageGenerator, (Object)new SparqlDLStageGenerator(handleVariableSPO));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (initialBinding != null) {
            queryExec.setInitialBinding(initialBinding);
        }
        return queryExec;
    }

    public static QueryExecution create(Query query, Model model) {
        return SparqlDLExecutionFactory.create(query, model, null);
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query, dataset, null);
    }

    public static QueryExecution create(Query query, Model model, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query, (Dataset)DatasetFactory.create((Model)model), initialBinding);
    }

    public static QueryExecution createPelletExecution(Query query, Model model) {
        return SparqlDLExecutionFactory.create(query, (Dataset)DatasetFactory.create((Model)model), null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Model model, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query, (Dataset)DatasetFactory.create((Model)model), initialBinding, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query, dataset, null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Dataset dataset, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query, dataset, initialBinding, QueryEngineType.PELLET);
    }

    public static QueryExecution createBasicExecution(Query query, Model model) {
        return SparqlDLExecutionFactory.createPelletExecution(query, model);
    }

    public static QueryExecution createBasicExecution(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.createPelletExecution(query, dataset);
    }

    public static enum QueryEngineType {
        ARQ,
        MIXED,
        PELLET;

    }
}

