/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.EntailmentChecker;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.owlapiv3.PelletVisitor;
import com.clarkparsia.pellet.owlapiv3.ProgressAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.PelletRuntimeException;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.TimerInterruptedException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.VersionInfo;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

public class PelletReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    public static final Logger log = Logger.getLogger(PelletReasoner.class.getName());
    private static final Set<InferenceType> PRECOMPUTABLE_INFERENCES = EnumSet.of(InferenceType.CLASS_HIERARCHY, InferenceType.CLASS_ASSERTIONS, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY);
    private static final Version VERSION = PelletReasoner.createVersion();
    private final OWLDataFactory factory;
    private KnowledgeBase kb;
    private final OWLOntologyManager manager;
    private final ReasonerProgressMonitor monitor;
    private final OWLOntology ontology;
    private Set<OWLOntology> importsClosure;
    private boolean shouldRefresh;
    private final PelletVisitor visitor;
    private final BufferingMode bufferingMode;
    private final List<OWLOntologyChange> pendingChanges;
    private final IndividualNodeSetPolicy individualNodeSetPolicy;
    private final ChangeVisitor changeVisitor = new ChangeVisitor();
    private final EntityMapper<OWLNamedIndividual> IND_MAPPER = new NamedIndividualMapper();
    private final EntityMapper<OWLLiteral> LIT_MAPPER = new LiteralMapper();
    private final EntityMapper<OWLObjectPropertyExpression> OP_MAPPER = new ObjectPropertyMapper();
    private final EntityMapper<OWLDataProperty> DP_MAPPER = new DataPropertyMapper();
    private final EntityMapper<OWLDatatype> DT_MAPPER = new DatatypeMapper();
    private final EntityMapper<OWLClass> CLASS_MAPPER = new ClassMapper();

    private static Version createVersion() {
        String versionString = VersionInfo.getInstance().getVersionString();
        String[] versionNumbers = versionString.split("\\.");
        int major = PelletReasoner.parseNumberIfExists(versionNumbers, 0);
        int minor = PelletReasoner.parseNumberIfExists(versionNumbers, 1);
        int patch = PelletReasoner.parseNumberIfExists(versionNumbers, 2);
        int build = PelletReasoner.parseNumberIfExists(versionNumbers, 3);
        return new Version(major, minor, patch, build);
    }

    private static int parseNumberIfExists(String[] numbers, int index) {
        try {
            if (0 <= index && index < numbers.length) {
                return Integer.parseInt(numbers[index]);
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.FINE, "Invalid number in version identifier: " + numbers[index], e);
        }
        return 0;
    }

    private static IRI iri(ATermAppl term) {
        if (term.getArity() != 0) {
            throw new OWLRuntimeException("Trying to convert an anonymous term " + term);
        }
        return IRI.create((String)term.getName());
    }

    public PelletReasoner(OWLOntology ontology, BufferingMode bufferingMode) {
        this(ontology, (OWLReasonerConfiguration)new SimpleConfiguration((ReasonerProgressMonitor)new NullReasonerProgressMonitor(), PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW, 0L, IndividualNodeSetPolicy.BY_SAME_AS), bufferingMode);
    }

    public PelletReasoner(OWLOntology ontology, OWLReasonerConfiguration config, BufferingMode bufferingMode) throws IllegalConfigurationException {
        this.individualNodeSetPolicy = config.getIndividualNodeSetPolicy();
        if (!this.getFreshEntityPolicy().equals((Object)config.getFreshEntityPolicy())) {
            throw new IllegalConfigurationException("PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING conflicts with reasoner configuration", config);
        }
        this.ontology = ontology;
        this.monitor = config.getProgressMonitor();
        this.kb = new KnowledgeBase();
        this.kb.setTaxonomyBuilderProgressMonitor((ProgressMonitor)new ProgressAdapter(this.monitor));
        if (config.getTimeOut() > 0L) {
            this.kb.timers.mainTimer.setTimeout(config.getTimeOut());
        }
        this.manager = ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.visitor = new PelletVisitor(this.kb);
        this.bufferingMode = bufferingMode;
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.shouldRefresh = true;
        this.pendingChanges = new ArrayList<OWLOntologyChange>();
        this.refresh();
    }

    private PelletRuntimeException convert(PelletRuntimeException e) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (e instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (e instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)e);
        }
        if (e instanceof org.mindswap.pellet.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
        if (e instanceof UndefinedEntityException) {
            Set unknown = Collections.emptySet();
            throw new FreshEntitiesException(unknown);
        }
        return e;
    }

    public void dispose() {
        this.kb = null;
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public void flush() {
        this.processChanges(this.pendingChanges);
        this.pendingChanges.clear();
        this.refreshCheck();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getUnsatisfiableClasses();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.BOTTOM_DATA_PROPERTY));
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.BOTTOM_OBJECT_PROPERTY));
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl some = ATermUtils.makeSomeValues((ATerm)this.term((OWLObject)pe), (ATerm)ATermUtils.TOP_LIT);
            Set equivalents = this.kb.getEquivalentClasses(some);
            if (direct && !equivalents.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(equivalents));
            }
            Set result = this.kb.getSuperClasses(some, direct);
            if (!equivalents.isEmpty()) {
                result.add(equivalents);
            }
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this.kb.getDataPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Set<OWLLiteral> getAnnotationPropertyValues(OWLNamedIndividual ind, OWLAnnotationProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this.kb.getPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getDifferents(this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set disjoints = this.kb.getDisjointClasses(this.term((OWLObject)ce));
            return this.toClassNodeSet(disjoints);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set val : this.kb.getDisjointProperties(this.term((OWLObject)pe))) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> values = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set val : this.kb.getDisjointProperties(this.term((OWLObject)pe))) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this.kb.getAllEquivalentClasses(this.term((OWLObject)ce)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<ATermAppl> individuals) {
        HashSet<Node<OWLNamedIndividual>> instances = new HashSet<Node<OWLNamedIndividual>>();
        HashSet seen = new HashSet();
        for (ATermAppl ind : individuals) {
            if (seen.contains(ind)) continue;
            Set equiv = this.kb.getAllSames(ind);
            instances.add(this.toIndividualNode(equiv));
            seen.addAll(equiv);
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<ATermAppl> individuals) {
        HashSet<Node<OWLNamedIndividual>> instances = new HashSet<Node<OWLNamedIndividual>>();
        for (ATermAppl ind : individuals) {
            for (ATermAppl equiv : this.kb.getAllSames(ind)) {
                instances.add(this.toIndividualNode(equiv));
            }
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<ATermAppl> individuals) {
        if (IndividualNodeSetPolicy.BY_NAME.equals((Object)this.individualNodeSetPolicy)) {
            return this.getIndividualNodeSetByName(individuals);
        }
        if (IndividualNodeSetPolicy.BY_SAME_AS.equals((Object)this.individualNodeSetPolicy)) {
            return this.getIndividualNodeSetBySameAs(individuals);
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this.individualNodeSetPolicy));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getInstances(this.term((OWLObject)ce), direct));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this.kb.getInverses((ATerm)this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl some = ATermUtils.makeSomeValues((ATerm)this.term((OWLObject)pe), (ATerm)ATermUtils.TOP);
            Set equivalents = this.kb.getEquivalentClasses(some);
            if (direct && !equivalents.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(equivalents));
            }
            Set result = this.kb.getSuperClasses(some, direct);
            if (!equivalents.isEmpty()) {
                result.add(equivalents);
            }
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl some = ATermUtils.makeSomeValues((ATerm)ATermUtils.makeInv((ATermAppl)this.term((OWLObject)pe)), (ATerm)ATermUtils.TOP);
            Set equivalents = this.kb.getEquivalentClasses(some);
            if (direct && !equivalents.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(equivalents));
            }
            Set result = this.kb.getSuperClasses(some, direct);
            if (!equivalents.isEmpty()) {
                result.add(equivalents);
            }
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getObjectPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.pendingChanges;
    }

    public String getReasonerName() {
        return PelletReasonerFactory.getInstance().getReasonerName();
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    public OWLOntology getRootOntology() {
        return this.ontology;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toIndividualNode(this.kb.getAllSames(this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set result = this.kb.getSubClasses(this.term((OWLObject)ce), direct);
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set val : this.kb.getSubProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> values = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set val : this.kb.getSubProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set result = this.kb.getSuperClasses(this.term((OWLObject)ce), direct);
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set val : this.kb.getSuperProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> values = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set val : this.kb.getSuperProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public long getTimeOut() {
        return this.kb.timers.mainTimer.getTimeout();
    }

    public Node<OWLClass> getTopClassNode() {
        this.refreshCheck();
        return this.toClassNode(this.kb.getAllEquivalentClasses(ATermUtils.TOP));
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.TOP_DATA_PROPERTY));
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.TOP_OBJECT_PROPERTY));
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set result = this.kb.getTypes(this.term((OWLObject)ind), direct);
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this.kb.getAllUnsatisfiableClasses());
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public void interrupt() {
        this.kb.timers.interrupt();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.kb.isConsistent();
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.isEntailed(Collections.singleton(axiom));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axioms);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !EntailmentChecker.UNSUPPORTED_ENTAILMENT.contains(axiomType);
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.kb.isSatisfiable(this.term((OWLObject)classExpression));
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        switch (this.bufferingMode) {
            case BUFFERING: {
                this.pendingChanges.addAll(changes);
                break;
            }
            case NON_BUFFERING: {
                this.processChanges(changes);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected buffering mode: " + this.bufferingMode));
            }
        }
    }

    public boolean processChanges(List<? extends OWLOntologyChange> changes) {
        if (this.shouldRefresh) {
            return false;
        }
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (log.isLoggable(Level.FINER)) {
                log.fine("Changed: " + oWLOntologyChange + " in " + oWLOntologyChange.getOntology());
            }
            if (!this.importsClosure.contains(oWLOntologyChange.getOntology()) || this.changeVisitor.process(oWLOntologyChange)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Reload required by ontology change " + oWLOntologyChange);
            }
            this.shouldRefresh = true;
            break;
        }
        return !this.shouldRefresh;
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        if (this.kb.isConsistent()) {
            this.kb.realize();
        }
    }

    public void refresh() {
        this.visitor.clear();
        this.kb.clear();
        this.importsClosure = this.ontology.getImportsClosure();
        this.visitor.setAddAxiom(true);
        for (OWLOntology ont : this.importsClosure) {
            ont.accept((OWLObjectVisitor)this.visitor);
        }
        this.visitor.verify();
        this.shouldRefresh = false;
    }

    private void refreshCheck() {
        if (this.kb == null) {
            throw new OWLRuntimeException("Trying to use a disposed reasoner");
        }
        if (this.shouldRefresh) {
            this.refresh();
        }
    }

    public ATermAppl term(OWLObject d) {
        this.refreshCheck();
        this.visitor.reset();
        this.visitor.setAddAxiom(false);
        d.accept((OWLObjectVisitor)this.visitor);
        ATermAppl a = this.visitor.result();
        if (a == null) {
            throw new InternalReasonerException("Cannot create ATerm from description " + d);
        }
        return a;
    }

    private NodeSet<OWLClass> toClassNodeSet(Set<Set<ATermAppl>> termSets) {
        HashSet<Node<OWLClass>> nodes = new HashSet<Node<OWLClass>>();
        for (Set<ATermAppl> termSet : termSets) {
            nodes.add(this.toClassNode(termSet));
        }
        return new OWLClassNodeSet(nodes);
    }

    private Node<OWLClass> toClassNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLClassNode(this.CLASS_MAPPER.map(terms));
    }

    private Node<OWLDataProperty> toDataPropertyNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLDataPropertyNode(this.DP_MAPPER.map(terms));
    }

    private Node<OWLNamedIndividual> toIndividualNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLNamedIndividualNode(this.IND_MAPPER.map(terms));
    }

    private Set<OWLLiteral> toLiteralSet(Collection<ATermAppl> terms) {
        return this.LIT_MAPPER.map(terms);
    }

    private Node<OWLObjectPropertyExpression> toObjectPropertyNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLObjectPropertyNode(this.OP_MAPPER.map(terms));
    }

    private Node<OWLNamedIndividual> toIndividualNode(ATermAppl term) {
        return NodeFactory.getOWLNamedIndividualNode((OWLNamedIndividual)this.IND_MAPPER.map(term));
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return PRECOMPUTABLE_INFERENCES;
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.kb.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this.kb.isRealized();
            }
            case OBJECT_PROPERTY_HIERARCHY: {
                return this.kb.getRBox().isObjectTaxonomyPrepared();
            }
            case DATA_PROPERTY_HIERARCHY: {
                return this.kb.getRBox().isDataTaxonomyPrepared();
            }
        }
        return false;
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypes) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    this.kb.classify();
                }
                case CLASS_ASSERTIONS: {
                    this.kb.realize();
                }
                case OBJECT_PROPERTY_HIERARCHY: {
                    this.kb.getRBox().getObjectTaxonomy();
                }
                case DATA_PROPERTY_HIERARCHY: {
                    this.kb.getRBox().getDataTaxonomy();
                }
            }
        }
    }

    private class ObjectPropertyMapper
    extends EntityMapper<OWLObjectPropertyExpression> {
        private ObjectPropertyMapper() {
        }

        @Override
        public OWLObjectPropertyExpression map(ATermAppl term) {
            if (ATermUtils.TOP_OBJECT_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLTopObjectProperty();
            }
            if (ATermUtils.BOTTOM_OBJECT_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLBottomObjectProperty();
            }
            if (ATermUtils.isInv((ATermAppl)term)) {
                return PelletReasoner.this.factory.getOWLObjectInverseOf((OWLObjectPropertyExpression)PelletReasoner.this.OP_MAPPER.map(term));
            }
            return PelletReasoner.this.factory.getOWLObjectProperty(PelletReasoner.iri(term));
        }
    }

    private class NamedIndividualMapper
    extends EntityMapper<OWLNamedIndividual> {
        private NamedIndividualMapper() {
        }

        @Override
        public OWLNamedIndividual map(ATermAppl term) {
            if (ATermUtils.isBnode((ATermAppl)term)) {
                return null;
            }
            return PelletReasoner.this.factory.getOWLNamedIndividual(PelletReasoner.iri(term));
        }
    }

    private class LiteralMapper
    extends EntityMapper<OWLLiteral> {
        private LiteralMapper() {
        }

        @Override
        public OWLLiteral map(ATermAppl term) {
            String lexValue = ((ATermAppl)term.getArgument(0)).getName();
            ATermAppl lang = (ATermAppl)term.getArgument(1);
            ATermAppl dtype = (ATermAppl)term.getArgument(2);
            if (dtype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
                if (lang.equals(ATermUtils.EMPTY)) {
                    return PelletReasoner.this.factory.getOWLLiteral(lexValue);
                }
                return PelletReasoner.this.factory.getOWLLiteral(lexValue, lang.toString());
            }
            OWLDatatype datatype = (OWLDatatype)PelletReasoner.this.DT_MAPPER.map(dtype);
            return PelletReasoner.this.factory.getOWLLiteral(lexValue, datatype);
        }
    }

    private abstract class EntityMapper<T extends OWLObject> {
        private EntityMapper() {
        }

        public abstract T map(ATermAppl var1);

        public final Set<T> map(Collection<ATermAppl> terms) {
            HashSet<T> mappedSet = new HashSet<T>();
            for (ATermAppl term : terms) {
                T mapped = this.map(term);
                if (mapped == null) continue;
                mappedSet.add(mapped);
            }
            return mappedSet;
        }
    }

    private class DatatypeMapper
    extends EntityMapper<OWLDatatype> {
        private DatatypeMapper() {
        }

        @Override
        public OWLDatatype map(ATermAppl term) {
            return PelletReasoner.this.factory.getOWLDatatype(PelletReasoner.iri(term));
        }
    }

    private class DataPropertyMapper
    extends EntityMapper<OWLDataProperty> {
        private DataPropertyMapper() {
        }

        @Override
        public OWLDataProperty map(ATermAppl term) {
            if (ATermUtils.TOP_DATA_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLTopDataProperty();
            }
            if (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLBottomDataProperty();
            }
            return PelletReasoner.this.factory.getOWLDataProperty(PelletReasoner.iri(term));
        }
    }

    private class ClassMapper
    extends EntityMapper<OWLClass> {
        private ClassMapper() {
        }

        @Override
        public OWLClass map(ATermAppl term) {
            if (term.equals(ATermUtils.TOP)) {
                return PelletReasoner.this.factory.getOWLThing();
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                return PelletReasoner.this.factory.getOWLNothing();
            }
            return PelletReasoner.this.factory.getOWLClass(PelletReasoner.iri(term));
        }
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private boolean reloadRequired;

        private ChangeVisitor() {
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }

        public boolean process(OWLOntologyChange change) {
            this.reset();
            change.accept((OWLOntologyChangeVisitor)this);
            return !this.isReloadRequired();
        }

        public void reset() {
            PelletReasoner.this.visitor.reset();
            this.reloadRequired = false;
        }

        public void visit(AddAxiom change) {
            PelletReasoner.this.visitor.setAddAxiom(true);
            change.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this.visitor);
            this.reloadRequired = PelletReasoner.this.visitor.isReloadRequired();
        }

        public void visit(RemoveAxiom change) {
            PelletReasoner.this.visitor.setAddAxiom(false);
            change.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this.visitor);
            this.reloadRequired = PelletReasoner.this.visitor.isReloadRequired();
        }

        public void visit(AddImport change) {
            this.reloadRequired = true;
        }

        public void visit(AddOntologyAnnotation change) {
        }

        public void visit(RemoveImport change) {
            this.reloadRequired = true;
        }

        public void visit(RemoveOntologyAnnotation change) {
        }

        public void visit(SetOntologyID change) {
        }
    }
}

