/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class ConceptConverter
extends ATermBaseVisitor
implements ATermVisitor {
    private KnowledgeBase kb;
    private OWLDataFactory factory;
    private OWLObject obj;
    private Set set;

    public ConceptConverter(KnowledgeBase kb, OWLDataFactory factory) {
        this.kb = kb;
        this.factory = factory;
    }

    public OWLIndividual convertIndividual(ATermAppl term) {
        IRI iri = null;
        if (!ATermUtils.isBnode((ATermAppl)term)) {
            iri = IRI.create((String)term.getName());
        }
        if (this.kb.isIndividual((ATerm)term)) {
            if (ATermUtils.isBnode((ATermAppl)term)) {
                return this.factory.getOWLAnonymousIndividual(((ATermAppl)term.getArgument(0)).getName());
            }
            return this.factory.getOWLNamedIndividual(iri);
        }
        throw new InternalReasonerException("Cannot convert individual: " + term);
    }

    public OWLObject convert(ATermAppl term) {
        this.obj = null;
        this.visit(term);
        return this.obj;
    }

    public OWLObject getResult() {
        return this.obj;
    }

    public void visitTerm(ATermAppl term) {
        this.obj = null;
        IRI iri = null;
        if (!ATermUtils.isBnode((ATermAppl)term)) {
            iri = IRI.create((String)term.getName());
        }
        if (term.equals(OWL_THING)) {
            this.obj = this.factory.getOWLThing();
        } else if (term.equals(OWL_NOTHING)) {
            this.obj = this.factory.getOWLNothing();
        } else if (this.kb.isClass((ATerm)term)) {
            this.obj = this.factory.getOWLClass(iri);
        } else if (this.kb.isObjectProperty((ATerm)term)) {
            this.obj = ATermUtils.TOP_OBJECT_PROPERTY.equals(term) ? this.factory.getOWLTopDataProperty() : (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term) ? this.factory.getOWLBottomObjectProperty() : this.factory.getOWLObjectProperty(iri));
        } else if (this.kb.isDatatypeProperty((ATerm)term)) {
            this.obj = ATermUtils.TOP_DATA_PROPERTY.equals(term) ? this.factory.getOWLTopDataProperty() : (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term) ? this.factory.getOWLBottomDataProperty() : this.factory.getOWLDataProperty(iri));
        } else if (this.kb.isIndividual((ATerm)term)) {
            this.obj = ATermUtils.isBnode((ATermAppl)term) ? this.factory.getOWLAnonymousIndividual(((ATermAppl)term.getArgument(0)).getName()) : this.factory.getOWLNamedIndividual(iri);
        } else if (this.kb.isDatatype(term)) {
            this.obj = this.factory.getOWLDatatype(iri);
        }
        if (this.obj == null) {
            throw new InternalReasonerException("Ontology does not contain: " + term);
        }
    }

    public void visitAnd(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        if (this.obj instanceof OWLClassExpression) {
            this.obj = this.factory.getOWLObjectIntersectionOf(this.set);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataIntersectionOf(this.set);
        }
    }

    public void visitOr(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        if (this.obj instanceof OWLClassExpression) {
            this.obj = this.factory.getOWLObjectUnionOf(this.set);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataUnionOf(this.set);
        }
    }

    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        if (this.obj instanceof OWLClassExpression) {
            this.obj = this.factory.getOWLObjectComplementOf((OWLClassExpression)this.obj);
        } else if (this.obj instanceof OWLDataRange) {
            this.obj = this.factory.getOWLDataComplementOf((OWLDataRange)this.obj);
        }
    }

    public void visitSome(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression desc = (OWLClassExpression)this.obj;
            this.obj = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)prop, desc);
        } else {
            OWLDataRange datatype = (OWLDataRange)this.obj;
            this.obj = this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)((OWLDataProperty)prop), datatype);
        }
    }

    public void visitAll(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression desc = (OWLClassExpression)this.obj;
            this.obj = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)prop, desc);
        } else {
            OWLDataRange datatype = (OWLDataRange)this.obj;
            this.obj = this.factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)((OWLDataProperty)prop), datatype);
        }
    }

    public void visitMin(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression c = (OWLClassExpression)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLObjectMinCardinality(cardinality, (OWLObjectPropertyExpression)prop, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLDataMinCardinality(cardinality, (OWLDataPropertyExpression)((OWLDataProperty)prop), d);
        }
    }

    public void visitCard(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression c = (OWLClassExpression)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLObjectExactCardinality(cardinality, (OWLObjectPropertyExpression)prop, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLDataExactCardinality(cardinality, (OWLDataPropertyExpression)((OWLDataProperty)prop), d);
        }
    }

    public void visitMax(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        int cardinality = Integer.parseInt(term.getArgument(1).toString());
        if (prop instanceof OWLObjectPropertyExpression) {
            OWLClassExpression c = (OWLClassExpression)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLObjectMaxCardinality(cardinality, (OWLObjectPropertyExpression)prop, c);
        } else {
            OWLDataRange d = (OWLDataRange)this.convert((ATermAppl)term.getArgument(2));
            this.obj = this.factory.getOWLDataMaxCardinality(cardinality, (OWLDataPropertyExpression)((OWLDataProperty)prop), d);
        }
    }

    public void visitHasValue(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLPropertyExpression prop = (OWLPropertyExpression)this.obj;
        if (prop instanceof OWLObjectProperty) {
            OWLIndividual ind = this.convertIndividual((ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0));
            this.obj = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)prop, ind);
        } else {
            this.visit((ATermAppl)((ATermAppl)term.getArgument(1)).getArgument(0));
            OWLLiteral dataVal = (OWLLiteral)this.obj;
            this.obj = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)((OWLDataProperty)prop), dataVal);
        }
    }

    public void visitValue(ATermAppl term) {
        ATermAppl nominal = (ATermAppl)term.getArgument(0);
        if (ATermUtils.isLiteral((ATermAppl)nominal)) {
            this.visitLiteral(nominal);
            this.obj = this.factory.getOWLDataOneOf(new OWLLiteral[]{(OWLLiteral)this.obj});
        } else {
            this.obj = this.factory.getOWLObjectOneOf(new OWLIndividual[]{this.convertIndividual(nominal)});
        }
    }

    public void visitSelf(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.obj;
        this.obj = this.factory.getOWLObjectHasSelf(prop);
    }

    public void visitOneOf(ATermAppl term) {
        ATermList list = (ATermList)term.getArgument(0);
        if (ATermUtils.isLiteral((ATermAppl)((ATermAppl)((ATermAppl)list.getFirst()).getArgument(0)))) {
            HashSet<OWLLiteral> set = new HashSet<OWLLiteral>();
            while (!list.isEmpty()) {
                ATermAppl first = (ATermAppl)list.getFirst();
                if (!ATermUtils.isLiteral((ATermAppl)((ATermAppl)first.getArgument(0)))) {
                    throw new InternalReasonerException("Conversion error, expecting literal but found: " + first);
                }
                this.visitLiteral((ATermAppl)first.getArgument(0));
                set.add((OWLLiteral)this.obj);
                list = list.getNext();
            }
            this.obj = this.factory.getOWLDataOneOf(set);
        } else {
            HashSet<OWLIndividual> set = new HashSet<OWLIndividual>();
            while (!list.isEmpty()) {
                ATermAppl first = (ATermAppl)list.getFirst();
                OWLIndividual ind = this.convertIndividual((ATermAppl)first.getArgument(0));
                set.add(ind);
                list = list.getNext();
            }
            this.obj = this.factory.getOWLObjectOneOf(set);
        }
    }

    public void visitLiteral(ATermAppl term) {
        String lexValue = ((ATermAppl)term.getArgument(0)).toString();
        ATermAppl lang = (ATermAppl)term.getArgument(1);
        ATermAppl dtype = (ATermAppl)term.getArgument(2);
        if (dtype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            this.obj = lang.equals(ATermUtils.EMPTY) ? this.factory.getOWLStringLiteral(lexValue) : this.factory.getOWLStringLiteral(lexValue, lang.toString());
        } else {
            IRI dtypeIRI = IRI.create((String)dtype.toString());
            OWLDatatype datatype = this.factory.getOWLDatatype(dtypeIRI);
            this.obj = this.factory.getOWLTypedLiteral(lexValue, datatype);
        }
    }

    public void visitList(ATermList list) {
        this.set = null;
        HashSet<OWLObject> elements = new HashSet<OWLObject>();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            if (this.obj == null) {
                return;
            }
            elements.add(this.obj);
            list = list.getNext();
        }
        this.set = elements;
    }

    public void visitInverse(ATermAppl p) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.convert((ATermAppl)p.getArgument(0));
        this.obj = this.factory.getOWLObjectInverseOf(prop);
    }

    public void visitRestrictedDatatype(ATermAppl dt) {
        OWLDatatype baseDatatype = this.factory.getOWLDatatype(IRI.create((String)((ATermAppl)dt.getArgument(0)).getName()));
        HashSet<OWLFacetRestriction> restrictions = new HashSet<OWLFacetRestriction>();
        ATermList list = (ATermList)dt.getArgument(1);
        while (!list.isEmpty()) {
            ATermAppl facet = (ATermAppl)list.getFirst();
            String facetName = ((ATermAppl)facet.getArgument(0)).getName();
            ATermAppl facetValue = (ATermAppl)facet.getArgument(1);
            this.visitLiteral(facetValue);
            restrictions.add(this.factory.getOWLFacetRestriction(OWLFacet.getFacet((IRI)IRI.create((String)facetName)), (OWLLiteral)this.obj));
            list = list.getNext();
        }
        this.obj = this.factory.getOWLDatatypeRestriction(baseDatatype, restrictions);
    }
}

