/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import org.mindswap.pellet.jena.PelletReasoner;

public class PelletReasonerFactory
implements ReasonerFactory {
    private static final String URI = "http://pellet.owldl.com";
    private static PelletReasonerFactory theInstance = new PelletReasonerFactory();
    public static OntModelSpec THE_SPEC = new OntModelSpec(OntModelSpec.OWL_MEM);
    private Model reasonerCapabilities;

    public static PelletReasonerFactory theInstance() {
        return theInstance;
    }

    private PelletReasonerFactory() {
    }

    public Reasoner create() {
        return new PelletReasoner(this.getCapabilities());
    }

    public Reasoner create(Resource configuration) {
        return new PelletReasoner(this.getCapabilities());
    }

    public Model getCapabilities() {
        if (this.reasonerCapabilities == null) {
            this.reasonerCapabilities = ModelFactory.createDefaultModel();
            Resource base = this.reasonerCapabilities.createResource(URI);
            base.addProperty(ReasonerVocabulary.nameP, "Pellet Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Reasoner that is backed by the OWL DL reasoner Pellet.").addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.member).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.range).addProperty(ReasonerVocabulary.supportsP, (RDFNode)RDFS.domain).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.individualAsThingP).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directSubPropertyOf).addProperty(ReasonerVocabulary.supportsP, (RDFNode)ReasonerVocabulary.directRDFType);
        }
        return this.reasonerCapabilities;
    }

    public String getURI() {
        return URI;
    }

    static {
        THE_SPEC.setReasonerFactory((ReasonerFactory)theInstance);
        ReasonerRegistry.theRegistry().register((ReasonerFactory)PelletReasonerFactory.theInstance());
    }
}

