/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.FlattenningIterator;
import org.mindswap.pellet.utils.iterator.MultiIterator;

public class IteratorUtils {
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static <T> Iterator<T> concat(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        return new MultiIterator<T>(i1, i2);
    }

    public static final <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static final <T> Iterator<T> singletonIterator(T element) {
        return new SingletonIterator(element);
    }

    public static <T> Set<T> toSet(Iterator<T> i) {
        HashSet<T> set = new HashSet<T>();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> List<T> toList(Iterator<T> i) {
        ArrayList<T> set = new ArrayList<T>();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> Iterator<T> flatten(Iterator<? extends Iterable<T>> iterator) {
        return new FlattenningIterator(iterator);
    }

    public static <T> Iterator<T> singleton(T element) {
        return IteratorUtils.iterator(element);
    }

    public static <T> Iterator<T> iterator(final T element) {
        return new Iterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> iterator(T ... elements) {
        return new ArrayIterator<T>(elements, elements.length);
    }

    public static <T> Iterator<T> iterator(int size, T ... elements) {
        return new ArrayIterator<T>(elements, size);
    }

    private static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] array;
        private int size;
        private int curr = 0;

        public ArrayIterator(E[] array, int size) {
            this.array = array;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.curr != this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.curr++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonIterator<T>
    implements Iterator<T> {
        private T element;
        private boolean consumed;

        private SingletonIterator(T element) {
            this.element = element;
            this.consumed = false;
        }

        @Override
        public boolean hasNext() {
            return !this.consumed;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.consumed = true;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

