/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.intset.BitIntSet;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class ShiftedBitIntSet
extends BitIntSet {
    private int min = Integer.MAX_VALUE;

    public ShiftedBitIntSet() {
    }

    public ShiftedBitIntSet(ShiftedBitIntSet other) {
        super(other);
        this.min = other.min;
    }

    @Override
    public void add(int value) {
        if (this.isEmpty()) {
            this.min = value;
            super.add(0);
        } else if (value >= this.min) {
            super.add(value - this.min);
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    @Override
    public boolean contains(int value) {
        if (value >= this.min) {
            return super.contains(value - this.min);
        }
        return false;
    }

    @Override
    public IntSet copy() {
        return new ShiftedBitIntSet(this);
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private IntIterator base;
            {
                this.base = ShiftedBitIntSet.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public int next() {
                return ShiftedBitIntSet.this.min + this.base.next();
            }
        };
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.min + super.max();
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.min;
    }

    @Override
    public void remove(int value) {
        if (value >= this.min) {
            super.remove(value - this.min);
            this.min = super.min();
        }
    }
}

