/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigDecimal;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDDateTime
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace DATE_TIME_VALUE_SPACE;
    public static XSDDateTime instance;

    protected XSDDateTime(ATermAppl name) {
        super(name, DATE_TIME_VALUE_SPACE);
    }

    @Override
    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDDateTime type = new XSDDateTime(null);
        type.values = intervals;
        return type;
    }

    @Override
    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"dateTime");
            min = (IDateTimeValueType)dt.createValue("-9999-01-01T12:00:00", null);
            max = (IDateTimeValueType)dt.createValue("9999-12-31T12:00:00", null);
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        DATE_TIME_VALUE_SPACE = new DateTimeValueSpace();
        instance = new XSDDateTime(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#dateTime"));
    }

    private static class DateTimeValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public DateTimeValueSpace() {
            super(min, max, dt);
        }

        @Override
        public int count(Object start, Object end) {
            long calendarStart = ((IDateTimeValueType)start).toCalendar().getTimeInMillis();
            long calendarEnd = ((IDateTimeValueType)end).toCalendar().getTimeInMillis();
            long diff = calendarStart - calendarEnd;
            if (calendarStart >= calendarEnd) {
                return 0;
            }
            if (diff > Integer.MAX_VALUE || diff < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)diff;
        }

        @Override
        public Object succ(Object value, int n) {
            BigDecimal bigN = new BigDecimal(String.valueOf(n));
            BigTimeDurationValueType nSeconds = new BigTimeDurationValueType(NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, bigN);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nSeconds);
            return s;
        }
    }
}

