/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.types.real.XSDInteger;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class KRSSLoader
extends KBLoader {
    public static final Logger log = Logger.getLogger(KRSSLoader.class.getName());
    private static final ATermAppl XSD_INTEGER = XSDInteger.getInstance().getName();
    private StreamTokenizer in;
    private KnowledgeBase kb;
    private ArrayList<ATermAppl> terms;
    private Map<ATermAppl, List<ATermAppl>> disjoints;
    private boolean forceUppercase;
    private static final int QUOTE = 124;

    public KRSSLoader() {
        this(new KnowledgeBase());
    }

    public KRSSLoader(KnowledgeBase kb) {
        this.kb = kb;
        this.forceUppercase = false;
    }

    @Override
    public void clear() {
        this.kb.clear();
    }

    public boolean isForceUppercase() {
        return this.forceUppercase;
    }

    public void setForceUppercase(boolean forceUppercase) {
        this.forceUppercase = forceUppercase;
    }

    private void initTokenizer(Reader reader) {
        this.in = new StreamTokenizer(reader);
        this.in.lowerCaseMode(false);
        this.in.commentChar(59);
        this.in.wordChars(47, 47);
        this.in.wordChars(95, 95);
        this.in.wordChars(42, 42);
        this.in.wordChars(63, 63);
        this.in.wordChars(37, 37);
        this.in.wordChars(62, 62);
        this.in.wordChars(60, 60);
        this.in.wordChars(61, 61);
        this.in.quoteChar(124);
    }

    private void skipNext() throws IOException {
        this.in.nextToken();
    }

    private void skipNext(int token) throws IOException {
        ATermUtils.assertTrue(token == this.in.nextToken());
    }

    private void skipNext(String token) throws IOException {
        this.in.nextToken();
        ATermUtils.assertTrue(token.equals(this.in.sval));
    }

    private boolean peekNext(int token) throws IOException {
        int next = this.in.nextToken();
        this.in.pushBack();
        return token == next;
    }

    private String nextString() throws IOException {
        this.in.nextToken();
        switch (this.in.ttype) {
            case -3: 
            case 124: {
                return this.in.sval;
            }
            case -2: {
                return String.valueOf(this.in.nval);
            }
        }
        throw new RuntimeException("Expecting string found " + (char)this.in.ttype);
    }

    private int nextInt() throws IOException {
        this.in.nextToken();
        return (int)this.in.nval;
    }

    private String nextNumber() throws IOException {
        this.in.nextToken();
        String strVal = String.valueOf((long)this.in.nval);
        return strVal;
    }

    private ATermAppl nextTerm() throws IOException {
        String token = this.nextString();
        if (this.forceUppercase) {
            token = token.toUpperCase();
        }
        return ATermUtils.makeTermAppl(token);
    }

    private ATermAppl[] parseExprList() throws IOException {
        int count = 0;
        while (this.peekNext(40)) {
            this.skipNext();
            ++count;
        }
        ArrayList<ATermAppl> terms = new ArrayList<ATermAppl>();
        while (true) {
            if (this.peekNext(41)) {
                if (count == 0) break;
                this.skipNext();
                if (--count != 0) continue;
                break;
            }
            if (this.peekNext(40)) {
                this.skipNext();
                ++count;
                continue;
            }
            terms.add(this.parseExpr());
        }
        return terms.toArray(new ATermAppl[terms.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ATermAppl parseExpr() throws IOException {
        int n;
        ATermAppl a = null;
        int token = this.in.nextToken();
        String s = this.in.sval;
        if (token == -3 || token == 124) {
            if (s.equalsIgnoreCase("TOP")) return ATermUtils.TOP;
            if (s.equalsIgnoreCase("*TOP*")) return ATermUtils.TOP;
            if (s.equalsIgnoreCase(":TOP")) {
                return ATermUtils.TOP;
            }
            if (s.equalsIgnoreCase("BOTTOM")) return ATermUtils.BOTTOM;
            if (s.equalsIgnoreCase("*BOTTOM*")) {
                return ATermUtils.BOTTOM;
            }
            if (!this.forceUppercase) return ATermUtils.makeTermAppl(s);
            s = s.toUpperCase();
            return ATermUtils.makeTermAppl(s);
        }
        if (token == -2) {
            return ATermUtils.makeTermAppl(String.valueOf(this.in.nval));
        }
        if (token == 58) {
            s = this.nextString();
            if (s.equalsIgnoreCase("TOP")) {
                return ATermUtils.TOP;
            }
            if (!s.equalsIgnoreCase("BOTTOM")) throw new RuntimeException("Parse exception after ':' " + s);
            return ATermUtils.BOTTOM;
        }
        if (token == 40) {
            token = this.in.nextToken();
            ATermUtils.assertTrue(token == -3);
            s = this.in.sval;
            if (s.equalsIgnoreCase("NOT")) {
                ATermAppl c = this.parseExpr();
                a = ATermUtils.makeNot((ATerm)c);
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
            } else if (s.equalsIgnoreCase("AND")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    if (ATermUtils.isPrimitive(c)) {
                        this.kb.addClass(c);
                    }
                    list = list.insert((ATerm)c);
                }
                a = ATermUtils.makeAnd(list);
            } else if (s.equalsIgnoreCase("OR")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    if (ATermUtils.isPrimitive(c)) {
                        this.kb.addClass(c);
                    }
                    list = list.insert((ATerm)c);
                }
                a = ATermUtils.makeOr(list);
            } else if (s.equalsIgnoreCase("ONE-OF")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    this.kb.addIndividual(c);
                    list = list.insert((ATerm)ATermUtils.makeValue((ATerm)c));
                }
                a = ATermUtils.makeOr(list);
            } else if (s.equalsIgnoreCase("ALL")) {
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty((ATerm)r);
                ATermAppl c = this.parseExpr();
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
                a = ATermUtils.makeAllValues((ATerm)r, (ATerm)c);
            } else if (s.equalsIgnoreCase("SOME")) {
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty((ATerm)r);
                ATermAppl c = this.parseExpr();
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
                a = ATermUtils.makeSomeValues((ATerm)r, (ATerm)c);
            } else if (s.equalsIgnoreCase("AT-LEAST") || s.equalsIgnoreCase("ATLEAST")) {
                int n2 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty((ATerm)r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeMin((ATerm)r, n2, (ATerm)c);
            } else if (s.equalsIgnoreCase("AT-MOST") || s.equalsIgnoreCase("ATMOST")) {
                int n3 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty((ATerm)r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeMax((ATerm)r, n3, (ATerm)c);
            } else if (s.equalsIgnoreCase("EXACTLY")) {
                int n4 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty((ATerm)r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeCard((ATerm)r, n4, (ATerm)c);
            } else if (s.equalsIgnoreCase("A")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)r);
                this.kb.addFunctionalProperty(r);
                a = ATermUtils.makeMin((ATerm)r, 1, (ATerm)ATermUtils.TOP_LIT);
            } else if (s.equalsIgnoreCase("MIN") || s.equals(">=")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)r);
                String val = this.nextNumber();
                ATermAppl dr = ATermUtils.makeRestrictedDatatype(XSD_INTEGER, new ATermAppl[]{ATermUtils.makeFacetRestriction(Facet.XSD.MIN_INCLUSIVE.getName(), ATermUtils.makeTypedLiteral(val, XSD_INTEGER))});
                a = ATermUtils.makeAllValues((ATerm)r, (ATerm)dr);
            } else if (s.equalsIgnoreCase("MAX") || s.equals("<=")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)r);
                String val = this.nextNumber();
                ATermAppl dr = ATermUtils.makeRestrictedDatatype(XSD_INTEGER, new ATermAppl[]{ATermUtils.makeFacetRestriction(Facet.XSD.MAX_INCLUSIVE.getName(), ATermUtils.makeTypedLiteral(val, XSD_INTEGER))});
                a = ATermUtils.makeAllValues((ATerm)r, (ATerm)dr);
            } else if (s.equals("=")) {
                ATermAppl r = this.nextTerm();
                this.kb.addDatatypeProperty((ATerm)r);
                String val = this.nextNumber();
                ATermAppl dr = ATermUtils.makeOr(ATermUtils.makeList((ATerm)ATermUtils.makeValue((ATerm)ATermUtils.makeTypedLiteral(val, XSD_INTEGER))));
                a = ATermUtils.makeAllValues((ATerm)r, (ATerm)dr);
            } else {
                if (!s.equalsIgnoreCase("INV")) throw new RuntimeException("Unknown expression " + s);
                ATermAppl r = this.parseExpr();
                this.kb.addObjectProperty((ATerm)r);
                a = this.kb.getProperty((ATerm)r).getInverse().getName();
            }
            if (this.in.nextToken() == 41) return a;
            throw new RuntimeException("Parse exception at term " + s);
        }
        if (token == 35) {
            n = this.nextInt();
            if (this.peekNext(35)) {
                this.skipNext();
                a = this.terms.get(n);
                if (a != null) return a;
                throw new RuntimeException("Parse exception: #" + n + "# is not defined");
            }
            this.skipNext("=");
            a = this.parseExpr();
            while (this.terms.size() <= n) {
                this.terms.add(null);
            }
        } else {
            if (token != -1) throw new RuntimeException("Invalid token");
            return null;
        }
        this.terms.set(n, a);
        return a;
    }

    @Override
    public void parseFile(String fileURI) {
        try {
            InputStream stream = URI.create(fileURI).toURL().openStream();
            this.parse(new InputStreamReader(stream));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void parse(Reader reader) throws IOException {
        this.initTokenizer(reader);
        this.terms = new ArrayList();
        this.disjoints = new HashMap<ATermAppl, List<ATermAppl>>();
        int token = this.in.nextToken();
        while (token != -1) {
            ATermAppl x;
            ATermAppl p;
            ATermAppl p1;
            ATermAppl c;
            if (token == 35) {
                this.in.ordinaryChar(124);
                token = this.in.nextToken();
                while (token != 35) {
                    token = this.in.nextToken();
                }
                this.in.quoteChar(124);
                token = this.in.nextToken();
                if (token == -1) break;
            }
            if (token != 40) {
                throw new RuntimeException("Parsing error: Expecting '(' but found " + this.in);
            }
            String str = this.nextString();
            if (str.equalsIgnoreCase("DEFINE-ROLE") || str.equalsIgnoreCase("DEFINE-PRIMITIVE-ROLE") || str.equalsIgnoreCase("DEFPRIMROLE") || str.equalsIgnoreCase("DEFINE-ATTRIBUTE") || str.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str.equalsIgnoreCase("DEFPRIMATTRIBUTE") || str.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY")) {
                boolean primDef;
                ATermAppl r = this.nextTerm();
                boolean dataProp = str.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY");
                boolean functional = str.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str.equalsIgnoreCase("DEFPRIMATTRIBUTE");
                boolean bl = primDef = str.indexOf("PRIm") != -1;
                if (dataProp) {
                    this.kb.addDatatypeProperty((ATerm)r);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("DEFINE-DATATYPE-ROLE " + r);
                    }
                } else {
                    this.kb.addObjectProperty((ATerm)r);
                    if (functional) {
                        this.kb.addFunctionalProperty(r);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("DEFINE-PRIMITIVE-ATTRIBUTE " + r);
                        }
                    } else if (log.isLoggable(Level.FINE)) {
                        log.fine("DEFINE-PRIMITIVE-ROLE " + r);
                    }
                }
                while (!this.peekNext(41)) {
                    String cmd;
                    if (this.peekNext(58)) {
                        this.skipNext(58);
                        cmd = this.nextString();
                        if (cmd.equalsIgnoreCase("parents")) {
                            ATermAppl s;
                            boolean paren = this.peekNext(40);
                            if (paren) {
                                this.skipNext(40);
                                while (!this.peekNext(41)) {
                                    s = this.nextTerm();
                                    if (s.getName().equals("NIL")) continue;
                                    this.kb.addObjectProperty((ATerm)s);
                                    this.kb.addSubProperty((ATerm)r, s);
                                    if (!log.isLoggable(Level.FINE)) continue;
                                    log.fine("PARENT-ROLE " + r + " " + s);
                                }
                                this.skipNext(41);
                                continue;
                            }
                            s = this.nextTerm();
                            if (s.toString().equalsIgnoreCase("NIL")) continue;
                            this.kb.addObjectProperty((ATerm)s);
                            this.kb.addSubProperty((ATerm)r, s);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("PARENT-ROLE " + r + " " + s);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("feature")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            this.kb.addFunctionalProperty(r);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("FUNCTIONAL-ROLE " + r);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("transitive")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            this.kb.addTransitiveProperty(r);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("TRANSITIVE-ROLE " + r);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("range")) {
                            ATermAppl range = this.parseExpr();
                            this.kb.addClass(range);
                            this.kb.addRange((ATerm)r, range);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("RANGE " + r + " " + range);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("domain")) {
                            ATermAppl domain = this.parseExpr();
                            this.kb.addClass(domain);
                            this.kb.addDomain((ATerm)r, domain);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("DOMAIN " + r + " " + domain);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("inverse")) {
                            ATermAppl inv = this.nextTerm();
                            this.kb.addInverseProperty(r, inv);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("INVERSE " + r + " " + inv);
                            continue;
                        }
                        throw new RuntimeException("Parsing error: Unrecognized keyword in role definition " + cmd);
                    }
                    if (this.peekNext(40)) {
                        this.skipNext(40);
                        cmd = this.nextString();
                        if (cmd.equalsIgnoreCase("domain-range")) {
                            ATermAppl domain = this.nextTerm();
                            ATermAppl range = this.nextTerm();
                            this.kb.addDomain((ATerm)r, domain);
                            this.kb.addRange((ATerm)r, range);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("DOMAIN-RANGE " + r + " " + domain + " " + range);
                            }
                        } else {
                            throw new RuntimeException("Parsing error: Unrecognized keyword in role definition");
                        }
                        this.skipNext(41);
                        continue;
                    }
                    ATermAppl s = this.parseExpr();
                    if (dataProp) {
                        this.kb.addDatatypeProperty((ATerm)s);
                    } else {
                        this.kb.addObjectProperty((ATerm)r);
                    }
                    if (primDef) {
                        this.kb.addSubProperty((ATerm)r, s);
                    } else {
                        this.kb.addEquivalentProperty(r, s);
                    }
                    log.fine("PARENT-ROLE " + r + " " + s);
                }
            } else if (str.equalsIgnoreCase("DEFINE-PRIMITIVE-CONCEPT") || str.equalsIgnoreCase("DEFPRIMCONCEPT")) {
                c = this.nextTerm();
                this.kb.addClass(c);
                ATermAppl expr = null;
                if (!this.peekNext(41) && !(expr = this.parseExpr()).getName().equals("NIL")) {
                    this.kb.addClass(expr);
                    this.kb.addSubClass(c, expr);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINE-PRIMITIVE-CONCEPT " + c + " " + (expr == null ? "" : expr.toString()));
                }
            } else if (str.equalsIgnoreCase("DEFINE-DISJOINT-PRIMITIVE-CONCEPT")) {
                c = this.nextTerm();
                this.kb.addClass(c);
                this.skipNext(40);
                while (!this.peekNext(41)) {
                    ATermAppl expr = this.parseExpr();
                    List<ATermAppl> prevDefinitions = this.disjoints.get(expr);
                    if (prevDefinitions == null) {
                        prevDefinitions = new ArrayList<ATermAppl>();
                    }
                    for (ATermAppl d : prevDefinitions) {
                        this.kb.addDisjointClass(c, d);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("DEFINE-PRIMITIVE-DISJOINT " + c + " " + d);
                    }
                    prevDefinitions.add(c);
                }
                this.skipNext(41);
                ATermAppl expr = this.parseExpr();
                this.kb.addSubClass(c, expr);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINE-PRIMITIVE-CONCEPT " + c + " " + expr);
                }
            } else if (str.equalsIgnoreCase("DEFINE-CONCEPT") || str.equalsIgnoreCase("DEFCONCEPT") || str.equalsIgnoreCase("EQUAL_C")) {
                c = this.nextTerm();
                this.kb.addClass(c);
                ATermAppl expr = this.parseExpr();
                this.kb.addEquivalentClass(c, expr);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINE-CONCEPT " + c + " " + expr);
                }
            } else if (str.equalsIgnoreCase("IMPLIES") || str.equalsIgnoreCase("IMPLIES_C")) {
                ATermAppl c1 = this.parseExpr();
                ATermAppl c2 = this.parseExpr();
                this.kb.addClass(c1);
                this.kb.addClass(c2);
                this.kb.addSubClass(c1, c2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IMPLIES " + c1 + " " + c2);
                }
            } else if (str.equalsIgnoreCase("IMPLIES_R")) {
                p1 = this.parseExpr();
                ATermAppl p2 = this.parseExpr();
                this.kb.addProperty(p1);
                this.kb.addProperty(p2);
                this.kb.addSubProperty((ATerm)p1, p2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IMPLIES_R " + p1 + " " + p2);
                }
            } else if (str.equalsIgnoreCase("EQUAL_R")) {
                p1 = this.parseExpr();
                ATermAppl p2 = this.parseExpr();
                this.kb.addObjectProperty((ATerm)p1);
                this.kb.addObjectProperty((ATerm)p2);
                this.kb.addEquivalentProperty(p1, p2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("EQUAL_R " + p1 + " " + p2);
                }
            } else if (str.equalsIgnoreCase("DOMAIN")) {
                p = this.parseExpr();
                ATermAppl c2 = this.parseExpr();
                this.kb.addProperty(p);
                this.kb.addClass(c2);
                this.kb.addDomain((ATerm)p, c2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DOMAIN " + p + " " + c2);
                }
            } else if (str.equalsIgnoreCase("RANGE")) {
                p = this.parseExpr();
                ATermAppl c3 = this.parseExpr();
                this.kb.addProperty(p);
                this.kb.addClass(c3);
                this.kb.addRange((ATerm)p, c3);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RANGE " + p + " " + c3);
                }
            } else if (str.equalsIgnoreCase("FUNCTIONAL")) {
                p = this.parseExpr();
                this.kb.addProperty(p);
                this.kb.addFunctionalProperty(p);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("FUNCTIONAL " + p);
                }
            } else if (str.equalsIgnoreCase("TRANSITIVE")) {
                p = this.parseExpr();
                this.kb.addObjectProperty((ATerm)p);
                this.kb.addTransitiveProperty(p);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("TRANSITIVE " + p);
                }
            } else if (str.equalsIgnoreCase("DISJOINT")) {
                ATermAppl[] list = this.parseExprList();
                for (int i = 0; i < list.length - 1; ++i) {
                    ATermAppl c1 = list[i];
                    for (int j = i + 1; j < list.length; ++j) {
                        ATermAppl c2 = list[j];
                        this.kb.addClass(c2);
                        this.kb.addDisjointClass(c1, c2);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("DISJOINT " + c1 + " " + c2);
                    }
                }
            } else if (str.equalsIgnoreCase("DEFINDIVIDUAL")) {
                x = this.nextTerm();
                this.kb.addIndividual(x);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DEFINDIVIDUAL " + x);
                }
            } else if (str.equalsIgnoreCase("INSTANCE")) {
                x = this.nextTerm();
                ATermAppl c4 = this.parseExpr();
                this.kb.addIndividual(x);
                this.kb.addType(x, c4);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("INSTANCE " + x + " " + c4);
                }
            } else if (str.equalsIgnoreCase("RELATED")) {
                x = this.nextTerm();
                ATermAppl y = this.nextTerm();
                ATermAppl r = this.nextTerm();
                this.kb.addIndividual(x);
                this.kb.addIndividual(y);
                this.kb.addPropertyValue(r, x, y);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RELATED " + x + " - " + r + " -> " + y);
                }
            } else if (str.equalsIgnoreCase("DIFFERENT")) {
                x = this.nextTerm();
                ATermAppl y = this.nextTerm();
                this.kb.addIndividual(x);
                this.kb.addIndividual(y);
                this.kb.addDifferent(x, y);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DIFFERENT " + x + " " + y);
                }
            } else if (str.equalsIgnoreCase("DATATYPE-ROLE-FILLER")) {
                x = this.nextTerm();
                ATermAppl y = ATermUtils.makePlainLiteral(this.nextString());
                ATermAppl r = this.nextTerm();
                this.kb.addIndividual(x);
                this.kb.addIndividual(y);
                this.kb.addPropertyValue(r, x, y);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DATATYPE-ROLE-FILLER " + x + " - " + r + " -> " + y);
                }
            } else {
                throw new RuntimeException("Parsing error: Unknown command " + str);
            }
            this.skipNext(41);
            token = this.in.nextToken();
        }
    }

    @Override
    public void setIgnoreImports(boolean ignoreImports) {
    }

    public void verifyTBox(String file, KnowledgeBase kb) throws Exception {
        this.initTokenizer(new FileReader(file));
        boolean failed = false;
        int verifiedCount = 0;
        int token = this.in.nextToken();
        while (token != 41 && token != -1) {
            ATermAppl t;
            ATermUtils.assertTrue(token == 40);
            ++verifiedCount;
            ATermAppl c = null;
            if (this.peekNext(40)) {
                ATermAppl[] list = this.parseExprList();
                c = list[0];
                Set<ATermAppl> eqs = kb.getEquivalentClasses(c);
                for (int i = 1; i < list.length; ++i) {
                    ATermAppl t2 = list[i];
                    if (eqs.contains(t2)) continue;
                    log.severe(t2 + " is not equivalent to " + c);
                    failed = true;
                }
            } else {
                c = this.parseExpr();
            }
            Set<ATermAppl> supers = SetUtils.union(kb.getSuperClasses(c, true));
            Set<ATermAppl> subs = SetUtils.union(kb.getSubClasses(c, true));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Verify (" + verifiedCount + ") " + c + " " + supers + " " + subs);
            }
            if (this.peekNext(40)) {
                ATermAppl[] terms = this.parseExprList();
                for (int i = 0; i < terms.length; ++i) {
                    t = terms[i];
                    if (supers.contains(t)) continue;
                    log.severe(t + " is not a superclass of " + c + " ");
                    failed = true;
                }
            } else {
                this.skipNext();
            }
            if (this.peekNext(40)) {
                ATermAppl[] terms = this.parseExprList();
                for (int i = 0; i < terms.length; ++i) {
                    t = terms[i];
                    if (subs.contains(t)) continue;
                    HashSet<ATermAppl> temp = new HashSet<ATermAppl>(subs);
                    Set<ATermAppl> sames = kb.getEquivalentClasses(t);
                    temp.retainAll(sames);
                    if (temp.size() != 0) continue;
                    log.severe(t + " is not a subclass of " + c);
                    failed = true;
                }
            }
            this.skipNext();
            token = this.in.nextToken();
        }
        ATermUtils.assertTrue(this.in.nextToken() == -1);
        if (failed) {
            throw new RuntimeException("Classification results are not correct!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyABox(String file, KnowledgeBase kb) throws Exception {
        boolean longFormat;
        this.initTokenizer(new FileReader(file));
        boolean bl = longFormat = !this.peekNext(40);
        while (!this.peekNext(-1)) {
            boolean isType;
            if (longFormat) {
                this.skipNext("Command");
                this.skipNext(61);
            }
            this.skipNext(40);
            this.skipNext("INDIVIDUAL-INSTANCE?");
            ATermAppl ind = this.nextTerm();
            ATermAppl c = this.parseExpr();
            if (log.isLoggable(Level.FINE)) {
                log.fine("INDIVIDUAL-INSTANCE? " + ind + " " + c);
            }
            this.skipNext(41);
            if (longFormat) {
                this.skipNext(45);
                this.skipNext(62);
                String result = this.nextString();
                if (result.equalsIgnoreCase("T")) {
                    isType = true;
                } else {
                    if (!result.equalsIgnoreCase("NIL")) throw new RuntimeException("Unknown result " + result);
                    isType = false;
                }
            } else {
                isType = true;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(" -> " + isType);
            }
            if (kb.isType(ind, c) == isType) continue;
            throw new RuntimeException("Individual " + ind + " is " + (isType ? "not" : "") + " an instance of " + c);
        }
    }

    @Override
    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public void load() {
    }
}

