/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.ELSyntaxUtils;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class RoleRestrictionCache {
    private Map<ATermAppl, ATermAppl> m_Domains = CollectionUtils.makeMap();
    private Map<ATermAppl, ATermAppl> m_Ranges = CollectionUtils.makeMap();

    public RoleRestrictionCache(RBox rbox) {
        this.prepareDomainsRanges(rbox);
    }

    private void prepareDomainsRanges(RBox rbox) {
        for (Role role : rbox.getRoles()) {
            Iterator<ATermAppl> assertedRanges;
            Iterator<ATermAppl> assertedDomains = rbox.getAssertedDomains(role);
            if (assertedDomains.hasNext()) {
                RoleRestrictionCache.addTo(this.m_Domains, role.getName(), IteratorUtils.toSet(assertedDomains));
            }
            if (!(assertedRanges = rbox.getAssertedRanges(role)).hasNext()) continue;
            RoleRestrictionCache.addTo(this.m_Ranges, role.getName(), IteratorUtils.toSet(assertedRanges));
        }
    }

    private static void addTo(Map<ATermAppl, ATermAppl> map, ATermAppl roleName, Set<ATermAppl> asserted) {
        if (asserted.isEmpty()) {
            return;
        }
        ATermAppl range = null;
        range = asserted.size() == 1 ? asserted.iterator().next() : ATermUtils.makeAnd(ATermUtils.toSet(asserted));
        range = ELSyntaxUtils.simplify(ATermUtils.nnf(range));
        map.put(roleName, range);
    }

    public Map<ATermAppl, ATermAppl> getDomains() {
        return this.m_Domains;
    }

    public Map<ATermAppl, ATermAppl> getRanges() {
        return this.m_Ranges;
    }

    public ATermAppl getDomain(ATermAppl prop) {
        return this.m_Domains.get(prop);
    }

    public ATermAppl getRange(ATermAppl prop) {
        return this.m_Ranges.get(prop);
    }
}

