/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDByte
extends AbstractDerivedIntegerType {
    private static final XSDByte instance = new XSDByte();

    public static XSDByte getInstance() {
        return instance;
    }

    private XSDByte() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#byte"), (byte)-128, (byte)127);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt((String)lexicalForm);
            if (n < -128 || n > 127) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (byte)n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

