/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class RestrictedRealDatatype
implements RestrictedDatatype<Number> {
    private static final Logger log = Logger.getLogger(RestrictedRealDatatype.class.getCanonicalName());
    private final Datatype<? extends Number> datatype;
    private final RestrictedDatatype<Number> empty;
    private final boolean enumerable;
    private final boolean finite;
    private final List<IntegerInterval> intIntervals;
    private final List<ContinuousRealInterval> decimalIntervals;
    private final List<ContinuousRealInterval> rationalIntervals;

    public RestrictedRealDatatype(Datatype<? extends Number> datatype, IntegerInterval ints, ContinuousRealInterval decimals, ContinuousRealInterval rationals) {
        this.datatype = datatype;
        this.empty = new EmptyRestrictedDatatype<Number>(datatype);
        this.intIntervals = ints == null ? Collections.emptyList() : Collections.singletonList(ints);
        this.decimalIntervals = decimals == null ? Collections.emptyList() : Collections.singletonList(decimals);
        this.rationalIntervals = rationals == null ? Collections.emptyList() : Collections.singletonList(rationals);
        this.finite = !(ints != null && !ints.isFinite() || decimals != null && !decimals.isPoint() || rationals != null && !rationals.isPoint());
        this.enumerable = this.finite || decimals == null && rationals == null;
    }

    private RestrictedRealDatatype(RestrictedRealDatatype other, List<IntegerInterval> intIntervals, List<ContinuousRealInterval> decimalIntervals, List<ContinuousRealInterval> rationalIntervals) {
        this.datatype = other.datatype;
        this.empty = other.empty;
        this.intIntervals = intIntervals;
        this.decimalIntervals = decimalIntervals;
        this.rationalIntervals = rationalIntervals;
        if (other.enumerable) {
            this.enumerable = true;
        } else {
            boolean allEnumerable = true;
            block0: for (List l : new List[]{decimalIntervals, rationalIntervals}) {
                if (!allEnumerable) continue;
                for (ContinuousRealInterval i : l) {
                    if (i.isPoint()) continue;
                    allEnumerable = false;
                    continue block0;
                }
            }
            this.enumerable = allEnumerable;
        }
        if (other.finite) {
            this.finite = true;
        } else if (this.enumerable) {
            boolean allFinite = true;
            for (IntegerInterval i : intIntervals) {
                if (i.isFinite()) continue;
                allFinite = false;
                break;
            }
            this.finite = allFinite;
        } else {
            this.finite = false;
        }
    }

    @Override
    public RestrictedDatatype<Number> applyConstrainingFacet(ATermAppl facet, Object value) {
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        Facet f = Facet.Registry.get(facet);
        if (f == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        Number n = null;
        if (value instanceof Number && !OWLRealUtils.acceptable((n = (Number)value).getClass())) {
            n = null;
        }
        if (n == null) {
            String msg = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), f, value);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (Facet.XSD.MAX_EXCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = n;
            inclusiveUpper = false;
        } else if (Facet.XSD.MAX_INCLUSIVE.equals(f)) {
            lower = null;
            inclusiveLower = false;
            upper = n;
            inclusiveUpper = true;
        } else if (Facet.XSD.MIN_EXCLUSIVE.equals(f)) {
            lower = n;
            inclusiveLower = false;
            upper = null;
            inclusiveUpper = false;
        } else if (Facet.XSD.MIN_INCLUSIVE.equals(f)) {
            lower = n;
            inclusiveLower = true;
            upper = null;
            inclusiveUpper = false;
        } else {
            throw new IllegalStateException();
        }
        ContinuousRealInterval continuousRestriction = new ContinuousRealInterval(lower, upper, inclusiveLower, inclusiveUpper);
        IntegerInterval integerRestriction = RestrictedRealDatatype.asIntegerInterval(continuousRestriction);
        boolean changes = false;
        ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>();
        for (IntegerInterval i : this.intIntervals) {
            IntegerInterval j = i.intersection(integerRestriction);
            if (j != null) {
                revisedInts.add(j);
                if (i.equals(j)) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>();
        for (ContinuousRealInterval i : this.decimalIntervals) {
            ContinuousRealInterval j = i.intersection(continuousRestriction);
            if (j != null) {
                revisedDecimals.add(j);
                if (i.equals(j)) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>();
        for (ContinuousRealInterval i : this.rationalIntervals) {
            ContinuousRealInterval j = i.intersection(continuousRestriction);
            if (j != null) {
                revisedRationals.add(j);
                if (i.equals(j)) continue;
                changes = true;
                continue;
            }
            changes = true;
        }
        if (changes) {
            if (revisedInts.isEmpty() && revisedDecimals.isEmpty() && revisedRationals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        return this;
    }

    private static IntegerInterval asIntegerInterval(ContinuousRealInterval continuousRestriction) {
        Number cu;
        Number cl;
        Number lower = continuousRestriction.boundLower() ? (Number)(OWLRealUtils.isInteger(cl = continuousRestriction.getLower()) ? (Number)(continuousRestriction.inclusiveLower() ? (Number)cl : (Number)OWLRealUtils.integerIncrement(cl)) : (Number)OWLRealUtils.roundCeiling(cl)) : (Number)null;
        Number upper = continuousRestriction.boundUpper() ? (Number)(OWLRealUtils.isInteger(cu = continuousRestriction.getUpper()) ? (Number)(continuousRestriction.inclusiveUpper() ? (Number)cu : (Number)OWLRealUtils.integerDecrement(cu)) : (Number)OWLRealUtils.roundFloor(cu)) : (Number)null;
        if (lower != null && upper != null && OWLRealUtils.compare(lower, upper) > 0) {
            return null;
        }
        return new IntegerInterval(lower, upper);
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            if (OWLRealUtils.acceptable(n.getClass())) {
                if (OWLRealUtils.isInteger(n)) {
                    for (IntegerInterval i : this.intIntervals) {
                        if (!i.contains(n)) continue;
                        return true;
                    }
                } else if (OWLRealUtils.isDecimal(n)) {
                    for (ContinuousRealInterval i : this.decimalIntervals) {
                        if (!i.contains(n)) continue;
                        return true;
                    }
                } else if (OWLRealUtils.isRational(n)) {
                    for (ContinuousRealInterval i : this.rationalIntervals) {
                        if (!i.contains(n)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this.finite || n <= 0) {
            return true;
        }
        Number sum = 0;
        for (IntegerInterval integerInterval : this.intIntervals) {
            sum = OWLRealUtils.integerSum(sum, integerInterval.size());
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        for (ContinuousRealInterval continuousRealInterval : this.decimalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        for (ContinuousRealInterval continuousRealInterval : this.rationalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower()) || OWLRealUtils.isRational(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedDatatype<Number> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>(this.intIntervals);
        ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>(this.decimalIntervals);
        ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>(this.rationalIntervals);
        block0: for (Object o : values) {
            ArrayList<ContinuousRealInterval> revised;
            Number n;
            if (!(o instanceof Number) || !OWLRealUtils.acceptable((n = (Number)o).getClass())) continue;
            if (OWLRealUtils.isInteger(n)) {
                Iterator it = revisedInts.iterator();
                while (it.hasNext()) {
                    IntegerInterval greater;
                    IntegerInterval i = (IntegerInterval)it.next();
                    if (!i.contains(n)) continue;
                    changes = true;
                    it.remove();
                    IntegerInterval less = (IntegerInterval)i.less(n);
                    if (less != null) {
                        revisedInts.add(less);
                    }
                    if ((greater = (IntegerInterval)i.greater(n)) == null) continue block0;
                    revisedInts.add(greater);
                    continue block0;
                }
                continue;
            }
            if (OWLRealUtils.isDecimal(n)) {
                revised = revisedDecimals;
            } else if (OWLRealUtils.isRational(n)) {
                revised = revisedRationals;
            } else {
                throw new IllegalStateException();
            }
            Iterator it = revised.iterator();
            while (it.hasNext()) {
                ContinuousRealInterval greater;
                ContinuousRealInterval i = (ContinuousRealInterval)it.next();
                if (!i.contains(n)) continue;
                changes = true;
                it.remove();
                ContinuousRealInterval less = i.less(n);
                if (less != null) {
                    revised.add(less);
                }
                if ((greater = i.greater(n)) == null) continue block0;
                revised.add(greater);
                continue block0;
            }
        }
        if (changes) {
            if (revisedInts.isEmpty() && revisedDecimals.isEmpty() && revisedRationals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        return this;
    }

    @Override
    public Datatype<? extends Number> getDatatype() {
        return this.datatype;
    }

    @Override
    public Number getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<Number> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedRealDatatype) {
            List<ContinuousRealInterval> rationalIntersectWith;
            List<ContinuousRealInterval> decimalIntersectWith;
            List<IntegerInterval> intIntersectWith;
            RestrictedRealDatatype otherRRD = (RestrictedRealDatatype)other;
            ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>();
            ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>();
            ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>();
            if (negated) {
                intIntersectWith = Collections.singletonList(IntegerInterval.allIntegers());
                for (IntegerInterval i : otherRRD.intIntervals) {
                    ArrayList<IntegerInterval> tmp = new ArrayList<IntegerInterval>(2 * intIntersectWith.size());
                    for (IntegerInterval integerInterval : intIntersectWith) {
                        tmp.addAll(integerInterval.remove(i));
                    }
                    intIntersectWith = tmp;
                }
            } else {
                intIntersectWith = otherRRD.intIntervals;
            }
            for (IntegerInterval i : this.intIntervals) {
                for (IntegerInterval j : intIntersectWith) {
                    IntegerInterval integerInterval = i.intersection(j);
                    if (integerInterval == null) continue;
                    revisedInts.add(integerInterval);
                }
            }
            if (negated) {
                decimalIntersectWith = Collections.singletonList(ContinuousRealInterval.allReals());
                for (ContinuousRealInterval i : otherRRD.decimalIntervals) {
                    ArrayList<ContinuousRealInterval> tmp = new ArrayList<ContinuousRealInterval>(2 * decimalIntersectWith.size());
                    for (ContinuousRealInterval j : decimalIntersectWith) {
                        tmp.addAll(j.remove(i));
                    }
                    decimalIntersectWith = tmp;
                }
            } else {
                decimalIntersectWith = otherRRD.decimalIntervals;
            }
            for (ContinuousRealInterval i : this.decimalIntervals) {
                for (ContinuousRealInterval continuousRealInterval : decimalIntersectWith) {
                    ContinuousRealInterval k = i.intersection(continuousRealInterval);
                    if (k == null) continue;
                    revisedDecimals.add(k);
                }
            }
            if (negated) {
                rationalIntersectWith = Collections.singletonList(ContinuousRealInterval.allReals());
                for (ContinuousRealInterval i : otherRRD.rationalIntervals) {
                    ArrayList<ContinuousRealInterval> arrayList = new ArrayList<ContinuousRealInterval>(2 * rationalIntersectWith.size());
                    for (ContinuousRealInterval j : rationalIntersectWith) {
                        arrayList.addAll(j.remove(i));
                    }
                    rationalIntersectWith = arrayList;
                }
            } else {
                rationalIntersectWith = otherRRD.rationalIntervals;
            }
            for (ContinuousRealInterval i : this.rationalIntervals) {
                for (ContinuousRealInterval j : rationalIntersectWith) {
                    ContinuousRealInterval k = i.intersection(j);
                    if (k == null) continue;
                    revisedRationals.add(k);
                }
            }
            if (revisedInts.equals(this.intIntervals) && revisedDecimals.equals(this.decimalIntervals) && revisedRationals.equals(this.rationalIntervals)) {
                return this;
            }
            if (revisedInts.isEmpty() && revisedDecimals.isEmpty() && revisedRationals.isEmpty()) {
                return this.empty;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    @Override
    public int size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        Number sum = 0;
        for (IntegerInterval integerInterval : this.intIntervals) {
            sum = OWLRealUtils.integerSum(sum, integerInterval.size());
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        for (ContinuousRealInterval continuousRealInterval : this.decimalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        for (ContinuousRealInterval continuousRealInterval : this.rationalIntervals) {
            if (OWLRealUtils.isInteger(continuousRealInterval.getLower()) || OWLRealUtils.isRational(continuousRealInterval.getLower())) continue;
            sum = OWLRealUtils.integerIncrement(sum);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return sum.intValue();
    }

    @Override
    public RestrictedDatatype<Number> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedRealDatatype) {
            HashSet<Object> tmp;
            Object j;
            Iterator jt;
            ArrayList<Object> unionWith;
            RestrictedRealDatatype otherRRD = (RestrictedRealDatatype)other;
            ArrayList<IntegerInterval> revisedInts = new ArrayList<IntegerInterval>(this.intIntervals);
            ArrayList<ContinuousRealInterval> revisedDecimals = new ArrayList<ContinuousRealInterval>(this.decimalIntervals);
            ArrayList<ContinuousRealInterval> revisedRationals = new ArrayList<ContinuousRealInterval>(this.rationalIntervals);
            for (IntegerInterval integerInterval : otherRRD.intIntervals) {
                unionWith = new ArrayList<Object>();
                jt = revisedInts.iterator();
                while (jt.hasNext()) {
                    j = (IntegerInterval)jt.next();
                    if (!integerInterval.canUnionWith(j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedInts.add(integerInterval);
                    continue;
                }
                tmp = new HashSet<Object>();
                for (IntegerInterval j2 : unionWith) {
                    tmp.addAll(integerInterval.union(j2));
                }
                revisedInts.addAll(tmp);
            }
            for (ContinuousRealInterval continuousRealInterval : otherRRD.decimalIntervals) {
                unionWith = new ArrayList();
                jt = revisedDecimals.iterator();
                while (jt.hasNext()) {
                    j = (ContinuousRealInterval)jt.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedDecimals.add(continuousRealInterval);
                    continue;
                }
                tmp = new HashSet();
                for (ContinuousRealInterval j2 : unionWith) {
                    tmp.addAll(continuousRealInterval.union(j2));
                }
                revisedDecimals.addAll(tmp);
            }
            for (ContinuousRealInterval continuousRealInterval : otherRRD.rationalIntervals) {
                unionWith = new ArrayList();
                jt = revisedRationals.iterator();
                while (jt.hasNext()) {
                    j = (ContinuousRealInterval)jt.next();
                    if (!continuousRealInterval.canUnionWith((ContinuousRealInterval)j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedRationals.add(continuousRealInterval);
                    continue;
                }
                tmp = new HashSet();
                for (ContinuousRealInterval j2 : unionWith) {
                    tmp.addAll(continuousRealInterval.union(j2));
                }
                revisedRationals.addAll(tmp);
            }
            if (revisedInts.equals(this.intIntervals) && revisedDecimals.equals(this.decimalIntervals) && revisedRationals.equals(this.rationalIntervals)) {
                return this;
            }
            return new RestrictedRealDatatype(this, revisedInts, revisedDecimals, revisedRationals);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Number> valueIterator() {
        if (!this.enumerable) {
            throw new IllegalStateException();
        }
        return new Iterator<Number>(){
            final Iterator<IntegerInterval> intit;
            final Iterator<ContinuousRealInterval> decit;
            final Iterator<ContinuousRealInterval> ratit;
            private Iterator<Number> nit;
            private boolean intOk;
            private boolean decOk;
            private Number next;
            {
                this.intit = RestrictedRealDatatype.this.intIntervals.iterator();
                this.decit = RestrictedRealDatatype.this.decimalIntervals.iterator();
                this.ratit = RestrictedRealDatatype.this.rationalIntervals.iterator();
                this.nit = null;
                this.intOk = true;
                this.decOk = true;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.nit != null && this.nit.hasNext()) {
                        this.next = this.nit.next();
                        if (!this.intOk && OWLRealUtils.isInteger(this.next)) {
                            this.next = null;
                        }
                        if (this.decOk || !OWLRealUtils.isDecimal(this.next)) continue;
                        this.next = null;
                        continue;
                    }
                    if (this.intit.hasNext()) {
                        this.nit = this.intit.next().valueIterator();
                        continue;
                    }
                    this.intOk = false;
                    if (this.decit.hasNext()) {
                        this.nit = this.decit.next().valueIterator();
                        continue;
                    }
                    this.decOk = false;
                    if (this.ratit.hasNext()) {
                        this.nit = this.ratit.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Number next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Number ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return String.format("{%s,%s,%s,%s}", this.datatype, this.intIntervals, this.decimalIntervals, this.rationalIntervals);
    }
}

