/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public abstract class DiscreteInterval<T extends Number, U extends DiscreteInterval<T, U>> {
    protected static final NullSemantics GREATEST;
    protected static final NullSemantics LEAST;
    protected static final NullSemantics NA;
    private static final Logger log;
    protected final T lower;
    protected final T upper;

    public DiscreteInterval(T point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.lower = point;
        this.upper = point;
    }

    public DiscreteInterval(T lower, T upper) {
        if (!this.valid(lower)) {
            throw new IllegalArgumentException();
        }
        if (!this.valid(upper)) {
            throw new IllegalArgumentException();
        }
        int cmp = this.compare(lower, LEAST, upper, GREATEST);
        if (cmp > 0) {
            String msg = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", lower, upper);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.lower = lower;
        this.upper = upper;
    }

    public boolean canUnionWith(U other) {
        int ll = this.compare(this.lower, LEAST, ((DiscreteInterval)other).lower, LEAST);
        int uu = this.compare(this.upper, GREATEST, ((DiscreteInterval)other).upper, GREATEST);
        if (ll <= 0) {
            if (uu < 0) {
                if (this.compare(this.upper, GREATEST, ((DiscreteInterval)other).lower, LEAST) < 0) {
                    return this.equal(this.increment(this.upper), ((DiscreteInterval)other).lower);
                }
                return true;
            }
            return true;
        }
        if (uu > 0) {
            if (this.compare(this.lower, LEAST, ((DiscreteInterval)other).upper, GREATEST) > 0) {
                return this.equal(this.increment(((DiscreteInterval)other).upper), this.lower);
            }
            return true;
        }
        return true;
    }

    protected abstract U cast(DiscreteInterval<T, U> var1);

    protected abstract int compare(T var1, NullSemantics var2, T var3, NullSemantics var4);

    public boolean contains(T n) {
        if (!this.valid(n)) {
            throw new IllegalArgumentException();
        }
        int lcmp = this.compare(this.getLower(), LEAST, n, NA);
        if (lcmp > 0) {
            return false;
        }
        if (lcmp == 0) {
            return true;
        }
        int ucmp = this.compare(this.getUpper(), GREATEST, n, NA);
        return ucmp >= 0;
    }

    protected abstract U create(T var1, T var2);

    protected abstract T decrement(T var1);

    protected abstract boolean equal(T var1, T var2);

    public abstract boolean equals(Object var1);

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public U greater(T n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!this.valid(n)) {
            throw new IllegalArgumentException();
        }
        if (this.compare(this.getLower(), LEAST, n, NA) > 0) {
            return this.cast(this);
        }
        if (this.compare(this.getUpper(), GREATEST, n, NA) <= 0) {
            return null;
        }
        return this.create(this.increment(n), this.getUpper());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lower == null ? 0 : this.lower.hashCode());
        result = 31 * result + (this.upper == null ? 0 : this.upper.hashCode());
        return result;
    }

    protected abstract T increment(T var1);

    public U intersection(U that) {
        int ll = this.compare(this.lower, LEAST, ((DiscreteInterval)that).lower, LEAST);
        int uu = this.compare(this.upper, GREATEST, ((DiscreteInterval)that).upper, GREATEST);
        if (ll <= 0) {
            if (uu < 0) {
                if (this.compare(this.upper, GREATEST, ((DiscreteInterval)that).lower, LEAST) < 0) {
                    return null;
                }
                return this.create(((DiscreteInterval)that).lower, this.upper);
            }
            return that;
        }
        if (uu > 0) {
            if (this.compare(this.lower, LEAST, ((DiscreteInterval)that).upper, GREATEST) > 0) {
                return null;
            }
            return this.create(this.lower, ((DiscreteInterval)that).upper);
        }
        return this.cast(this);
    }

    public boolean isFinite() {
        return this.lower != null && this.upper != null;
    }

    public U less(T n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!this.valid(n)) {
            throw new IllegalArgumentException();
        }
        if (this.compare(this.getUpper(), GREATEST, n, NA) < 0) {
            return this.cast(this);
        }
        if (this.compare(this.getLower(), LEAST, n, NA) >= 0) {
            return null;
        }
        return this.create(this.getLower(), this.decrement(n));
    }

    public List<U> remove(U other) {
        Object after;
        Object before;
        int ll = this.compare(this.lower, LEAST, ((DiscreteInterval)other).lower, LEAST);
        int lu = this.compare(this.lower, LEAST, ((DiscreteInterval)other).upper, GREATEST);
        int ul = this.compare(this.upper, GREATEST, ((DiscreteInterval)other).lower, LEAST);
        int uu = this.compare(this.upper, GREATEST, ((DiscreteInterval)other).upper, GREATEST);
        if (ll < 0) {
            if (ul < 0) {
                before = this.cast(this);
                after = null;
            } else {
                before = this.create(this.lower, this.decrement(((DiscreteInterval)other).lower));
                after = uu <= 0 ? null : this.create(this.increment(((DiscreteInterval)other).upper), this.upper);
            }
        } else if (lu > 0) {
            before = null;
            after = this.cast(this);
        } else if (uu <= 0) {
            before = null;
            after = null;
        } else {
            before = null;
            after = this.create(this.increment(((DiscreteInterval)other).upper), this.upper);
        }
        if (before == null) {
            if (after == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(after);
        }
        if (after == null) {
            return Collections.singletonList(before);
        }
        List<DiscreteInterval> ret = Arrays.asList(before, after);
        return ret;
    }

    public abstract Number size();

    public List<U> union(U other) {
        Object second;
        U first;
        int ll = this.compare(this.lower, LEAST, ((DiscreteInterval)other).lower, LEAST);
        int lu = this.compare(this.lower, LEAST, ((DiscreteInterval)other).upper, GREATEST);
        int ul = this.compare(this.upper, GREATEST, ((DiscreteInterval)other).lower, LEAST);
        int uu = this.compare(this.upper, GREATEST, ((DiscreteInterval)other).upper, GREATEST);
        if (ll < 0) {
            if (ul < 0) {
                first = this.cast(this);
                second = other;
            } else {
                second = null;
                first = uu < 0 ? this.create(this.lower, ((DiscreteInterval)other).upper) : this.cast(this);
            }
        } else if (lu > 0) {
            first = other;
            second = this.cast(this);
        } else {
            second = null;
            first = uu <= 0 ? other : this.create(((DiscreteInterval)other).lower, this.upper);
        }
        if (first == null) {
            if (second == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(second);
        }
        if (second == null) {
            return Collections.singletonList(first);
        }
        List<DiscreteInterval> ret = Arrays.asList(first, second);
        return ret;
    }

    protected abstract boolean valid(T var1);

    public Iterator<T> valueIterator() {
        if (this.lower == null) {
            if (this.upper == null) {
                throw new IllegalStateException();
            }
            return new ValueIterator(this, this.upper, this.lower, false);
        }
        return new ValueIterator(this, this.lower, this.upper, true);
    }

    public String toString() {
        return String.format("[%s,%s]", this.getLower() != null ? this.getLower() : "-Inf", this.getUpper() != null ? this.getUpper() : "+Inf");
    }

    static {
        log = Logger.getLogger(DiscreteInterval.class.getCanonicalName());
        GREATEST = NullSemantics.GREATEST;
        LEAST = NullSemantics.LEAST;
        NA = NullSemantics.NA;
    }

    public class ValueIterator
    implements Iterator<T> {
        private final T last;
        private T next;
        private final boolean increment;
        final /* synthetic */ DiscreteInterval this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ValueIterator(T lower, T upper, boolean increment) {
            this.this$0 = (DiscreteInterval)n;
            if (lower == null) {
                throw new NullPointerException();
            }
            this.next = lower;
            this.last = upper;
            this.increment = increment;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object ret = this.next;
            this.next = this.this$0.upper != null && this.this$0.equal(this.next, this.last) ? null : (this.increment ? this.this$0.increment(this.next) : this.this$0.decrement(this.next));
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static enum NullSemantics {
        GREATEST,
        LEAST,
        NA;

    }
}

