/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class UnaryTBox {
    public static final Logger log = Logger.getLogger(UnaryTBox.class.getName());
    private Map<ATermAppl, List<Unfolding>> unfoldings = CollectionUtils.makeIdentityMap();

    public void add(ATermAppl sub, ATermAppl sup, Set<ATermAppl> explanation) {
        List<Unfolding> list = this.unfoldings.get(sub);
        if (list == null) {
            list = CollectionUtils.makeList();
            this.unfoldings.put(sub, list);
        }
        sup = ATermUtils.normalize(sup);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Add sub: " + ATermUtils.toString(sub) + " < " + ATermUtils.toString(sup));
        }
        list.add(Unfolding.create(sup, explanation));
    }

    public boolean remove(ATermAppl axiom) {
        return false;
    }

    public Iterator<Unfolding> unfold(ATermAppl concept) {
        List<Unfolding> unfoldingList = this.unfoldings.get(concept);
        return unfoldingList == null ? IteratorUtils.emptyIterator() : unfoldingList.iterator();
    }

    public void print(Appendable out) throws IOException {
        for (Map.Entry<ATermAppl, List<Unfolding>> e : this.unfoldings.entrySet()) {
            out.append(ATermUtils.toString(e.getKey()));
            out.append(" < ");
            out.append(e.getValue().toString());
            out.append("\n");
        }
    }
}

