/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;

public class FunctionBuiltIn
implements BuiltIn {
    private Function function;

    public FunctionBuiltIn(Function function) {
        this.function = function;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom atom) {
        return new FunctionHelper(atom);
    }

    private class FunctionHelper
    implements BindingHelper {
        private BuiltInAtom atom;
        private AtomDObject head;
        private Literal value;
        private boolean used;

        public FunctionHelper(BuiltInAtom atom) {
            this.atom = atom;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            AtomDObject head = null;
            for (AtomDObject obj : this.atom.getAllArguments()) {
                if (!(head == null ? !VariableUtils.isVariable(head = obj) : head.equals(obj))) continue;
                return Collections.emptySet();
            }
            if (head == null) {
                return Collections.emptySet();
            }
            return Collections.singleton((AtomVariable)((Object)head));
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            Collection<AtomVariable> vars = VariableUtils.getVars(this.atom);
            vars.removeAll(this.getBindableVars(bound));
            return vars;
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            this.used = false;
            this.head = null;
            this.value = null;
            Literal resultLit = null;
            if (this.atom.getAllArguments().size() == 0) {
                return;
            }
            Literal[] arguments = new Literal[this.atom.getAllArguments().size() - 1];
            int i = 0;
            for (AtomDObject obj : this.atom.getAllArguments()) {
                Literal lit = newBinding.get(obj);
                if (i == 0) {
                    if (lit != null) {
                        resultLit = lit;
                    }
                    this.head = obj;
                    ++i;
                    continue;
                }
                arguments[i - 1] = lit;
                ++i;
            }
            this.value = FunctionBuiltIn.this.function.apply(newBinding.getABox(), resultLit, arguments);
        }

        @Override
        public boolean selectNextBinding() {
            if (this.value != null && !this.used) {
                this.used = true;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
            currentBinding.set(this.head, this.value);
        }
    }
}

