/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.text.RestrictedTextDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class RDFPlainLiteral
extends AbstractBaseDatatype<ATermAppl> {
    private static final RDFPlainLiteral instance = new RDFPlainLiteral();
    private final RestrictedTextDatatype dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, true);

    public static RDFPlainLiteral getInstance() {
        return instance;
    }

    private RDFPlainLiteral() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof ATermAppl) {
            ATermAppl literal = (ATermAppl)value;
            try {
                return this.getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        this.getLexicalForm(literal);
        return literal;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }
}

