/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.fsm;

import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.fsm.Transition;

public class State<T> {
    private static int next_unused_name = 0;
    private int name = next_unused_name++;
    private Set<Transition<T>> transitions = new HashSet<Transition<T>>();

    public void addTransition(T symbol, State<T> s) {
        if (symbol == null || s == null) {
            throw new NullPointerException();
        }
        if (!(symbol instanceof Role)) {
            throw new ClassCastException();
        }
        Transition<T> t = new Transition<T>(symbol, s);
        this.transitions.add(t);
    }

    public void addTransition(State<T> s) {
        if (s == null) {
            throw new NullPointerException();
        }
        Transition<T> t = new Transition<T>(s);
        this.transitions.add(t);
    }

    public Set<Transition<T>> getTransitions() {
        return this.transitions;
    }

    public State<T> move(T symbol) {
        for (Transition<T> t : this.transitions) {
            if (!t.hasName(symbol)) continue;
            return t.getTo();
        }
        return null;
    }

    public int getName() {
        return this.name;
    }

    public void setName(int i) {
        this.name = i;
    }

    public String toString() {
        return String.valueOf(this.name);
    }
}

