/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDString
extends BaseAtomicDatatype
implements AtomicDatatype {
    private static final String STRING_DT_NAME = "http://www.w3.org/2001/XMLSchema#string";
    public static XSDString instance = new XSDString();

    XSDString() {
        super(ATermUtils.makeTermAppl(STRING_DT_NAME));
    }

    @Override
    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    @Override
    public Object getValue(String value, String datatypeURI) {
        assert (value != null && datatypeURI != null) : "Null inputs";
        assert (datatypeURI.equals("") || datatypeURI.equals(STRING_DT_NAME)) : "Unexpected datatype";
        return datatypeURI.equals(STRING_DT_NAME) || datatypeURI.equals("") ? ATermUtils.makeTypedLiteral(value, STRING_DT_NAME) : ATermUtils.makePlainLiteral(value);
    }

    @Override
    public boolean contains(Object value) {
        ATermAppl a;
        if (value instanceof ATermAppl && ATermUtils.isLiteral(a = (ATermAppl)value)) {
            String dt = ATermUtils.getLiteralDatatype(a);
            String lang = ATermUtils.getLiteralLang(a);
            return (dt.equals("") || lang.equals("") && dt.equals(STRING_DT_NAME)) && super.contains(value);
        }
        return false;
    }

    public Datatype deriveByRestriction(String facet, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("xsd:string does not support facet " + facet);
    }
}

