/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.mindswap.pellet.datatypes.AbstractValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDDouble
extends BaseXSDAtomicType
implements AtomicDatatype {
    private static XSDatatype dt = null;
    private static final Object min;
    private static final Object zero;
    private static final Object max;
    private static final ValueSpace DOUBLE_VALUE_SPACE;
    public static final XSDDouble instance;

    protected XSDDouble(ATermAppl name) {
        super(name, DOUBLE_VALUE_SPACE);
    }

    @Override
    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDDouble type = new XSDDouble(null);
        type.values = intervals;
        return type;
    }

    @Override
    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"double");
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        min = Double.NEGATIVE_INFINITY;
        zero = 0.0;
        max = Double.POSITIVE_INFINITY;
        DOUBLE_VALUE_SPACE = new DoubleValueSpace();
        instance = new XSDDouble(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double"));
    }

    private static class DoubleValueSpace
    extends AbstractValueSpace
    implements ValueSpace {
        public DoubleValueSpace() {
            super(min, zero, max, true);
        }

        @Override
        public boolean isValid(Object value) {
            return value instanceof Double;
        }

        @Override
        public Object getValue(String literal) {
            return dt.createValue(literal, null);
        }

        @Override
        public String getLexicalForm(Object value) {
            return dt.convertToLexicalValue(value, null);
        }

        @Override
        public int compare(Object a, Object b) {
            Integer cmp = this.compareInternal(a, b);
            if (cmp != null) {
                return cmp;
            }
            return NumberUtils.compare((Number)a, (Number)b);
        }

        @Override
        public int count(Object start, Object end) {
            Integer cmp = this.countInternal(start, end);
            if (cmp != null) {
                return cmp;
            }
            long count = (long)(((Double)end - (Double)start) / Double.MIN_VALUE);
            return count > Integer.MAX_VALUE ? -1 : (int)count;
        }

        @Override
        public Object succ(Object start, int n) {
            if (this.isInfinite(start)) {
                throw new IllegalArgumentException("Cannot handle infinite values");
            }
            return NumberUtils.add((Number)start, n);
        }
    }
}

