/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDDate
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace DATE_VALUE_SPACE;
    public static XSDDate instance;

    protected XSDDate(ATermAppl name) {
        super(name, DATE_VALUE_SPACE);
    }

    @Override
    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDDate type = new XSDDate(null);
        type.values = intervals;
        return type;
    }

    @Override
    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"date");
            min = (IDateTimeValueType)dt.createValue("-9999-01-01", null);
            max = (IDateTimeValueType)dt.createValue("9999-12-31", null);
        }
        catch (DatatypeException e) {
            e.printStackTrace();
        }
        DATE_VALUE_SPACE = new DateValueSpace();
        instance = new XSDDate(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#date"));
    }

    private static class DateValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public DateValueSpace() {
            super(min, max, dt);
        }

        @Override
        public int count(Object start, Object end) {
            double milliElapsed = ((IDateTimeValueType)end).toCalendar().getTimeInMillis() - ((IDateTimeValueType)start).toCalendar().getTimeInMillis();
            double daysElapsed = milliElapsed / 24.0 / 3600.0 / 1000.0;
            return Math.round((float)Math.round(daysElapsed * 100.0) / 100.0f);
        }

        @Override
        public Object succ(Object value, int n) {
            BigInteger bigN = new BigInteger(String.valueOf(n));
            BigTimeDurationValueType nMonths = new BigTimeDurationValueType(NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, bigN, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.DECIMAL_ZERO);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nMonths);
            return s;
        }
    }
}

