/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeFacet;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.QNameProvider;

public abstract class BaseXSDAtomicType
extends BaseDatatype
implements XSDAtomicType {
    protected GenericIntervalList values;
    protected ValueSpace valueSpace;

    protected BaseXSDAtomicType(ATermAppl name, ValueSpace valueSpace) {
        super(name);
        this.valueSpace = valueSpace;
        this.values = new GenericIntervalList(valueSpace.getMinValue(), valueSpace.getMaxValue(), valueSpace);
    }

    public abstract BaseXSDAtomicType create(GenericIntervalList var1);

    public ValueSpace getValueSpace() {
        return this.valueSpace;
    }

    @Override
    public Object getValue(String value, String datatypeURI) {
        try {
            Object obj = this.valueSpace.getValue(value.trim());
            return obj != null && this.values.contains(obj) ? obj : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public AtomicDatatype not() {
        return this.getPrimitiveType().difference(this);
    }

    @Override
    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (dt instanceof BaseXSDAtomicType) {
            BaseXSDAtomicType other = (BaseXSDAtomicType)dt;
            GenericIntervalList original = new GenericIntervalList(this.values);
            Iterator it = other.values.iterator();
            while (it.hasNext()) {
                GenericIntervalList.Interval interval = (GenericIntervalList.Interval)it.next();
                GenericIntervalList o = new GenericIntervalList(original);
                o.restrictToInterval(interval);
                result.addIntervalList(o);
            }
        }
        return this.create(result);
    }

    @Override
    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (dt instanceof BaseXSDAtomicType) {
            BaseXSDAtomicType other = (BaseXSDAtomicType)dt;
            result.addIntervalList(this.values);
            result.addIntervalList(other.values);
        }
        return this.create(result);
    }

    @Override
    public AtomicDatatype difference(AtomicDatatype dt) {
        if (this == dt) {
            return EmptyDatatype.instance;
        }
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        if (dt instanceof BaseXSDAtomicType) {
            BaseXSDAtomicType other = (BaseXSDAtomicType)dt;
            result.addIntervalList(this.values);
            result.removeIntervalList(other.values);
        }
        return this.create(result);
    }

    public AtomicDatatype enumeration(Set enum_) {
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        for (Number number : enum_) {
            result.addInterval(number, number);
        }
        return this.create(result);
    }

    @Override
    public Datatype singleton(Object value) {
        GenericIntervalList result = new GenericIntervalList(this.valueSpace);
        result.addInterval(value, value);
        return this.create(result);
    }

    @Override
    public int size() {
        return this.values.count();
    }

    @Override
    public ATermAppl getValue(int i) {
        Object value = this.values.get(i);
        String lexical = this.valueSpace.getLexicalForm(value);
        return ATermUtils.makeTypedLiteral(lexical, this.getPrimitiveType().getURI());
    }

    @Override
    public boolean contains(Object value) {
        if (this.valueSpace.isValid(value)) {
            return this.values.contains(value);
        }
        return false;
    }

    @Override
    public XSDAtomicType deriveByRestriction(DatatypeFacet facet, Object value) throws UnsupportedOperationException {
        try {
            Object start = this.valueSpace.getMinValue();
            Object end = this.valueSpace.getMaxValue();
            boolean incStart = true;
            boolean incEnd = true;
            if (facet == DatatypeFacet.minInclusive) {
                start = value;
            } else if (facet == DatatypeFacet.minExclusive) {
                start = value;
                incStart = false;
            } else if (facet == DatatypeFacet.maxInclusive) {
                end = value;
            } else if (facet == DatatypeFacet.maxExclusive) {
                end = value;
                incEnd = false;
            } else {
                return this;
            }
            GenericIntervalList intervalList = new GenericIntervalList(this.values);
            intervalList.restrictToInterval(start, incStart, end, incEnd);
            return this.create(intervalList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Value " + value + " is not valid for the facet " + (Object)((Object)facet));
        }
    }

    @Override
    public XSDAtomicType restrictMin(boolean inclusive, Object value) {
        return inclusive ? this.deriveByRestriction(DatatypeFacet.minInclusive, value) : this.deriveByRestriction(DatatypeFacet.minExclusive, value);
    }

    @Override
    public XSDAtomicType restrictMinInclusive(Object value) {
        return this.deriveByRestriction(DatatypeFacet.minInclusive, value);
    }

    @Override
    public XSDAtomicType restrictMinExclusive(Object value) {
        return this.deriveByRestriction(DatatypeFacet.minExclusive, value);
    }

    @Override
    public XSDAtomicType restrictMax(boolean inclusive, Object value) {
        return inclusive ? this.deriveByRestriction(DatatypeFacet.maxInclusive, value) : this.deriveByRestriction(DatatypeFacet.maxExclusive, value);
    }

    @Override
    public XSDAtomicType restrictMaxInclusive(Object value) {
        return this.deriveByRestriction(DatatypeFacet.maxInclusive, value);
    }

    @Override
    public XSDAtomicType restrictMaxExclusive(Object value) {
        return this.deriveByRestriction(DatatypeFacet.maxExclusive, value);
    }

    @Override
    public XSDAtomicType restrictPattern(String pattern) {
        return this.deriveByRestriction(DatatypeFacet.pattern, pattern);
    }

    @Override
    public XSDAtomicType restrictLength(int length) {
        return this.deriveByRestriction(DatatypeFacet.length, length);
    }

    @Override
    public XSDAtomicType restrictMinLength(int length) {
        return this.deriveByRestriction(DatatypeFacet.minLength, length);
    }

    @Override
    public XSDAtomicType restrictMaxLength(int length) {
        return this.deriveByRestriction(DatatypeFacet.maxLength, length);
    }

    public String toString() {
        QNameProvider qnames = new QNameProvider();
        String str = this.name == null ? qnames.shortForm(this.getPrimitiveType().getName().toString()) + " " + this.values : qnames.shortForm(this.name.toString());
        return str;
    }
}

