/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategyImpl;
import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.RuleBranch;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;

public class RuleStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;

    public RuleStrategy(ABox abox) {
        super(abox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(abox);
    }

    public void applyRULERule() {
        for (Rule rule : this.abox.getKB().getRules()) {
            int total = 0;
            for (VariableBinding binding : this.bindingStrategy.createGenerator(rule)) {
                ++total;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Binding: " + binding);
                    log.fine("total:" + total);
                }
                if (this.abox.isClosed()) continue;
                this.createDisjunctionsFromBinding(binding, rule);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("total bindings:" + total);
            log.fine("branches:" + this.abox.getBranch());
        }
    }

    @Override
    public void complete(Expressivity expr) {
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        this.initialize(expressivity);
        if (!this.abox.ranRete && this.abox.rulesNotApplied) {
            Interpreter interp = new Interpreter(this.abox);
            RulesToReteTranslator translator = new RulesToReteTranslator(this.abox);
            RulesToATermTranslator atermTranslator = new RulesToATermTranslator();
            for (Rule rule : this.abox.getKB().getRules()) {
                com.clarkparsia.pellet.rules.rete.Rule reteRule = translator.translateRule(rule);
                if (reteRule == null) continue;
                Set<ATermAppl> explain = this.abox.doExplanation() ? rule.getExplanation(atermTranslator) : Collections.emptySet();
                interp.rete.compile(reteRule, explain);
            }
            interp.rete.compileFacts(this.abox);
            Set<Fact> inferred = interp.run();
            if (log.isLoggable(Level.FINE)) {
                log.fine(inferred.size() + " inferred fact(s)");
            }
            DependencySet ds = DependencySet.INDEPENDENT;
            for (Fact f : inferred) {
                Node to;
                Individual ind2;
                Individual ind1;
                ATermAppl pred = (ATermAppl)f.getElements().get(0);
                ATermAppl subj = (ATermAppl)f.getElements().get(1);
                ATermAppl obj = (ATermAppl)f.getElements().get(2);
                if (pred.equals(Compiler.TYPE)) {
                    Individual ind = this.abox.getIndividual((ATerm)subj);
                    ATermAppl type = obj;
                    ind.addType(type, ds);
                    continue;
                }
                if (pred.equals(Compiler.SAME_AS)) {
                    ind1 = this.abox.getIndividual((ATerm)subj);
                    ind2 = this.abox.getIndividual((ATerm)obj);
                    ind1.setSame(ind2, DependencySet.INDEPENDENT);
                    continue;
                }
                if (pred.equals(Compiler.DIFF_FROM)) {
                    ind1 = this.abox.getIndividual((ATerm)subj);
                    ind2 = this.abox.getIndividual((ATerm)obj);
                    ind1.setDifferent(ind2, DependencySet.INDEPENDENT);
                    continue;
                }
                Role r = this.abox.getRole((ATerm)pred);
                Individual from = this.abox.getIndividual((ATerm)subj);
                if (r != null && r.isObjectRole()) {
                    to = this.abox.getIndividual((ATerm)obj);
                } else if (r != null && r.isDatatypeRole()) {
                    to = this.abox.getLiteral((ATerm)obj);
                    if (to == null) {
                        to = this.abox.addLiteral(obj);
                    }
                } else {
                    log.warning("Ignoring non object or datatype role " + pred);
                    continue;
                }
                this.addEdge(from, r, to, ds);
            }
            this.abox.ranRete = true;
        }
        while (!this.abox.isComplete()) {
            while (this.abox.isChanged() && !this.abox.isClosed()) {
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.stats.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                for (TableauRule tableauRule : this.tableauRules) {
                    tableauRule.apply(i);
                    if (!this.abox.isClosed()) continue;
                    break;
                }
                if (this.abox.isClosed() || !this.abox.rulesNotApplied) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Applying RULE rule at branch:" + this.abox.getBranch());
                }
                this.abox.rulesNotApplied = false;
                this.applyRULERule();
            }
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = this.abox.getBranches().get(i);
                    unexploredBranch.setTryNext(unexploredBranch.getTryNext() + 1);
                    if (unexploredBranch.getTryNext() < unexploredBranch.getTryCount()) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.getBranch() + " tryNext = " + unexploredBranch.getTryNext() + " tryCount = " + unexploredBranch.getTryCount());
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.getBranch());
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
    }

    private boolean isDisjunct(RuleAtom atom) {
        return !(atom instanceof BuiltInAtom) && !(atom instanceof DataRangeAtom);
    }

    private void createDisjunctionsFromBinding(VariableBinding binding, Rule rule) {
        TrivialSatisfactionHelpers atomTester = new TrivialSatisfactionHelpers(this.abox);
        RuleAtomAsserter ruleAtomAsserter = new RuleAtomAsserter();
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            if (!this.isDisjunct(ruleAtom)) continue;
            atoms.add(ruleAtom);
        }
        int bodyAtomCount = atoms.size();
        for (RuleAtom ruleAtom : rule.getHead()) {
            if (!this.isDisjunct(ruleAtom) || atomTester.isAtomTrue(ruleAtom, binding) != null) continue;
            atoms.add(ruleAtom);
        }
        if (atoms.size() == bodyAtomCount) {
            return;
        }
        RuleBranch ruleBranch = new RuleBranch(this.abox, this, ruleAtomAsserter, atoms, binding, bodyAtomCount, DependencySet.INDEPENDENT);
        this.addBranch(ruleBranch);
        ruleBranch.tryNext();
    }

    @Override
    public void restoreLocal(Individual ind, Branch br) {
        this.restore(br);
    }
}

