/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class AbstractOWLMetric<M>
implements OWLMetric<M>,
OWLOntologyChangeListener {
    private final OWLOntologyManager owlOntologyManager;
    private OWLOntology ontology;
    private boolean dirty;
    private boolean importsClosureUsed;
    private M value;

    public AbstractOWLMetric(OWLOntologyManager owlOntologyManager) {
        this.owlOntologyManager = owlOntologyManager;
        owlOntologyManager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.dirty = true;
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public final void setOntology(OWLOntology ontology) {
        this.ontology = ontology;
        this.setDirty(true);
    }

    protected abstract M recomputeMetric();

    @Override
    public final M getValue() {
        if (this.dirty) {
            this.value = this.recomputeMetric();
        }
        return this.value;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Set<OWLOntology> getOntologies() {
        if (this.importsClosureUsed) {
            return this.owlOntologyManager.getImportsClosure(this.ontology);
        }
        return Collections.singleton(this.ontology);
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        if (this.isMetricInvalidated(changes)) {
            this.setDirty(true);
        }
    }

    @Override
    public OWLOntologyManager getManager() {
        return this.owlOntologyManager;
    }

    @Override
    public void dispose() {
        this.owlOntologyManager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.disposeMetric();
    }

    @Override
    public final boolean isImportsClosureUsed() {
        return this.importsClosureUsed;
    }

    @Override
    public void setImportsClosureUsed(boolean b) {
        this.importsClosureUsed = b;
        if (this.ontology != null) {
            this.recomputeMetric();
        }
    }

    protected abstract boolean isMetricInvalidated(List<? extends OWLOntologyChange> var1);

    protected abstract void disposeMetric();

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }
}

