/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class CreateValuePartition
extends AbstractCompositeOntologyChange {
    private List<OWLOntologyChange> changes;
    private final OWLOntology targetOntology;
    private final Set<OWLClass> valuePartionClasses;
    private final OWLClass valuePartitionClass;
    private final OWLObjectProperty valuePartitionProperty;

    public CreateValuePartition(OWLDataFactory dataFactory, OWLClass valuePartitionClass, Set<OWLClass> valuePartionClasses, OWLObjectProperty valuePartitionProperty, OWLOntology targetOntology) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.valuePartionClasses = valuePartionClasses;
        this.valuePartitionClass = valuePartitionClass;
        this.valuePartitionProperty = valuePartitionProperty;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        for (OWLClassExpression oWLClassExpression : this.valuePartionClasses) {
            this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLSubClassOfAxiom(oWLClassExpression, (OWLClassExpression)this.valuePartitionClass)));
        }
        this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLDisjointClassesAxiom(this.valuePartionClasses)));
        OWLObjectUnionOf union = this.getDataFactory().getOWLObjectUnionOf(this.valuePartionClasses);
        this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)this.valuePartitionClass, (OWLClassExpression)union)));
        this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.valuePartitionProperty)));
        this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.valuePartitionProperty, (OWLClassExpression)this.valuePartitionClass)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

