/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class ConvertEquivalentClassesToSuperClasses
extends AbstractCompositeOntologyChange {
    private final OWLOntology targetOntology;
    private final OWLClass cls;
    private final Set<OWLOntology> ontologies;
    private final boolean splitIntersections;
    private List<OWLOntologyChange> changes;

    public ConvertEquivalentClassesToSuperClasses(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology, boolean splitIntersections) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.cls = cls;
        this.ontologies = ontologies;
        this.splitIntersections = splitIntersections;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLClassExpression> supers = new HashSet<OWLClassExpression>();
        for (OWLOntology o : this.ontologies) {
            for (OWLEquivalentClassesAxiom ax : o.getEquivalentClassesAxioms(this.cls)) {
                this.changes.add((OWLOntologyChange)new RemoveAxiom(o, (OWLAxiom)ax));
                for (OWLClassExpression equivCls : ax.getClassExpressions()) {
                    supers.addAll(this.getClassExpressions(equivCls));
                }
            }
        }
        supers.remove(this.cls);
        for (OWLClassExpression sup : supers) {
            this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)this.cls, sup)));
        }
    }

    private Set<OWLClassExpression> getClassExpressions(OWLClassExpression desc) {
        final HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        if (this.splitIntersections) {
            desc.accept((OWLClassExpressionVisitor)new OWLClassExpressionVisitorAdapter(){

                public void visit(OWLObjectIntersectionOf intersection) {
                    for (OWLClassExpression op : intersection.getOperands()) {
                        result.add(op);
                    }
                }
            });
        }
        if (result.isEmpty()) {
            result.add(desc);
        }
        return result;
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

