/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.modularity.locality;

import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class SemanticLocalityEvaluator
implements LocalityEvaluator {
    protected static final Logger log = Logger.getLogger(SemanticLocalityEvaluator.class.getName());
    protected final OWLDataFactory df;
    private final AxiomLocalityVisitor axiomVisitor = new AxiomLocalityVisitor();
    private final BottomReplacer bottomReplacer = new BottomReplacer();
    protected final OWLReasoner reasoner;

    public SemanticLocalityEvaluator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory) {
        this.df = man.getOWLDataFactory();
        try {
            this.reasoner = reasonerFactory.createNonBufferingReasoner(man.createOntology());
        }
        catch (Exception e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Replacing axiom by Bottom");
        }
        OWLAxiom newAxiom = this.bottomReplacer.replaceBottom(axiom, signature);
        if (log.isLoggable(Level.FINE)) {
            log.fine("DONE Replacing axiom by Bottom. Success: " + (newAxiom != null));
        }
        return newAxiom != null && this.axiomVisitor.isLocal(newAxiom);
    }

    private class BottomReplacer
    extends OWLAxiomVisitorAdapter
    implements OWLAxiomVisitor,
    OWLClassExpressionVisitor {
        private OWLAxiom newAxiom;
        private OWLClassExpression newClassExpression;
        private Set<? extends OWLEntity> signature;

        public OWLAxiom getResult() {
            return this.newAxiom;
        }

        public OWLAxiom replaceBottom(OWLAxiom axiom, Set<? extends OWLEntity> sig) {
            this.reset(sig);
            axiom.accept((OWLAxiomVisitor)this);
            return this.getResult();
        }

        public OWLClassExpression replaceBottom(OWLClassExpression desc) {
            this.newClassExpression = null;
            desc.accept((OWLClassExpressionVisitor)this);
            if (this.newClassExpression == null) {
                throw new RuntimeException("Unsupported class expression " + desc);
            }
            return this.newClassExpression;
        }

        public Set<OWLClassExpression> replaceBottom(Set<OWLClassExpression> classExpressions) {
            HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
            for (OWLClassExpression desc : classExpressions) {
                result.add(this.replaceBottom(desc));
            }
            return result;
        }

        public void reset(Set<? extends OWLEntity> s) {
            this.signature = s;
            this.newAxiom = null;
        }

        public void visit(OWLClass desc) {
            this.newClassExpression = this.signature.contains(desc) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this.newClassExpression = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        public void visit(OWLDataExactCardinality desc) {
            this.newClassExpression = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.newClassExpression = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        public void visit(OWLDataMinCardinality desc) {
            this.newClassExpression = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this.newClassExpression = this.signature.contains(((OWLDataPropertyExpression)desc.getProperty()).asOWLDataProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLDataHasValue desc) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLDisjointClassesAxiom ax) {
            Set<OWLClassExpression> disjointclasses = this.replaceBottom(ax.getClassExpressions());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLDisjointClassesAxiom(disjointclasses);
        }

        public void visit(OWLEquivalentClassesAxiom ax) {
            Set<OWLClassExpression> eqclasses = this.replaceBottom(ax.getClassExpressions());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLEquivalentClassesAxiom(eqclasses);
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this.newClassExpression = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? SemanticLocalityEvaluator.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), this.replaceBottom((OWLClassExpression)desc.getFiller())) : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        public void visit(OWLObjectComplementOf desc) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLObjectComplementOf(this.replaceBottom(desc.getOperand()));
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.newClassExpression = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLObjectIntersectionOf desc) {
            Set operands = desc.getOperands();
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLObjectIntersectionOf(this.replaceBottom(operands));
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.newClassExpression = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.newClassExpression = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? desc : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLObjectOneOf desc) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLObjectHasSelf desc) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.newClassExpression = this.signature.contains(((OWLObjectPropertyExpression)desc.getProperty()).getNamedProperty()) ? SemanticLocalityEvaluator.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), this.replaceBottom((OWLClassExpression)desc.getFiller())) : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLObjectUnionOf desc) {
            Set operands = desc.getOperands();
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLObjectUnionOf(this.replaceBottom(operands));
        }

        public void visit(OWLObjectHasValue desc) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        public void visit(OWLSubClassOfAxiom ax) {
            OWLClassExpression sup = this.replaceBottom(ax.getSuperClass());
            OWLClassExpression sub = this.replaceBottom(ax.getSubClass());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLSubClassOfAxiom(sub, sup);
        }
    }

    private class AxiomLocalityVisitor
    extends OWLAxiomVisitorAdapter
    implements OWLAxiomVisitor {
        private boolean isLocal;

        public boolean isLocal() {
            return this.isLocal;
        }

        public boolean isLocal(OWLAxiom axiom) {
            this.reset();
            axiom.accept((OWLAxiomVisitor)this);
            return this.isLocal();
        }

        public void reset() {
            this.isLocal = false;
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Calling the Reasoner");
            }
            this.isLocal = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine("DONE Calling the Reasoner. isLocal = " + this.isLocal);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set eqClasses = axiom.getClassExpressions();
            if (eqClasses.size() != 2) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Calling the Reasoner");
            }
            this.isLocal = SemanticLocalityEvaluator.this.reasoner.isEntailed((OWLAxiom)axiom);
            if (log.isLoggable(Level.FINE)) {
                log.fine("DONE Calling the Reasoner. isLocal = " + this.isLocal);
            }
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Calling the Reasoner");
            }
            this.isLocal = SemanticLocalityEvaluator.this.reasoner.isEntailed((OWLAxiom)axiom);
            if (log.isLoggable(Level.FINE)) {
                log.fine("DONE Calling the Reasoner. isLocal = " + this.isLocal);
            }
        }
    }
}

