/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class DefinitionTracker
implements OWLOntologyChangeListener {
    private final Map<OWLEntity, Integer> referenceCounts = new HashMap<OWLEntity, Integer>();
    private final OWLOntology ontology;
    private final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
    private final OWLOntologyManager manager;
    private final Integer ONE = 1;

    public DefinitionTracker(OWLOntology ontology) {
        this.manager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        for (OWLOntology ont : ontology.getImportsClosure()) {
            for (OWLOntology importOnt : this.manager.getImportsClosure(ont)) {
                for (OWLAxiom axiom : importOnt.getAxioms()) {
                    this.addAxiom(axiom);
                }
            }
        }
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    private void addAxiom(OWLAxiom axiom) {
        if (this.axioms.add(axiom)) {
            for (OWLEntity entity : this.getEntities((OWLObject)axiom)) {
                Integer count = this.referenceCounts.get(entity);
                count = count == null ? this.ONE : Integer.valueOf(count + 1);
                this.referenceCounts.put(entity, count);
            }
        }
    }

    private Set<OWLEntity> getEntities(OWLObject obj) {
        return obj.getSignature();
    }

    private void removeAxiom(OWLAxiom axiom) {
        if (this.axioms.remove(axiom)) {
            for (OWLEntity entity : this.getEntities((OWLObject)axiom)) {
                Integer count = this.referenceCounts.get(entity);
                if (count == 1) {
                    this.referenceCounts.remove(entity);
                    continue;
                }
                this.referenceCounts.put(entity, count - 1);
            }
        }
    }

    public boolean isDefined(OWLEntity entity) {
        return entity.isBuiltIn() || this.referenceCounts.containsKey(entity);
    }

    public boolean isDefined(OWLClassExpression classExpression) {
        for (OWLEntity entity : this.getEntities((OWLObject)classExpression)) {
            if (this.isDefined(entity)) continue;
            return false;
        }
        return true;
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !this.ontology.getImportsClosure().contains(oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange.isAddAxiom()) {
                this.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange.isRemoveAxiom()) {
                this.removeAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }
}

