/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.turtle.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.formats.TurtleOntologyFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserIOException;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ConsoleTripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.OWLRDFConsumerAdapter;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ParseException;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParser;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParserException;

public class TurtleOntologyParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, UnloadableImportException, IOException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        Reader reader = null;
        InputStream is = null;
        try {
            TurtleParser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new TurtleParser(reader, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString());
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new TurtleParser(is, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString());
            } else {
                is = new BufferedInputStream(documentSource.getDocumentIRI().toURI().toURL().openStream());
                parser = new TurtleParser(is, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString());
            }
            OWLRDFConsumerAdapter consumer = new OWLRDFConsumerAdapter(ontology, parser, configuration);
            TurtleOntologyFormat format = new TurtleOntologyFormat();
            consumer.setOntologyFormat((RDFOntologyFormat)format);
            parser.setTripleHandler(consumer);
            parser.parseDocument();
            DefaultPrefixManager prefixManager = parser.getPrefixManager();
            for (String prefixName : prefixManager.getPrefixNames()) {
                format.setPrefix(prefixName, prefixManager.getPrefix(prefixName));
            }
            TurtleOntologyFormat turtleOntologyFormat = format;
            return turtleOntologyFormat;
        }
        catch (ParseException e) {
            throw new TurtleParserException(e);
        }
        catch (IOException e) {
            throw new OWLParserIOException(e);
        }
        finally {
            if (is != null) {
                is.close();
            } else if (reader != null) {
                reader.close();
            }
        }
    }

    public Set<OWLOntologyFormatFactory> getSupportedFormats() {
        HashSet<OWLOntologyFormatFactory> result = new HashSet<OWLOntologyFormatFactory>();
        result.add((OWLOntologyFormatFactory)new TurtleOntologyFormatFactory());
        return result;
    }
}

