/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.ListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

public class OptimisedListTranslator<O extends OWLObject> {
    private static final Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());
    private OWLRDFConsumer consumer;
    private ListItemTranslator<O> translator;

    protected OptimisedListTranslator(OWLRDFConsumer consumer, ListItemTranslator<O> translator) {
        this.consumer = consumer;
        this.translator = translator;
    }

    protected OWLRDFConsumer getConsumer() {
        return this.consumer;
    }

    private void translateList(IRI mainNode, List<O> list) {
        IRI current = mainNode;
        while (current != null) {
            IRI firstResource = this.consumer.getFirstResource(current, true);
            if (firstResource != null) {
                list.add(this.translator.translate(firstResource));
            } else {
                OWLLiteral literal = this.consumer.getFirstLiteral(current);
                if (literal != null) {
                    O translate = this.translator.translate(literal);
                    if (translate != null) {
                        list.add(translate);
                    }
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Possible malformed list: rdf:first triple missing");
                }
            }
            current = this.consumer.getRest(current, true);
        }
    }

    public List<O> translateList(IRI mainNode) {
        List list;
        boolean shared = this.consumer.isSharedAnonymousNode(mainNode);
        if (shared) {
            Object o = this.consumer.getSharedAnonymousNode(mainNode);
            if (o != null && o instanceof List) {
                list = (List)o;
            } else {
                list = new CopyOnWriteArrayList();
                this.translateList(mainNode, list);
                this.consumer.addSharedAnonymousNode(mainNode, list);
            }
        } else {
            list = new CopyOnWriteArrayList();
            this.translateList(mainNode, list);
        }
        return list;
    }

    public Set<O> translateToSet(IRI mainNode) {
        return new HashSet<O>(this.translateList(mainNode));
    }
}

