/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractLiteralTripleHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;

public class GTPAnnotationLiteralHandler
extends AbstractLiteralTripleHandler {
    public GTPAnnotationLiteralHandler(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, OWLLiteral object) {
        return !this.isAnonymous(subject) && !this.getConsumer().isAnnotation(subject) && this.getConsumer().isAnnotationProperty(predicate);
    }

    @Override
    public boolean canHandle(IRI subject, IRI predicate, OWLLiteral object) {
        if (this.isStrict()) {
            return this.isAnnotationPropertyOnly(predicate);
        }
        boolean axiom = this.getConsumer().isUnrecognisedRdfTypeAxiom(subject);
        if (axiom) {
            return false;
        }
        boolean annotation = this.getConsumer().isAnnotation(subject);
        if (annotation) {
            return false;
        }
        if (this.getConsumer().isAnnotationProperty(predicate)) {
            return true;
        }
        if (!this.isAnonymous(subject)) {
            if (this.isClassExpressionLax(subject)) {
                return true;
            }
            if (this.isDataRangeLax(subject)) {
                return true;
            }
            if (this.isObjectPropertyLax(subject)) {
                return true;
            }
            if (this.isDataPropertyLax(subject)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, OWLLiteral object) {
        this.consumeTriple(subject, predicate, object);
        OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(predicate);
        Object annotationSubject = this.isAnonymous(subject) ? this.getDataFactory().getOWLAnonymousIndividual(subject.toString()) : subject;
        if (this.getConsumer().isOntology(subject)) {
            this.getConsumer().addOntologyAnnotation(this.getDataFactory().getOWLAnnotation(prop, (OWLAnnotationValue)object, this.getPendingAnnotations()));
        } else {
            OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(prop, (OWLAnnotationSubject)annotationSubject, (OWLAnnotationValue)object, this.getPendingAnnotations());
            this.addAxiom((OWLAxiom)ax);
        }
    }
}

