/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.owlapi.rdf.rdfxml.RDFXMLNamespaceManager;
import org.coode.owlapi.rdf.rdfxml.RDFXMLWriter;
import org.coode.owlapi.rdf.renderer.RDFRendererBase;
import org.coode.xml.XMLWriterFactory;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFXMLRenderer
extends RDFRendererBase {
    private RDFXMLWriter writer;
    private Set<RDFResource> pending = new HashSet<RDFResource>();
    private RDFXMLNamespaceManager qnameManager;
    private OWLOntologyFormat format;

    @Deprecated
    public RDFXMLRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer w) {
        this(ontology, w, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    public RDFXMLRenderer(OWLOntology ontology, Writer w) {
        this(ontology, w, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    @Deprecated
    public RDFXMLRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer w, OWLOntologyFormat format) {
        this(ontology, w, format);
    }

    public RDFXMLRenderer(OWLOntology ontology, Writer w, OWLOntologyFormat format) {
        super(ontology, format);
        this.qnameManager = new RDFXMLNamespaceManager(ontology, format);
        String defaultNamespace = this.qnameManager.getDefaultNamespace();
        String base = defaultNamespace.endsWith("#") ? defaultNamespace.substring(0, defaultNamespace.length() - 1) : defaultNamespace;
        this.writer = new RDFXMLWriter(XMLWriterFactory.getInstance().createXMLWriter(w, this.qnameManager, base));
        this.prettyPrintedTypes = new HashSet();
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_THING.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_AXIOM.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
    }

    public Set<OWLEntity> getUnserialisableEntities() {
        return this.qnameManager.getEntitiesWithInvalidQNames();
    }

    @Override
    protected void beginDocument() throws IOException {
        this.writer.startDocument();
    }

    @Override
    protected void endDocument() throws IOException {
        this.writer.endDocument();
        this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (this.format instanceof RDFOntologyFormat && !((RDFOntologyFormat)this.format).isAddMissingTypes()) {
            this.writer.writeComment("Warning: type declarations were not added automatically.");
        }
    }

    @Override
    protected void writeIndividualComments(OWLNamedIndividual ind) throws IOException {
        this.writer.writeComment(XMLUtils.escapeXML((CharSequence)ind.getIRI().toString()));
    }

    @Override
    protected void writeClassComment(OWLClass cls) throws IOException {
        this.writer.writeComment(XMLUtils.escapeXML((CharSequence)cls.getIRI().toString()));
    }

    @Override
    protected void writeDataPropertyComment(OWLDataProperty prop) throws IOException {
        this.writer.writeComment(XMLUtils.escapeXML((CharSequence)prop.getIRI().toString()));
    }

    @Override
    protected void writeObjectPropertyComment(OWLObjectProperty prop) throws IOException {
        this.writer.writeComment(XMLUtils.escapeXML((CharSequence)prop.getIRI().toString()));
    }

    @Override
    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) throws IOException {
        this.writer.writeComment(XMLUtils.escapeXML((CharSequence)prop.getIRI().toString()));
    }

    @Override
    protected void writeDatatypeComment(OWLDatatype datatype) throws IOException {
        this.writer.writeComment(XMLUtils.escapeXML((CharSequence)datatype.getIRI().toString()));
    }

    @Override
    protected void writeBanner(String name) throws IOException {
        this.writer.writeComment("\n///////////////////////////////////////////////////////////////////////////////////////\n//\n// " + name + "\n" + "//\n" + "///////////////////////////////////////////////////////////////////////////////////////\n");
    }

    @Override
    public void render(RDFResource node) throws IOException {
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        RDFTriple candidatePrettyPrintTypeTriple = null;
        List<RDFTriple> triples = this.getGraph().getSortedTriplesForSubject((RDFNode)node, true);
        for (RDFTriple triple : triples) {
            IRI propertyIRI = triple.getProperty().getIRI();
            if (!propertyIRI.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(triple.getObject().getIRI()) || !this.prettyPrintedTypes.contains(triple.getObject().getIRI())) continue;
            candidatePrettyPrintTypeTriple = triple;
        }
        if (candidatePrettyPrintTypeTriple == null) {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
        } else {
            this.writer.writeStartElement(candidatePrettyPrintTypeTriple.getObject().getIRI());
        }
        if (!node.isAnonymous()) {
            this.writer.writeAboutAttribute(node.getIRI());
        }
        for (RDFTriple triple : triples) {
            if (candidatePrettyPrintTypeTriple != null && candidatePrettyPrintTypeTriple.equals((Object)triple)) continue;
            this.writer.writeStartElement(triple.getProperty().getIRI());
            RDFNode objectNode = triple.getObject();
            if (!objectNode.isLiteral()) {
                RDFResource objectRes = (RDFResource)objectNode;
                if (objectRes.isAnonymous()) {
                    if (this.isObjectList(objectRes)) {
                        this.writer.writeParseTypeAttribute();
                        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                        this.toJavaList((RDFNode)objectRes, list);
                        for (RDFNode n : list) {
                            if (n.isAnonymous()) {
                                this.render((RDFResource)((RDFResourceBlankNode)n));
                                continue;
                            }
                            if (n.isLiteral()) {
                                RDFLiteral litNode = (RDFLiteral)n;
                                this.writer.writeStartElement(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
                                if (litNode.getDatatype() != null) {
                                    this.writer.writeDatatypeAttribute(litNode.getDatatype());
                                } else if (litNode.getLang() != null) {
                                    this.writer.writeLangAttribute(litNode.getLang());
                                }
                                this.writer.writeTextContent(litNode.getLiteral());
                                this.writer.writeEndElement();
                                continue;
                            }
                            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
                            this.writer.writeAboutAttribute(n.getIRI());
                            this.writer.writeEndElement();
                        }
                    } else {
                        this.render(objectRes);
                    }
                } else {
                    this.writer.writeResourceAttribute(objectRes.getIRI());
                }
            } else {
                RDFLiteral rdfLiteralNode = (RDFLiteral)objectNode;
                if (rdfLiteralNode.getDatatype() != null) {
                    this.writer.writeDatatypeAttribute(rdfLiteralNode.getDatatype());
                } else if (rdfLiteralNode.getLang() != null) {
                    this.writer.writeLangAttribute(rdfLiteralNode.getLang());
                }
                this.writer.writeTextContent(rdfLiteralNode.getLiteral());
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.pending.remove(node);
    }
}

